/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import android.os.Process;
import com.google.firebase.sessions.ProcessData;
import com.google.firebase.sessions.ProcessDataManager;
import com.google.firebase.sessions.ProcessDetails;
import com.google.firebase.sessions.ProcessDetailsProvider;
import com.google.firebase.sessions.UuidGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u001c\u0010 \u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u0010!\u001a\u00020\"H\u0016J*\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001e2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0002J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0013\u0010\u000bR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/google/firebase/sessions/ProcessDataManagerImpl;", "Lcom/google/firebase/sessions/ProcessDataManager;", "appContext", "Landroid/content/Context;", "uuidGenerator", "Lcom/google/firebase/sessions/UuidGenerator;", "<init>", "(Landroid/content/Context;Lcom/google/firebase/sessions/UuidGenerator;)V", "myProcessName", "", "getMyProcessName", "()Ljava/lang/String;", "myProcessName$delegate", "Lkotlin/Lazy;", "myPid", "", "getMyPid", "()I", "myUuid", "getMyUuid", "myUuid$delegate", "myProcessDetails", "Lcom/google/firebase/sessions/ProcessDetails;", "getMyProcessDetails", "()Lcom/google/firebase/sessions/ProcessDetails;", "myProcessDetails$delegate", "hasGeneratedSession", "", "isColdStart", "processDataMap", "", "Lcom/google/firebase/sessions/ProcessData;", "isMyProcessStale", "onSessionGenerated", "", "updateProcessDataMap", "getAppProcessDetails", "", "isProcessStale", "processDetails", "processData", "com.google.firebase-firebase-sessions"})
@SourceDebugExtension(value={"SMAP\nProcessDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDataManager.kt\ncom/google/firebase/sessions/ProcessDataManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1611#2,9:124\n1863#2:133\n1864#2:135\n1620#2:136\n1734#2,3:137\n1#3:134\n1#3:140\n*S KotlinDebug\n*F\n+ 1 ProcessDataManager.kt\ncom/google/firebase/sessions/ProcessDataManagerImpl\n*L\n78#1:124,9\n78#1:133\n78#1:135\n78#1:136\n83#1:137,3\n78#1:134\n*E\n"})
public final class ProcessDataManagerImpl
implements ProcessDataManager {
    @NotNull
    private final Context appContext;
    @NotNull
    private final Lazy myProcessName$delegate;
    private final int myPid;
    @NotNull
    private final Lazy myUuid$delegate;
    @NotNull
    private final Lazy myProcessDetails$delegate;
    private boolean hasGeneratedSession;

    @Inject
    public ProcessDataManagerImpl(@NotNull Context appContext, @NotNull UuidGenerator uuidGenerator) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)uuidGenerator, (String)"uuidGenerator");
        this.appContext = appContext;
        this.myProcessName$delegate = LazyKt.lazy(() -> ProcessDataManagerImpl.myProcessName_delegate$lambda$0(this));
        this.myPid = Process.myPid();
        this.myUuid$delegate = LazyKt.lazy(() -> ProcessDataManagerImpl.myUuid_delegate$lambda$1(uuidGenerator));
        this.myProcessDetails$delegate = LazyKt.lazy(() -> ProcessDataManagerImpl.myProcessDetails_delegate$lambda$2(this));
    }

    @Override
    @NotNull
    public String getMyProcessName() {
        Lazy lazy = this.myProcessName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public int getMyPid() {
        return this.myPid;
    }

    @Override
    @NotNull
    public String getMyUuid() {
        Lazy lazy = this.myUuid$delegate;
        return (String)lazy.getValue();
    }

    private final ProcessDetails getMyProcessDetails() {
        Lazy lazy = this.myProcessDetails$delegate;
        return (ProcessDetails)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isColdStart(@NotNull Map<String, ProcessData> processDataMap) {
        boolean bl;
        block7: {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(processDataMap, (String)"processDataMap");
            if (this.hasGeneratedSession) {
                return false;
            }
            Iterable $this$mapNotNull$iv = this.getAppProcessDetails();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                ProcessDetails processDetails = (ProcessDetails)element$iv$iv;
                boolean bl3 = false;
                if (processDataMap.get(processDetails.getProcessName()) != null) {
                    ProcessData processData;
                    boolean bl4 = false;
                    pair = new Pair((Object)processDetails, (Object)processData);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ProcessData processData;
                    Pair pair = (Pair)element$iv;
                    boolean bl6 = false;
                    ProcessDetails processDetails = (ProcessDetails)pair.component1();
                    if (this.isProcessStale(processDetails, processData = (ProcessData)pair.component2())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isMyProcessStale(@NotNull Map<String, ProcessData> processDataMap) {
        Intrinsics.checkNotNullParameter(processDataMap, (String)"processDataMap");
        ProcessData processData = processDataMap.get(this.getMyProcessName());
        if (processData == null) {
            return true;
        }
        ProcessData myProcessData = processData;
        return myProcessData.getPid() != this.getMyPid() || !Intrinsics.areEqual((Object)myProcessData.getUuid(), (Object)this.getMyUuid());
    }

    @Override
    public void onSessionGenerated() {
        this.hasGeneratedSession = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, ProcessData> updateProcessDataMap(@Nullable Map<String, ProcessData> processDataMap) {
        Map map;
        Map map2;
        if (processDataMap != null && (map2 = MapsKt.toMutableMap(processDataMap)) != null) {
            Map map3;
            Map $this$updateProcessDataMap_u24lambda_u246 = map3 = map2;
            boolean bl = false;
            $this$updateProcessDataMap_u24lambda_u246.put(this.getMyProcessName(), new ProcessData(Process.myPid(), this.getMyUuid()));
            map3 = MapsKt.toMap((Map)map3);
            if (map3 != null) {
                map = map3;
                return map;
            }
        }
        map = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.getMyProcessName(), (Object)new ProcessData(Process.myPid(), this.getMyUuid())));
        return map;
    }

    private final List<ProcessDetails> getAppProcessDetails() {
        return ProcessDetailsProvider.INSTANCE.getAppProcessDetails(this.appContext);
    }

    private final boolean isProcessStale(ProcessDetails processDetails, ProcessData processData) {
        return Intrinsics.areEqual((Object)this.getMyProcessName(), (Object)processDetails.getProcessName()) ? processDetails.getPid() != processData.getPid() || !Intrinsics.areEqual((Object)this.getMyUuid(), (Object)processData.getUuid()) : processDetails.getPid() != processData.getPid();
    }

    @Override
    @NotNull
    public Map<String, ProcessData> generateProcessDataMap() {
        return ProcessDataManager.DefaultImpls.generateProcessDataMap(this);
    }

    private static final String myProcessName_delegate$lambda$0(ProcessDataManagerImpl this$0) {
        return this$0.getMyProcessDetails().getProcessName();
    }

    private static final String myUuid_delegate$lambda$1(UuidGenerator $uuidGenerator) {
        String string = $uuidGenerator.next().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final ProcessDetails myProcessDetails_delegate$lambda$2(ProcessDataManagerImpl this$0) {
        return ProcessDetailsProvider.INSTANCE.getMyProcessDetails(this$0.appContext);
    }
}

