/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.AppCheckTokenListener;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.emulators.EmulatedServiceSettings;
import com.google.firebase.inject.Provider;
import com.google.firebase.storage.FirebaseStorageComponent;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.Util;
import java.io.UnsupportedEncodingException;

public class FirebaseStorage {
    private static final String TAG = "FirebaseStorage";
    private static final String STORAGE_URI_PARSE_EXCEPTION = "The storage Uri could not be parsed.";
    private static final String STORAGE_BUCKET_WITH_PATH_EXCEPTION = "The storage Uri cannot contain a path element.";
    @NonNull
    private final FirebaseApp mApp;
    @Nullable
    private final Provider<InternalAuthProvider> mAuthProvider;
    @Nullable
    private final Provider<InteropAppCheckTokenProvider> mAppCheckProvider;
    @Nullable
    private final String mBucketName;
    private long sMaxUploadRetry = 600000L;
    private long sMaxChunkUploadRetry = 60000L;
    private long sMaxDownloadRetry = 600000L;
    private long sMaxQueryRetry = 120000L;
    @Nullable
    private EmulatedServiceSettings emulatorSettings;

    FirebaseStorage(@Nullable String bucketName, @NonNull FirebaseApp app, @Nullable Provider<InternalAuthProvider> authProvider, @Nullable Provider<InteropAppCheckTokenProvider> appCheckProvider) {
        this.mBucketName = bucketName;
        this.mApp = app;
        this.mAuthProvider = authProvider;
        this.mAppCheckProvider = appCheckProvider;
        if (this.mAppCheckProvider != null && this.mAppCheckProvider.get() != null) {
            ((InteropAppCheckTokenProvider)this.mAppCheckProvider.get()).addAppCheckTokenListener(new AppCheckTokenListener(){

                public void onAppCheckTokenChanged(@NonNull AppCheckTokenResult appCheckTokenResult) {
                }
            });
        }
    }

    private static FirebaseStorage getInstanceImpl(@NonNull FirebaseApp app, @Nullable Uri url) {
        String bucketName;
        String string = bucketName = url != null ? url.getHost() : null;
        if (url != null && !TextUtils.isEmpty((CharSequence)url.getPath())) {
            throw new IllegalArgumentException(STORAGE_BUCKET_WITH_PATH_EXCEPTION);
        }
        Preconditions.checkNotNull((Object)app, (Object)"Provided FirebaseApp must not be null.");
        FirebaseStorageComponent component = (FirebaseStorageComponent)app.get(FirebaseStorageComponent.class);
        Preconditions.checkNotNull((Object)component, (Object)"Firebase Storage component is not present.");
        return component.get(bucketName);
    }

    @NonNull
    public static FirebaseStorage getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (app != null);
        return FirebaseStorage.getInstance(app);
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull String url) {
        FirebaseApp app = FirebaseApp.getInstance();
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (app != null);
        return FirebaseStorage.getInstance(app, url);
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        String storageBucket = app.getOptions().getStorageBucket();
        if (storageBucket == null) {
            return FirebaseStorage.getInstanceImpl(app, null);
        }
        try {
            return FirebaseStorage.getInstanceImpl(app, Util.normalize(app, "gs://" + app.getOptions().getStorageBucket()));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Unable to parse bucket:" + storageBucket), (Throwable)e);
            throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
        }
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp app, @NonNull String url) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the Firebase Storage URL.");
        if (!url.toLowerCase().startsWith("gs://")) {
            throw new IllegalArgumentException("Please use a gs:// URL for your Firebase Storage bucket.");
        }
        try {
            return FirebaseStorage.getInstanceImpl(app, Util.normalize(app, url));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Unable to parse url:" + url), (Throwable)e);
            throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
        }
    }

    public void useEmulator(@NonNull String host, int port) {
        this.emulatorSettings = new EmulatedServiceSettings(host, port);
    }

    public long getMaxDownloadRetryTimeMillis() {
        return this.sMaxDownloadRetry;
    }

    public void setMaxDownloadRetryTimeMillis(long maxTransferRetryMillis) {
        this.sMaxDownloadRetry = maxTransferRetryMillis;
    }

    public long getMaxUploadRetryTimeMillis() {
        return this.sMaxUploadRetry;
    }

    public void setMaxUploadRetryTimeMillis(long maxTransferRetryMillis) {
        this.sMaxUploadRetry = maxTransferRetryMillis;
    }

    public long getMaxChunkUploadRetry() {
        return this.sMaxChunkUploadRetry;
    }

    public void setMaxChunkUploadRetry(long maxChunkRetryMillis) {
        this.sMaxChunkUploadRetry = maxChunkRetryMillis;
    }

    public long getMaxOperationRetryTimeMillis() {
        return this.sMaxQueryRetry;
    }

    public void setMaxOperationRetryTimeMillis(long maxTransferRetryMillis) {
        this.sMaxQueryRetry = maxTransferRetryMillis;
    }

    @Nullable
    private String getBucketName() {
        return this.mBucketName;
    }

    @NonNull
    public StorageReference getReference() {
        String bucketName = this.getBucketName();
        if (TextUtils.isEmpty((CharSequence)bucketName)) {
            throw new IllegalStateException("FirebaseApp was not initialized with a bucket name.");
        }
        Uri uri = new Uri.Builder().scheme("gs").authority(this.getBucketName()).path("/").build();
        return this.getReference(uri);
    }

    @NonNull
    public StorageReference getReferenceFromUrl(@NonNull String fullUrl) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)fullUrl) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String lowerCaseLocation = fullUrl.toLowerCase();
        if (lowerCaseLocation.startsWith("gs://") || lowerCaseLocation.startsWith("https://") || lowerCaseLocation.startsWith("http://")) {
            try {
                Uri uri = Util.normalize(this.mApp, fullUrl);
                if (uri == null) {
                    throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
                }
                return this.getReference(uri);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)("Unable to parse location:" + fullUrl), (Throwable)e);
                throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
            }
        }
        throw new IllegalArgumentException(STORAGE_URI_PARSE_EXCEPTION);
    }

    @NonNull
    public StorageReference getReference(@NonNull String location) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)location) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String lowerCaseLocation = location.toLowerCase();
        if (lowerCaseLocation.startsWith("gs://") || lowerCaseLocation.startsWith("https://") || lowerCaseLocation.startsWith("http://")) {
            throw new IllegalArgumentException("location should not be a full URL.");
        }
        return this.getReference().child(location);
    }

    @NonNull
    private StorageReference getReference(@NonNull Uri uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri must not be null");
        String bucketName = this.getBucketName();
        Preconditions.checkArgument((TextUtils.isEmpty((CharSequence)bucketName) || uri.getAuthority().equalsIgnoreCase(bucketName) ? 1 : 0) != 0, (Object)"The supplied bucketname does not match the storage bucket of the current instance.");
        return new StorageReference(uri, this);
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.mApp;
    }

    @Nullable
    InternalAuthProvider getAuthProvider() {
        return this.mAuthProvider != null ? (InternalAuthProvider)this.mAuthProvider.get() : null;
    }

    @Nullable
    InteropAppCheckTokenProvider getAppCheckProvider() {
        return this.mAppCheckProvider != null ? (InteropAppCheckTokenProvider)this.mAppCheckProvider.get() : null;
    }

    @Nullable
    EmulatedServiceSettings getEmulatorSettings() {
        return this.emulatorSettings;
    }
}

