/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.inject.Provider;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageTaskScheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

class FirebaseStorageComponent {
    private final Map<String, FirebaseStorage> instances = new HashMap<String, FirebaseStorage>();
    private final FirebaseApp app;
    @Nullable
    private final Provider<InternalAuthProvider> authProvider;
    @Nullable
    private final Provider<InteropAppCheckTokenProvider> appCheckProvider;

    FirebaseStorageComponent(@NonNull FirebaseApp app, @Nullable Provider<InternalAuthProvider> authProvider, @Nullable Provider<InteropAppCheckTokenProvider> appCheckProvider, @NonNull @Blocking Executor blockingExecutor, @NonNull @UiThread Executor uiExecutor) {
        this.app = app;
        this.authProvider = authProvider;
        this.appCheckProvider = appCheckProvider;
        StorageTaskScheduler.initializeExecutors(blockingExecutor, uiExecutor);
    }

    @NonNull
    synchronized FirebaseStorage get(@Nullable String bucketName) {
        FirebaseStorage storage = this.instances.get(bucketName);
        if (storage == null) {
            storage = new FirebaseStorage(bucketName, this.app, this.authProvider, this.appCheckProvider);
            this.instances.put(bucketName, storage);
        }
        return storage;
    }

    @VisibleForTesting
    synchronized void clearInstancesForTesting() {
        this.instances.clear();
    }
}

