/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.pose.internal;

import android.graphics.Bitmap;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_pose_common.zzbm;
import com.google.android.gms.internal.mlkit_vision_pose_common.zzbx;
import com.google.android.gms.internal.mlkit_vision_pose_common.zzcb;
import com.google.android.gms.internal.mlkit_vision_pose_common.zzej;
import com.google.android.gms.internal.mlkit_vision_pose_common.zzep;
import com.google.android.gms.internal.mlkit_vision_pose_common.zzgd;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MLTaskInput;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.mediapipe.Converter;
import com.google.mlkit.vision.mediapipe.MediaPipeGraphRunner;
import com.google.mlkit.vision.mediapipe.MediaPipeGraphRunnerConfig;
import com.google.mlkit.vision.mediapipe.MediaPipeInput;
import com.google.mlkit.vision.mediapipe.MediaPipeInputFactory;
import com.google.mlkit.vision.mediapipe.pose.PoseHolder;
import com.google.mlkit.vision.mediapipe.pose.PoseHolderConverter;
import com.google.mlkit.vision.mediapipe.utils.ImageConvertNativeUtils;
import com.google.mlkit.vision.pose.Pose;
import com.google.mlkit.vision.pose.PoseDetectorOptionsBase;
import com.google.mlkit.vision.pose.internal.zzb;
import com.google.mlkit.vision.pose.internal.zzd;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public final class zzc
extends MLTask<Pose, InputImage> {
    private String zza;
    private String zzb;
    @Nullable
    private MediaPipeGraphRunner zzc;
    private final zzej zzd;
    private final MlKitContext zze;
    private final PoseDetectorOptionsBase zzf;
    private final zzbm.zzba zzg;
    private static boolean zzh = true;
    private static final ImageUtils zzi = ImageUtils.getInstance();

    public zzc(@NonNull MlKitContext mlKitContext, @NonNull PoseDetectorOptionsBase poseDetectorOptionsBase) {
        Preconditions.checkNotNull((Object)mlKitContext, (Object)"MlKitContext can not be null");
        Preconditions.checkNotNull((Object)poseDetectorOptionsBase, (Object)"PoseDetectorOptionsBase can not be null");
        this.zzd = (zzej)mlKitContext.get(zzej.class);
        this.zze = mlKitContext;
        this.zzf = poseDetectorOptionsBase;
        this.zzg = poseDetectorOptionsBase.zzd();
        this.zza = poseDetectorOptionsBase.zzb();
        this.zzb = poseDetectorOptionsBase.zzc();
    }

    @WorkerThread
    public final void load() throws MlKitException {
        if (this.zzc == null) {
            this.zza(zzcb.zzb);
            zzc zzc2 = this;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("$POSE_DETECTOR_MODEL", zzc2.zza);
            hashMap.put("$POSE_LANDMARKS_MODEL", zzc2.zzb);
            zzc2.zzc = new MediaPipeGraphRunner(MediaPipeGraphRunnerConfig.create((MlKitContext)zzc2.zze, (String)(zzc2.zzf.zza() == 1 ? "mlkit_pose/pose_tracking_graph.binarypb" : "mlkit_pose/pose_non_tracking_graph.binarypb"), (String)"input_frames", (String)"output_pose_landmarks", hashMap, (MediaPipeGraphRunnerConfig.ResultType)MediaPipeGraphRunnerConfig.ResultType.PROTO));
            ((MediaPipeGraphRunner)Preconditions.checkNotNull((Object)this.zzc)).load();
        }
    }

    public final void release() {
        if (this.zzc != null) {
            this.zzc.close();
            this.zzc = null;
        }
        this.zza(zzcb.zzd);
        zzh = true;
    }

    @WorkerThread
    private final void zza(zzcb zzcb2) {
        this.zzd.zza(zzbm.zzad.zzb().zza(true).zza((zzbm.zzaz)((zzgd)zzbm.zzaz.zza().zza(this.zzg).zzh())), zzcb2);
    }

    @WorkerThread
    @NonNull
    public final /* synthetic */ Object run(@NonNull MLTaskInput mLTaskInput) throws MlKitException {
        MediaPipeInput mediaPipeInput;
        InputImage inputImage = (InputImage)mLTaskInput;
        zzc zzc2 = this;
        long l = SystemClock.elapsedRealtime();
        byte[] byArray = ImageConvertNativeUtils.getRgbBuffer((InputImage)inputImage);
        if (byArray == null) {
            mediaPipeInput = MediaPipeInputFactory.getMediaPipeInput((Bitmap)ImageConvertUtils.getInstance().getUpRightBitmap(inputImage), (long)TimeUnit.MICROSECONDS.convert(l, TimeUnit.MILLISECONDS));
        } else {
            int n = inputImage.getWidth();
            int n2 = inputImage.getHeight();
            if (inputImage.getRotationDegrees() / 90 % 2 == 1) {
                n = inputImage.getHeight();
                n2 = inputImage.getWidth();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            mediaPipeInput = MediaPipeInputFactory.getMediaPipeInput((ByteBuffer)byteBuffer, (int)n, (int)n2, (long)TimeUnit.MICROSECONDS.convert(l, TimeUnit.MILLISECONDS));
        }
        PoseHolder poseHolder = (PoseHolder)((MediaPipeGraphRunner)Preconditions.checkNotNull((Object)zzc2.zzc)).run(mediaPipeInput, (Converter)new PoseHolderConverter());
        zzbx zzbx2 = poseHolder.getPoseLandmarkHolders().isEmpty() ? zzbx.zzb : zzbx.zza;
        InputImage inputImage2 = inputImage;
        zzbx zzbx3 = zzbx2;
        zzc zzc3 = zzc2;
        long l2 = SystemClock.elapsedRealtime() - l;
        zzb zzb2 = new zzb(zzc3, l2, zzbx3, inputImage2);
        zzc3.zzd.zza(zzb2, zzcb.zzc);
        zzbm.zzg.zza zza2 = (zzbm.zzg.zza)((zzgd)zzbm.zzg.zza.zza().zza(zzc3.zzg).zza(zzbx3).zza(zzh).zza(zzep.zza(zzi.getMobileVisionImageFormat(inputImage2), zzi.getMobileVisionImageSize(inputImage2))).zzh());
        zzej.zzb zzb3 = com.google.mlkit.vision.pose.internal.zzd.zza;
        zzc3.zzd.zza(zza2, l2, zzcb.zze, zzb3);
        zzh = false;
        return new Pose(poseHolder);
    }

    static final /* synthetic */ zzbm.zzad.zza zza(zzbm.zzg.zza zza2, int n, zzbm.zzab zzab2) {
        return zzbm.zzad.zzb().zza(true).zza(zzbm.zzg.zza().zza(n).zza(zza2).zza(zzab2));
    }

    final /* synthetic */ zzbm.zzad.zza zza(long l, zzbx zzbx2, InputImage inputImage) {
        return zzbm.zzad.zzb().zza(true).zza(zzbm.zzaz.zza().zza(zzbm.zzaf.zza().zza(l).zza(zzbx2).zza(zzh).zzb(true).zzc(true)).zza(zzep.zza(zzi.getMobileVisionImageFormat(inputImage), zzi.getMobileVisionImageSize(inputImage))).zza(this.zzg));
    }
}

