/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.text2speech.core;

import com.hiservice.text2speech.core.HttpRequestBuilderKt;
import com.hiservice.text2speech.core.SpeechToTextKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ<\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/hiservice/text2speech/core/ServerSpeechToText;", "", "<init>", "()V", "recognizeBytes", "", "appKey", "base64Content", "languageCode", "encoding", "sampleRateHertz", "", "enableWordTimeOffsets", "", "createRequestContent", "fun-speech2text_release"})
public final class ServerSpeechToText {
    @NotNull
    public final String recognizeBytes(@NotNull String appKey, @NotNull String base64Content, @NotNull String languageCode, @NotNull String encoding, int sampleRateHertz, boolean enableWordTimeOffsets) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Intrinsics.checkNotNullParameter((Object)base64Content, (String)"base64Content");
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        String content = this.createRequestContent(appKey, base64Content, encoding, sampleRateHertz, languageCode, enableWordTimeOffsets);
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.Companion.create(content, mediaType);
        HttpUrl httpUrl = HttpUrl.Companion.get("https://api.translasion.com/v1/speech2text");
        OkHttpClient client = HttpRequestBuilderKt.buildOkHttpClient();
        Request request = new Request.Builder().url(httpUrl).post(requestBody).build();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        String body = responseBody != null ? responseBody.string() : null;
        SpeechToTextKt.log("body==" + body);
        if (response.isSuccessful() && body != null) {
            return body;
        }
        throw new Exception(response.message());
    }

    public static /* synthetic */ String recognizeBytes$default(ServerSpeechToText serverSpeechToText, String string, String string2, String string3, String string4, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string4 = "LINEAR16";
        }
        if ((n2 & 0x10) != 0) {
            n = 16000;
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        return serverSpeechToText.recognizeBytes(string, string2, string3, string4, n, bl);
    }

    private final String createRequestContent(String appKey, String base64Content, String encoding, int sampleRateHertz, String languageCode, boolean enableWordTimeOffsets) {
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = "abcd";
        String sig = "abcdef";
        JSONObject json = new JSONObject();
        json.put("app_key", (Object)appKey);
        json.put("data", (Object)base64Content);
        json.put("timestamp", timestamp);
        json.put("nonce", (Object)nonce);
        json.put("sig", (Object)sig);
        JSONObject config = new JSONObject();
        config.put("encoding", (Object)encoding);
        config.put("sampleRateHertz", sampleRateHertz);
        config.put("languageCode", (Object)languageCode);
        config.put("enableWordTimeOffsets", enableWordTimeOffsets);
        json.put("config", (Object)config);
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String createRequestContent$default(ServerSpeechToText serverSpeechToText, String string, String string2, String string3, int n, String string4, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = "LINEAR16";
        }
        if ((n2 & 8) != 0) {
            n = 16000;
        }
        return serverSpeechToText.createRequestContent(string, string2, string3, n, string4, bl);
    }
}

