/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.text2speech.core.google;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import com.hiservice.text2speech.core.google.IResultCallback;
import com.hiservice.text2speech.core.google.ParamModeDownload;
import com.hiservice.text2speech.core.google.ParamStart;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0007J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u00020\u000f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020\u000fH\u0016J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u000fH\u0002J\u0012\u0010/\u001a\u00020\u000f2\b\u00100\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u00101\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u00010\"H\u0016J\u001a\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020-2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u00105\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/hiservice/text2speech/core/google/GoogleRecognition;", "Landroid/speech/RecognitionListener;", "DBG", "", "<init>", "(Z)V", "recognizer", "Landroid/speech/SpeechRecognizer;", "callback", "Lcom/hiservice/text2speech/core/google/IResultCallback;", "recognitionListener", "isOnDevice", "speechRetryIntent", "Landroid/content/Intent;", "init", "", "context", "Landroid/content/Context;", "resultCallback", "triggerModelDownload", "paramModeDownload", "Lcom/hiservice/text2speech/core/google/ParamModeDownload;", "start", "paramStart", "Lcom/hiservice/text2speech/core/google/ParamStart;", "stop", "speechStream2TextStartImpl", "stopImpl", "initSpeechRecognizer", "promptSpeechInput", "packageName", "", "onReadyForSpeech", "params", "Landroid/os/Bundle;", "onBeginningOfSpeech", "onRmsChanged", "rmsdB", "", "onBufferReceived", "buffer", "", "onEndOfSpeech", "onError", "error", "", "retry", "onResults", "results", "onPartialResults", "partialResults", "onEvent", "eventType", "modeDownloadIntent", "Companion", "fun-speech2text_release"})
@SourceDebugExtension(value={"SMAP\nGoogleRecognition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleRecognition.kt\ncom/hiservice/text2speech/core/google/GoogleRecognition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,314:1\n1869#2,2:315\n1869#2,2:317\n*S KotlinDebug\n*F\n+ 1 GoogleRecognition.kt\ncom/hiservice/text2speech/core/google/GoogleRecognition\n*L\n113#1:315,2\n281#1:317,2\n*E\n"})
public final class GoogleRecognition
implements RecognitionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean DBG;
    @Nullable
    private SpeechRecognizer recognizer;
    @Nullable
    private IResultCallback callback;
    @Nullable
    private RecognitionListener recognitionListener;
    private boolean isOnDevice;
    @Nullable
    private Intent speechRetryIntent;
    @NotNull
    private static final String TAG = "GoogleRecognition";

    public GoogleRecognition(boolean DBG) {
        this.DBG = DBG;
    }

    public /* synthetic */ GoogleRecognition(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @MainThread
    public final void init(@NotNull Context context, @Nullable IResultCallback resultCallback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SpeechRecognizer speechRecognizer = this.initSpeechRecognizer(context);
            if (speechRecognizer == null) {
                return;
            }
            this.recognizer = speechRecognizer;
            this.callback = resultCallback;
            this.recognitionListener = null;
            SpeechRecognizer speechRecognizer2 = this.recognizer;
            if (speechRecognizer2 == null) break block1;
            speechRecognizer2.setRecognitionListener((RecognitionListener)this);
        }
    }

    @MainThread
    public final void init(@NotNull Context context, @Nullable IResultCallback resultCallback, @Nullable RecognitionListener callback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SpeechRecognizer speechRecognizer = this.initSpeechRecognizer(context);
            if (speechRecognizer == null) {
                return;
            }
            this.recognizer = speechRecognizer;
            this.callback = resultCallback;
            this.recognitionListener = callback;
            SpeechRecognizer speechRecognizer2 = this.recognizer;
            if (speechRecognizer2 == null) break block1;
            speechRecognizer2.setRecognitionListener((RecognitionListener)this);
        }
    }

    public static /* synthetic */ void init$default(GoogleRecognition googleRecognition, Context context, IResultCallback iResultCallback, RecognitionListener recognitionListener, int n, Object object) {
        if ((n & 4) != 0) {
            recognitionListener = null;
        }
        googleRecognition.init(context, iResultCallback, recognitionListener);
    }

    @RequiresApi(value=33)
    public final void triggerModelDownload(@NotNull ParamModeDownload paramModeDownload) {
        block0: {
            SpeechRecognizer speechRecognizer;
            Intrinsics.checkNotNullParameter((Object)paramModeDownload, (String)"paramModeDownload");
            SpeechRecognizer speechRecognizer2 = this.recognizer;
            if (speechRecognizer2 == null) break block0;
            SpeechRecognizer $this$triggerModelDownload_u24lambda_u240 = speechRecognizer = speechRecognizer2;
            boolean bl = false;
            $this$triggerModelDownload_u24lambda_u240.triggerModelDownload(this.modeDownloadIntent(paramModeDownload));
        }
    }

    public final void start(@Nullable Context context, @Nullable ParamStart paramStart) {
        Context context2 = context;
        if (context2 == null) {
            return;
        }
        ParamStart paramStart2 = paramStart;
        if (paramStart2 == null) {
            return;
        }
        this.speechStream2TextStartImpl(context2, paramStart2);
    }

    public final void stop() {
        this.stopImpl();
    }

    private final void speechStream2TextStartImpl(Context context, ParamStart paramStart) {
        block0: {
            SpeechRecognizer speechRecognizer;
            SpeechRecognizer speechRecognizer2 = this.recognizer;
            if (speechRecognizer2 == null) break block0;
            SpeechRecognizer $this$speechStream2TextStartImpl_u24lambda_u241 = speechRecognizer = speechRecognizer2;
            boolean bl = false;
            String string = context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            Intent promptSpeechInput = this.promptSpeechInput(string, paramStart);
            this.speechRetryIntent = paramStart.getAutoRetry() ? promptSpeechInput : null;
            $this$speechStream2TextStartImpl_u24lambda_u241.startListening(promptSpeechInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopImpl() {
        try {
            SpeechRecognizer speechRecognizer = this.recognizer;
            if (speechRecognizer != null) {
                SpeechRecognizer speechRecognizer2;
                SpeechRecognizer $this$stopImpl_u24lambda_u242 = speechRecognizer2 = speechRecognizer;
                boolean bl = false;
                $this$stopImpl_u24lambda_u242.cancel();
                $this$stopImpl_u24lambda_u242.destroy();
            }
        }
        finally {
            this.speechRetryIntent = null;
            this.recognizer = null;
            if (this.DBG) {
                Log.v((String)TAG, (String)"stop:google recognition");
            }
        }
    }

    private final SpeechRecognizer initSpeechRecognizer(Context context) {
        boolean isRecognitionAvailable;
        if (this.DBG) {
            List list = context.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentServices(...)");
            List list2 = list;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResolveInfo it = (ResolveInfo)element$iv;
                boolean bl = false;
                if (it.serviceInfo != null) {
                    ServiceInfo service;
                    boolean bl2 = false;
                    Log.i((String)TAG, (String)("component pkg:$" + service.packageName + ", name:" + service.name));
                }
            }
        }
        if (!(isRecognitionAvailable = SpeechRecognizer.isRecognitionAvailable((Context)context))) {
            Log.e((String)TAG, (String)"isRecognitionAvailable = false!!!");
        }
        if (Build.VERSION.SDK_INT >= 31) {
            this.isOnDevice = SpeechRecognizer.isOnDeviceRecognitionAvailable((Context)context);
        }
        if (this.DBG) {
            Log.i((String)TAG, (String)("isOnDevice:" + this.isOnDevice + ", isRecognitionAvailable:" + isRecognitionAvailable));
        }
        if (this.isOnDevice && Build.VERSION.SDK_INT >= 31) {
            return SpeechRecognizer.createOnDeviceSpeechRecognizer((Context)context);
        }
        return SpeechRecognizer.createSpeechRecognizer((Context)context);
    }

    private final Intent promptSpeechInput(String packageName, ParamStart paramStart) {
        String languageCode = paramStart.getLanguageCode();
        boolean interimResults = paramStart.getInterimResults();
        Integer audioSource = paramStart.getAudioSource();
        if (this.DBG) {
            Log.i((String)TAG, (String)("start intent, languageCode:" + languageCode));
        }
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.PARTIAL_RESULTS", interimResults);
        intent.putExtra("calling_package", packageName);
        if (Build.VERSION.SDK_INT >= 23) {
            intent.putExtra("android.speech.extra.PREFER_OFFLINE", this.isOnDevice);
        }
        intent.putExtra("android.speech.extra.LANGUAGE", languageCode);
        return intent;
    }

    public void onReadyForSpeech(@Nullable Bundle params) {
        block0: {
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener == null) break block0;
            recognitionListener.onReadyForSpeech(params);
        }
    }

    public void onBeginningOfSpeech() {
        block0: {
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener == null) break block0;
            recognitionListener.onBeginningOfSpeech();
        }
    }

    public void onRmsChanged(float rmsdB) {
        block0: {
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener == null) break block0;
            recognitionListener.onRmsChanged(rmsdB);
        }
    }

    public void onBufferReceived(@Nullable byte[] buffer) {
        block0: {
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener == null) break block0;
            recognitionListener.onBufferReceived(buffer);
        }
    }

    public void onEndOfSpeech() {
        block1: {
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener != null) {
                recognitionListener.onEndOfSpeech();
            }
            SpeechRecognizer speechRecognizer = this.recognizer;
            if (speechRecognizer == null) break block1;
            speechRecognizer.stopListening();
        }
    }

    public void onError(int error) {
        String errorMsg;
        switch (error) {
            case 3: {
                String string = "error_audio_error";
                break;
            }
            case 5: {
                String string = "error_client";
                break;
            }
            case 9: {
                String string = "error_permission";
                break;
            }
            case 2: {
                String string = "error_network";
                break;
            }
            case 1: {
                String string = "error_network_timeout";
                break;
            }
            case 7: {
                String string = "error_no_match";
                break;
            }
            case 8: {
                String string = "error_busy";
                break;
            }
            case 4: {
                String string = "error_server";
                break;
            }
            case 6: {
                String string = "error_speech_timeout";
                break;
            }
            case 12: {
                String string = "error_language_not_supported";
                break;
            }
            case 13: {
                String string = "error_language_unavailable";
                break;
            }
            case 11: {
                String string = "error_server_disconnected";
                break;
            }
            case 10: {
                String string = "error_too_many_requests";
                break;
            }
            default: {
                String string = errorMsg = "error_unknown (" + error + ')';
            }
        }
        if (this.DBG) {
            Log.e((String)TAG, (String)("onError: error:" + error + ", msg:" + errorMsg));
        }
        RecognitionListener recognitionListener = this.recognitionListener;
        if (recognitionListener != null) {
            recognitionListener.onError(error);
        }
        if (7 == error) {
            this.retry();
        }
    }

    private final void retry() {
        block1: {
            Intent intent = this.speechRetryIntent;
            if (intent == null) break block1;
            Intent it = intent;
            boolean bl = false;
            SpeechRecognizer speechRecognizer = this.recognizer;
            if (speechRecognizer != null) {
                speechRecognizer.startListening(it);
            }
        }
    }

    public void onResults(@Nullable Bundle results) {
        block12: {
            ArrayList arrayList;
            block11: {
                Unit unit;
                Bundle bundle = results;
                ArrayList texts = bundle != null ? bundle.getStringArrayList("results_recognition") : null;
                arrayList = texts;
                if (arrayList == null) break block11;
                boolean bl = false;
                float[] scores = results.getFloatArray("confidence_scores");
                StringBuilder sb = new StringBuilder();
                int size = texts.size();
                for (int i = 0; i < size; ++i) {
                    Float score;
                    String itemTxt = (String)texts.get(i);
                    Float f = score = scores != null ? Float.valueOf(scores[i]) : null;
                    if (this.DBG) {
                        Log.d((String)TAG, (String)("onResults: txt:" + itemTxt + ", scores:" + score));
                    }
                    if (((CharSequence)sb).length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(itemTxt);
                }
                IResultCallback iResultCallback = this.callback;
                if (iResultCallback != null) {
                    iResultCallback.onResult(sb.toString());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                arrayList = unit;
                if (unit != null) break block12;
            }
            boolean bl = false;
            IResultCallback iResultCallback = this.callback;
            if (iResultCallback != null) {
                iResultCallback.onResult(null);
                arrayList = Unit.INSTANCE;
            } else {
                arrayList = null;
            }
        }
        RecognitionListener recognitionListener = this.recognitionListener;
        if (recognitionListener != null) {
            recognitionListener.onResults(results);
        }
        this.retry();
    }

    public void onPartialResults(@Nullable Bundle partialResults) {
        block5: {
            Bundle bundle = partialResults;
            ArrayList texts = bundle != null ? bundle.getStringArrayList("results_recognition") : null;
            StringBuilder sb = new StringBuilder();
            ArrayList arrayList = texts;
            if (arrayList != null) {
                Iterable $this$forEach$iv = arrayList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (this.DBG) {
                        Log.v((String)TAG, (String)("onPartialResults: txt:" + it));
                    }
                    if (((CharSequence)sb).length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(it);
                }
            }
            IResultCallback iResultCallback = this.callback;
            if (iResultCallback != null) {
                iResultCallback.onPartResult(sb.toString());
            }
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener == null) break block5;
            recognitionListener.onPartialResults(partialResults);
        }
    }

    public void onEvent(int eventType, @Nullable Bundle params) {
        block0: {
            RecognitionListener recognitionListener = this.recognitionListener;
            if (recognitionListener == null) break block0;
            recognitionListener.onEvent(eventType, params);
        }
    }

    private final Intent modeDownloadIntent(ParamModeDownload paramModeDownload) {
        String languageCode = paramModeDownload.getLanguageCode();
        if (this.DBG) {
            Log.i((String)TAG, (String)("start download intent:" + languageCode));
        }
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE", languageCode);
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        return intent;
    }

    public GoogleRecognition() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/text2speech/core/google/GoogleRecognition$Companion;", "", "<init>", "()V", "TAG", "", "fun-speech2text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

