/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.text2speech.longrecognize.impl;

import android.util.Log;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageLite;
import com.hiservice.text2speech.longrecognize.AudioInfo;
import com.hiservice.text2speech.longrecognize.AudioToTextInfo;
import com.hiservice.text2speech.longrecognize.InfoAlternative;
import com.hiservice.text2speech.longrecognize.InfoDuration;
import com.hiservice.text2speech.longrecognize.InfoResult;
import com.hiservice.text2speech.longrecognize.InfoWordInfo;
import com.hiservice.text2speech.longrecognize.interfaces.IReceiveStream;
import com.hiservice.text2speech.longrecognize.interfaces.ISpeed2Text;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import request.Speech2Text;
import request.SpeechServerV3Grpc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u001bH\u0002J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020 H\u0002J \u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u001d2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u001dH\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010\"\u001a\u00020&H\u0002J \u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u001d2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010\u001dH\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010\"\u001a\u00020+H\u0002J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00104\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\b\u00105\u001a\u00020\u000eH\u0016J\b\u00106\u001a\u00020\u000eH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/hiservice/text2speech/longrecognize/impl/Speed2TextImpl;", "Lcom/hiservice/text2speech/longrecognize/interfaces/ISpeed2Text;", "<init>", "()V", "channel", "Lio/grpc/ManagedChannel;", "client", "Lrequest/SpeechServerV3Grpc$SpeechServerV3Stub;", "mIReceiveStream", "Lcom/hiservice/text2speech/longrecognize/interfaces/IReceiveStream;", "mInputStream", "Lio/grpc/stub/StreamObserver;", "Lrequest/Speech2Text$MultiRequest;", "initParam", "", "start", "receiveStream", "createStream", "toAudioTextInfo", "Lcom/hiservice/text2speech/longrecognize/AudioToTextInfo;", "value", "Lrequest/Speech2Text$Reply;", "toDuration", "Lcom/hiservice/text2speech/longrecognize/InfoDuration;", "duration", "Lrequest/Speech2Text$Duration;", "Lrequest/Speech2Text$StartTime;", "Lrequest/Speech2Text$EndTime;", "toResultList", "", "Lcom/hiservice/text2speech/longrecognize/InfoResult;", "list", "Lrequest/Speech2Text$Sresult;", "toInfoResult", "item", "toAlternativesList", "Lcom/hiservice/text2speech/longrecognize/InfoAlternative;", "alternativesList", "Lrequest/Speech2Text$Alternative;", "toInfoAlternative", "toWordInfoList", "Lcom/hiservice/text2speech/longrecognize/InfoWordInfo;", "wordInfoList", "Lrequest/Speech2Text$WordInfo;", "toInfoWordInfo", "send", "appKey", "", "audioInfo", "Lcom/hiservice/text2speech/longrecognize/AudioInfo;", "checkParam", "", "toRequest", "end", "shutdown", "Companion", "fun-speech2text_release"})
@SourceDebugExtension(value={"SMAP\nSpeed2TextImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Speed2TextImpl.kt\ncom/hiservice/text2speech/longrecognize/impl/Speed2TextImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1869#2,2:245\n1869#2,2:247\n1869#2,2:249\n*S KotlinDebug\n*F\n+ 1 Speed2TextImpl.kt\ncom/hiservice/text2speech/longrecognize/impl/Speed2TextImpl\n*L\n118#1:245,2\n141#1:247,2\n162#1:249,2\n*E\n"})
public final class Speed2TextImpl
implements ISpeed2Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ManagedChannel channel;
    @Nullable
    private SpeechServerV3Grpc.SpeechServerV3Stub client;
    @Nullable
    private IReceiveStream mIReceiveStream;
    @Nullable
    private StreamObserver<Speech2Text.MultiRequest> mInputStream;
    @NotNull
    private static final String TAG = "Speed2TextImpl";
    private static final boolean DEBUG = false;

    private final void initParam() {
        if (this.channel == null) {
            this.channel = ManagedChannelBuilder.forAddress((String)"grpc.translasion.com", (int)443).usePlaintext().build();
        }
        if (this.client == null) {
            this.client = SpeechServerV3Grpc.newStub((Channel)this.channel);
        }
    }

    @Override
    public void start(@NotNull IReceiveStream receiveStream) {
        Intrinsics.checkNotNullParameter((Object)receiveStream, (String)"receiveStream");
        this.mIReceiveStream = receiveStream;
        this.createStream(receiveStream);
    }

    private final void createStream(IReceiveStream receiveStream) {
        this.initParam();
        StreamObserver<Speech2Text.Reply> responseObserver2 = new StreamObserver<Speech2Text.Reply>(receiveStream, this){
            final /* synthetic */ IReceiveStream $receiveStream;
            final /* synthetic */ Speed2TextImpl this$0;
            {
                this.$receiveStream = $receiveStream;
                this.this$0 = $receiver;
            }

            public void onNext(Speech2Text.Reply value) {
                block0: {
                    IReceiveStream iReceiveStream = this.$receiveStream;
                    if (iReceiveStream == null) break block0;
                    iReceiveStream.onReceive(Speed2TextImpl.access$toAudioTextInfo(this.this$0, value));
                }
            }

            public void onError(Throwable t) {
                IReceiveStream iReceiveStream = this.$receiveStream;
                if (iReceiveStream != null) {
                    iReceiveStream.onError(t);
                }
                Speed2TextImpl.access$shutdown(this.this$0);
            }

            public void onCompleted() {
                IReceiveStream iReceiveStream = this.$receiveStream;
                if (iReceiveStream != null) {
                    iReceiveStream.onCompleted();
                }
                Speed2TextImpl.access$shutdown(this.this$0);
            }
        };
        SpeechServerV3Grpc.SpeechServerV3Stub speechServerV3Stub = this.client;
        StreamObserver<Speech2Text.MultiRequest> streamObserver = this.mInputStream = speechServerV3Stub != null ? speechServerV3Stub.speech2TextV3((StreamObserver<Speech2Text.Reply>)((StreamObserver)responseObserver2)) : null;
        if (this.mInputStream == null) {
            Log.e((String)TAG, (String)"createStream, Error:speech2TextV3 failed.");
        }
    }

    private final AudioToTextInfo toAudioTextInfo(Speech2Text.Reply value) {
        Speech2Text.Reply reply = value;
        if (reply != null) {
            Speech2Text.Reply it = reply;
            boolean bl = false;
            return new AudioToTextInfo(it.getErrMsg(), this.toDuration(it.getTotalBilledTime()), this.toResultList(it.getResultsList()));
        }
        return null;
    }

    private final InfoDuration toDuration(Speech2Text.Duration duration) {
        Speech2Text.Duration duration2 = duration;
        if (duration2 != null) {
            Speech2Text.Duration it = duration2;
            boolean bl = false;
            return new InfoDuration(duration.getSeconds(), duration.getNanos());
        }
        return null;
    }

    private final InfoDuration toDuration(Speech2Text.StartTime duration) {
        Speech2Text.StartTime startTime = duration;
        if (startTime != null) {
            Speech2Text.StartTime it = startTime;
            boolean bl = false;
            return new InfoDuration(duration.getSeconds(), duration.getNanos());
        }
        return null;
    }

    private final InfoDuration toDuration(Speech2Text.EndTime duration) {
        Speech2Text.EndTime endTime = duration;
        if (endTime != null) {
            Speech2Text.EndTime it = endTime;
            boolean bl = false;
            return new InfoDuration(duration.getSeconds(), duration.getNanos());
        }
        return null;
    }

    private final List<InfoResult> toResultList(List<Speech2Text.Sresult> list) {
        if (list != null) {
            List<Speech2Text.Sresult> it = list;
            boolean bl = false;
            ArrayList<InfoResult> result = new ArrayList<InfoResult>();
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Speech2Text.Sresult item = (Speech2Text.Sresult)element$iv;
                boolean bl2 = false;
                result.add(this.toInfoResult(item));
            }
            return result;
        }
        return null;
    }

    private final InfoResult toInfoResult(Speech2Text.Sresult item) {
        return new InfoResult(this.toAlternativesList(item.getAlternativesList()), item.getIsFinal(), Float.valueOf(item.getStability()), this.toDuration(item.getResultEndTime()), item.getChannelTag(), item.getLanguageCode());
    }

    private final List<InfoAlternative> toAlternativesList(List<Speech2Text.Alternative> alternativesList) {
        if (alternativesList != null) {
            List<Speech2Text.Alternative> it = alternativesList;
            boolean bl = false;
            ArrayList<InfoAlternative> result = new ArrayList<InfoAlternative>();
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Speech2Text.Alternative item = (Speech2Text.Alternative)element$iv;
                boolean bl2 = false;
                result.add(this.toInfoAlternative(item));
            }
            return result;
        }
        return null;
    }

    private final InfoAlternative toInfoAlternative(Speech2Text.Alternative item) {
        return new InfoAlternative(item.getTranscript(), item.getConfidence(), this.toWordInfoList(item.getWordsList()));
    }

    private final List<InfoWordInfo> toWordInfoList(List<Speech2Text.WordInfo> wordInfoList) {
        if (wordInfoList != null) {
            List<Speech2Text.WordInfo> it = wordInfoList;
            boolean bl = false;
            ArrayList<InfoWordInfo> result = new ArrayList<InfoWordInfo>();
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Speech2Text.WordInfo item = (Speech2Text.WordInfo)element$iv;
                boolean bl2 = false;
                result.add(this.toInfoWordInfo(item));
            }
            return result;
        }
        return null;
    }

    private final InfoWordInfo toInfoWordInfo(Speech2Text.WordInfo item) {
        return new InfoWordInfo(this.toDuration(item.getStartTime()), this.toDuration(item.getEndTime()), item.getWord(), item.getConfidence());
    }

    @Override
    public void send(@NotNull String appKey, @NotNull AudioInfo audioInfo) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)audioInfo, (String)"audioInfo");
            if (this.mInputStream == null) {
                Log.e((String)TAG, (String)"send, Error:send failed.");
                return;
            }
            boolean checkParam = this.checkParam(appKey, audioInfo);
            if (!checkParam) {
                Log.e((String)TAG, (String)"send, Error:checkParam failed.");
                return;
            }
            StreamObserver<Speech2Text.MultiRequest> streamObserver = this.mInputStream;
            if (streamObserver == null) break block2;
            streamObserver.onNext((Object)this.toRequest(appKey, audioInfo));
        }
    }

    private final boolean checkParam(String appKey, AudioInfo audioInfo) {
        if (((CharSequence)appKey).length() == 0) {
            return false;
        }
        if (((CharSequence)audioInfo.getEncoding()).length() == 0) {
            return false;
        }
        return !(((CharSequence)audioInfo.getLanguageCode()).length() == 0);
    }

    private final Speech2Text.MultiRequest toRequest(String appKey, AudioInfo audioInfo) {
        Speech2Text.MultiRequest.Builder builder = Speech2Text.MultiRequest.newBuilder().setAppkey(appKey).setEncoding(audioInfo.getEncoding()).setSampleRateHertz(audioInfo.getSampleRateHertz()).setLanguageCode(audioInfo.getLanguageCode()).setEnableWordTimeOffsets(audioInfo.getEnableWordTimeOffsets()).setAudioContent(ByteString.copyFrom((byte[])audioInfo.getAudioContent())).setInterimResults(audioInfo.getInterimResults());
        List<String> list = audioInfo.getAlternativeLanguageCodes();
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            builder.addAllAlternativeLanguageCodes((Iterable<String>)it);
        }
        GeneratedMessageLite generatedMessageLite = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"build(...)");
        return (Speech2Text.MultiRequest)generatedMessageLite;
    }

    @Override
    public void end() {
        block0: {
            StreamObserver<Speech2Text.MultiRequest> streamObserver = this.mInputStream;
            if (streamObserver == null) break block0;
            streamObserver.onCompleted();
        }
    }

    private final void shutdown() {
        ManagedChannel managedChannel = this.channel;
        if (managedChannel != null) {
            managedChannel.shutdown();
        }
        this.channel = null;
        this.client = null;
    }

    public static final /* synthetic */ AudioToTextInfo access$toAudioTextInfo(Speed2TextImpl $this, Speech2Text.Reply value) {
        return $this.toAudioTextInfo(value);
    }

    public static final /* synthetic */ void access$shutdown(Speed2TextImpl $this) {
        $this.shutdown();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/hiservice/text2speech/longrecognize/impl/Speed2TextImpl$Companion;", "", "<init>", "()V", "TAG", "", "DEBUG", "", "fun-speech2text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

