/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.textrecognize;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.Keep;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.vision.v1.Vision;
import com.google.api.services.vision.v1.VisionRequest;
import com.google.api.services.vision.v1.VisionRequestInitializer;
import com.google.api.services.vision.v1.model.AnnotateImageRequest;
import com.google.api.services.vision.v1.model.AnnotateImageResponse;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import com.google.api.services.vision.v1.model.EntityAnnotation;
import com.google.api.services.vision.v1.model.Feature;
import com.google.api.services.vision.v1.model.Image;
import com.google.api.services.vision.v1.model.Page;
import com.google.api.services.vision.v1.model.Paragraph;
import com.google.api.services.vision.v1.model.Symbol;
import com.google.api.services.vision.v1.model.Vertex;
import com.google.api.services.vision.v1.model.Word;
import com.hiservice.core.HaveFun;
import com.hiservice.textrecognize.Block;
import com.hiservice.textrecognize.FrameMetadata;
import com.hiservice.textrecognize.Line;
import com.hiservice.textrecognize.NoContentException;
import com.hiservice.textrecognize.Recognizer;
import com.hiservice.textrecognize.SerializableRect;
import com.hiservice.textrecognize.TransParams;
import com.hiservice.textrecognize.UtilsKt;
import com.hiservice.textrecognize.VisionRecognizeResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0097@\u00a2\u0006\u0002\u0010\u001dJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/hiservice/textrecognize/GoogleRecognizer;", "Lcom/hiservice/textrecognize/Recognizer;", "context", "Landroid/content/Context;", "key", "", "debug", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;Z)V", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "getKey", "()Ljava/lang/String;", "getDebug", "()Z", "mTransParams", "Lcom/hiservice/textrecognize/TransParams;", "mHistory", "Lcom/hiservice/textrecognize/VisionRecognizeResult;", "setup", "", "transParams", "doOcr", "bitmap", "Landroid/graphics/Bitmap;", "source", "(Landroid/graphics/Bitmap;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFrameMetadata", "Lcom/hiservice/textrecognize/FrameMetadata;", "getHistory", "getType", "", "Companion", "fun-text-recognize_release"})
@SourceDebugExtension(value={"SMAP\nGoogleRecognizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleRecognizer.kt\ncom/hiservice/textrecognize/GoogleRecognizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1869#2:260\n1869#2:261\n1869#2:262\n1869#2:263\n774#2:264\n865#2,2:265\n1563#2:267\n1634#2,3:268\n1869#2:271\n1869#2,2:272\n1870#2:274\n1870#2:275\n1870#2:276\n1870#2:277\n1870#2:278\n1563#2:279\n1634#2,3:280\n774#2:283\n865#2,2:284\n1#3:286\n*S KotlinDebug\n*F\n+ 1 GoogleRecognizer.kt\ncom/hiservice/textrecognize/GoogleRecognizer\n*L\n138#1:260\n143#1:261\n144#1:262\n145#1:263\n158#1:264\n158#1:265,2\n172#1:267\n172#1:268,3\n191#1:271\n192#1:272,2\n191#1:274\n145#1:275\n144#1:276\n143#1:277\n138#1:278\n220#1:279\n220#1:280,3\n234#1:283\n234#1:284,2\n*E\n"})
public final class GoogleRecognizer
implements Recognizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Context context;
    @Nullable
    private final String key;
    private final boolean debug;
    private TransParams mTransParams;
    @Nullable
    private VisionRecognizeResult mHistory;
    @NotNull
    public static final String ANDROID_PACKAGE_HEADER = "X-Android-Package";
    @NotNull
    public static final String ANDROID_CERT_HEADER = "X-Android-Cert";
    @NotNull
    public static final String TAG = "Recognizer";
    @NotNull
    public static final String TEST_PACKAGE_NAME = "com.talpa.translate";
    @NotNull
    public static final String TEST_SHA1 = "ebd663baf5c6e7e4139675407b8216914bca417a";

    public GoogleRecognizer(@NotNull Context context, @Nullable String key, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.key = key;
        this.debug = debug;
    }

    public /* synthetic */ GoogleRecognizer(Context context, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(context, string2, bl);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @Nullable
    public final String getKey() {
        return this.key;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setup(@NotNull TransParams transParams) {
        Intrinsics.checkNotNullParameter((Object)transParams, (String)"transParams");
        this.mTransParams = transParams;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Keep
    @Nullable
    public Object doOcr(@NotNull Bitmap bitmap, @NotNull String source, @NotNull Continuation<? super VisionRecognizeResult> $completion) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Block it;
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Unit unit;
        Object $this$forEach$iv;
        Iterable $this$forEach$iv2;
        Object object3;
        void feature;
        void imageRequest;
        Object object2;
        BatchAnnotateImagesRequest batchAnnotateImagesRequest;
        Log.d((String)TAG, (String)"start google ocr");
        NetHttpTransport httpTransport = new NetHttpTransport();
        GsonFactory gsonFactory = GsonFactory.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gsonFactory, (String)"getDefaultInstance(...)");
        JsonFactory jsonFactory = (JsonFactory)gsonFactory;
        String string2 = this.key;
        VisionRequestInitializer requestInitializer2 = new VisionRequestInitializer(this, string2){
            final /* synthetic */ GoogleRecognizer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void initializeVisionRequest(VisionRequest<?> visionRequest) throws IOException {
                Intrinsics.checkNotNullParameter(visionRequest, (String)"visionRequest");
                super.initializeVisionRequest(visionRequest);
                if (this.this$0.getDebug()) {
                    String packageName = "com.talpa.translate";
                    visionRequest.getRequestHeaders().set("X-Android-Package", (Object)packageName);
                    visionRequest.getRequestHeaders().set("X-Android-Cert", (Object)"ebd663baf5c6e7e4139675407b8216914bca417a");
                } else {
                    String string2 = this.this$0.getContext().getPackageName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
                    String packageName = string2;
                    visionRequest.getRequestHeaders().set("X-Android-Package", (Object)packageName);
                    PackageManager packageManager = this.this$0.getContext().getPackageManager();
                    Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
                    String sig = UtilsKt.getSignature(packageManager, packageName);
                    visionRequest.getRequestHeaders().set("X-Android-Cert", (Object)sig);
                }
            }
        };
        String serverAppKey = HaveFun.Companion.instance().getKey();
        String serverSecret = HaveFun.Companion.instance().getSecret();
        long timeStamp = System.currentTimeMillis();
        int random = (int)((Math.random() * (double)9 + 1.0) * (double)1000);
        String randomKey = serverAppKey + "&en&" + timeStamp + '&' + serverSecret + '&' + random;
        Vision.Builder builder2 = new Vision.Builder((HttpTransport)httpTransport, jsonFactory, new HttpRequestInitializer(serverAppKey, timeStamp, randomKey, random){
            final /* synthetic */ String $serverAppKey;
            final /* synthetic */ long $timeStamp;
            final /* synthetic */ String $randomKey;
            final /* synthetic */ int $random;
            {
                this.$serverAppKey = $serverAppKey;
                this.$timeStamp = $timeStamp;
                this.$randomKey = $randomKey;
                this.$random = $random;
            }

            public void initialize(HttpRequest request) {
                block8: {
                    HttpRequest httpRequest;
                    HttpRequest httpRequest2;
                    HttpRequest httpRequest3;
                    HttpRequest httpRequest4;
                    HttpRequest httpRequest5;
                    HttpRequest httpRequest6 = request;
                    if (httpRequest6 != null) {
                        httpRequest6.setConnectTimeout(8000);
                    }
                    HttpRequest httpRequest7 = request;
                    if (httpRequest7 != null) {
                        httpRequest7.setReadTimeout(8000);
                    }
                    HttpRequest httpRequest8 = request;
                    if (httpRequest8 != null) {
                        httpRequest8.setWriteTimeout(8000);
                    }
                    HttpRequest httpRequest9 = request;
                    if (httpRequest9 != null) {
                        httpRequest9.setUrl(new GenericUrl(GoogleRecognizer.access$doOcr$host() + "text/ocr/v1"));
                    }
                    if ((httpRequest5 = request) != null && (httpRequest5 = httpRequest5.getHeaders()) != null) {
                        httpRequest5.set("API-KEY", (Object)this.$serverAppKey);
                    }
                    if ((httpRequest4 = request) != null && (httpRequest4 = httpRequest4.getHeaders()) != null) {
                        httpRequest4.set("timestamp", (Object)this.$timeStamp);
                    }
                    if ((httpRequest3 = request) != null && (httpRequest3 = httpRequest3.getHeaders()) != null) {
                        httpRequest3.set("sig", (Object)UtilsKt.crypt(this.$randomKey));
                    }
                    if ((httpRequest2 = request) != null && (httpRequest2 = httpRequest2.getHeaders()) != null) {
                        httpRequest2.set("nonce", (Object)this.$random);
                    }
                    if ((httpRequest = request) == null || (httpRequest = httpRequest.getHeaders()) == null) break block8;
                    httpRequest.set("to", (Object)"en");
                }
            }
        });
        builder2.setVisionRequestInitializer(requestInitializer2);
        Vision vision = builder2.build();
        BatchAnnotateImagesRequest $this$doOcr_u24lambda_u242 = batchAnnotateImagesRequest = new BatchAnnotateImagesRequest();
        boolean object3 = false;
        Object[] objectArray = new AnnotateImageRequest[1];
        AnnotateImageRequest annotateImageRequest = object2 = new AnnotateImageRequest();
        int n = 0;
        Object[] objectArray2 = objectArray;
        BatchAnnotateImagesRequest batchAnnotateImagesRequest2 = $this$doOcr_u24lambda_u242;
        boolean bl = false;
        Object base64EncodedImage = new Image();
        base64EncodedImage.setContent(UtilsKt.bitmapToBase64(bitmap));
        imageRequest.setImage((Image)base64EncodedImage);
        Object[] objectArray3 = new Feature[1];
        Feature feature2 = new Feature();
        Object object4 = feature2;
        int n2 = 0;
        Object[] objectArray4 = objectArray3;
        void var32_44 = imageRequest;
        boolean bl2 = false;
        feature.setType("TEXT_DETECTION");
        Unit unit2 = Unit.INSTANCE;
        objectArray4[n2] = feature2;
        var32_44.setFeatures((List)CollectionsKt.arrayListOf((Object[])objectArray3));
        Unit unit3 = Unit.INSTANCE;
        objectArray2[n] = object2;
        batchAnnotateImagesRequest2.setRequests((List)CollectionsKt.arrayListOf((Object[])objectArray));
        BatchAnnotateImagesRequest batchAnnotateImagesRequest3 = batchAnnotateImagesRequest;
        Vision.Images.Annotate annotateRequest = vision.images().annotate(batchAnnotateImagesRequest3);
        annotateRequest.setDisableGZipContent(true);
        try {
            object3 = annotateRequest.execute();
            Intrinsics.checkNotNull((Object)object3);
            object3 = (BatchAnnotateImagesResponse)object3;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("e:" + e.getMessage()));
            String errorMessage = e.getMessage();
            throw new NoContentException(404, errorMessage);
        }
        Object response = object3;
        Log.d((String)TAG, (String)("resposnse:" + response.getResponses()));
        ArrayList<Block> blocks = new ArrayList<Block>();
        List list = response.getResponses();
        if (list != null) {
            $this$forEach$iv2 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                AnnotateImageResponse res = (AnnotateImageResponse)element$iv;
                boolean bl3 = false;
                base64EncodedImage = (Map)res.getFullTextAnnotation();
                if (base64EncodedImage == null || base64EncodedImage.isEmpty()) {
                    return new VisionRecognizeResult(204, "no_content_identified", new ArrayList());
                }
                StringBuilder sb = new StringBuilder();
                List list2 = res.getFullTextAnnotation().getPages();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPages(...)");
                $this$forEach$iv = list2;
                boolean $i$f$forEach2 = false;
                object4 = $this$forEach$iv.iterator();
                while (object4.hasNext()) {
                    Object element$iv2 = object4.next();
                    Page itPage = (Page)element$iv2;
                    boolean bl4 = false;
                    List list3 = itPage.getBlocks();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getBlocks(...)");
                    Iterable $this$forEach$iv3 = list3;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        com.google.api.services.vision.v1.model.Block it2 = (com.google.api.services.vision.v1.model.Block)element$iv3;
                        boolean bl5 = false;
                        List list4 = it2.getParagraphs();
                        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getParagraphs(...)");
                        Iterable $this$forEach$iv4 = list4;
                        boolean $i$f$forEach4 = false;
                        for (Object element$iv4 : $this$forEach$iv4) {
                            Unit unit4;
                            void $this$mapTo$iv$iv2;
                            void $this$map$iv2;
                            int lineLeftBottomY;
                            int lineLeftBottomX;
                            int lineRightBottomY;
                            int lineRightBottomX;
                            int lineRightTopY;
                            int lineRightTopX;
                            int lineLeftTopY;
                            int lineLeftTopX;
                            EntityAnnotation it3;
                            void $this$filterTo$iv$iv2;
                            Paragraph paragraph = (Paragraph)element$iv4;
                            boolean bl6 = false;
                            StringsKt.clear((StringBuilder)sb);
                            Object object5 = paragraph;
                            int leftTopX = object5 != null && (object5 = object5.getBoundingBox()) != null && (object5 = object5.getVertices()) != null && (object5 = (Vertex)CollectionsKt.getOrNull((List)object5, (int)0)) != null && (object5 = object5.getX()) != null ? (Integer)object5 : 0;
                            Object object6 = paragraph;
                            int leftTopY = object6 != null && (object6 = object6.getBoundingBox()) != null && (object6 = object6.getVertices()) != null && (object6 = (Vertex)CollectionsKt.getOrNull((List)object6, (int)0)) != null && (object6 = object6.getY()) != null ? (Integer)object6 : 0;
                            Object object7 = paragraph;
                            int rightTopX = object7 != null && (object7 = object7.getBoundingBox()) != null && (object7 = object7.getVertices()) != null && (object7 = (Vertex)CollectionsKt.getOrNull((List)object7, (int)1)) != null && (object7 = object7.getX()) != null ? (Integer)object7 : 0;
                            Object object8 = paragraph;
                            int rightTopY = object8 != null && (object8 = object8.getBoundingBox()) != null && (object8 = object8.getVertices()) != null && (object8 = (Vertex)CollectionsKt.getOrNull((List)object8, (int)1)) != null && (object8 = object8.getY()) != null ? (Integer)object8 : 0;
                            Object object9 = paragraph;
                            int rightBottomX = object9 != null && (object9 = object9.getBoundingBox()) != null && (object9 = object9.getVertices()) != null && (object9 = (Vertex)CollectionsKt.getOrNull((List)object9, (int)2)) != null && (object9 = object9.getX()) != null ? (Integer)object9 : 0;
                            Object object10 = paragraph;
                            int rightBottomY = object10 != null && (object10 = object10.getBoundingBox()) != null && (object10 = object10.getVertices()) != null && (object10 = (Vertex)CollectionsKt.getOrNull((List)object10, (int)2)) != null && (object10 = object10.getY()) != null ? (Integer)object10 : 0;
                            Object object11 = paragraph;
                            int leftBottomX = object11 != null && (object11 = object11.getBoundingBox()) != null && (object11 = object11.getVertices()) != null && (object11 = (Vertex)CollectionsKt.getOrNull((List)object11, (int)3)) != null && (object11 = object11.getX()) != null ? (Integer)object11 : 0;
                            Object object12 = paragraph;
                            int leftBottomY = object12 != null && (object12 = object12.getBoundingBox()) != null && (object12 = object12.getVertices()) != null && (object12 = (Vertex)CollectionsKt.getOrNull((List)object12, (int)3)) != null && (object12 = object12.getY()) != null ? (Integer)object12 : 0;
                            Rect boundingRect = new Rect(leftTopX, leftTopY, rightBottomX, rightBottomY);
                            List list5 = res.getTextAnnotations();
                            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getTextAnnotations(...)");
                            Iterable $this$filter$iv2 = list5;
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv2;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                                it3 = (EntityAnnotation)element$iv$iv;
                                boolean bl7 = false;
                                Object object13 = it3.getBoundingPoly();
                                lineLeftTopX = object13 != null && (object13 = object13.getVertices()) != null && (object13 = (Vertex)CollectionsKt.getOrNull((List)object13, (int)0)) != null && (object13 = object13.getX()) != null ? (Integer)object13 : 0;
                                Object object14 = it3.getBoundingPoly();
                                lineLeftTopY = object14 != null && (object14 = object14.getVertices()) != null && (object14 = (Vertex)CollectionsKt.getOrNull((List)object14, (int)0)) != null && (object14 = object14.getY()) != null ? (Integer)object14 : 0;
                                Object object15 = it3.getBoundingPoly();
                                lineRightTopX = object15 != null && (object15 = object15.getVertices()) != null && (object15 = (Vertex)CollectionsKt.getOrNull((List)object15, (int)1)) != null && (object15 = object15.getX()) != null ? (Integer)object15 : 0;
                                Object object16 = it3.getBoundingPoly();
                                lineRightTopY = object16 != null && (object16 = object16.getVertices()) != null && (object16 = (Vertex)CollectionsKt.getOrNull((List)object16, (int)1)) != null && (object16 = object16.getY()) != null ? (Integer)object16 : 0;
                                Object object17 = it3.getBoundingPoly();
                                lineRightBottomX = object17 != null && (object17 = object17.getVertices()) != null && (object17 = (Vertex)CollectionsKt.getOrNull((List)object17, (int)2)) != null && (object17 = object17.getX()) != null ? (Integer)object17 : 0;
                                Object object18 = it3.getBoundingPoly();
                                lineRightBottomY = object18 != null && (object18 = object18.getVertices()) != null && (object18 = (Vertex)CollectionsKt.getOrNull((List)object18, (int)2)) != null && (object18 = object18.getY()) != null ? (Integer)object18 : 0;
                                Object object19 = it3.getBoundingPoly();
                                lineLeftBottomX = object19 != null && (object19 = object19.getVertices()) != null && (object19 = (Vertex)CollectionsKt.getOrNull((List)object19, (int)3)) != null && (object19 = object19.getX()) != null ? (Integer)object19 : 0;
                                Object object20 = it3.getBoundingPoly();
                                int n3 = lineLeftBottomY = object20 != null && (object20 = object20.getVertices()) != null && (object20 = (Vertex)CollectionsKt.getOrNull((List)object20, (int)3)) != null && (object20 = object20.getY()) != null ? (Integer)object20 : 0;
                                if (!(boundingRect.contains(lineLeftTopX, lineLeftTopY) && boundingRect.contains(lineRightTopX, lineRightTopY) && boundingRect.contains(lineRightBottomX, lineRightBottomY) && boundingRect.contains(lineLeftBottomX, lineLeftBottomY))) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv2 = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv2 = $this$map$iv2;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                it3 = (EntityAnnotation)item$iv$iv;
                                Collection collection2 = destination$iv$iv;
                                boolean bl8 = false;
                                Object object21 = it3.getBoundingPoly();
                                lineLeftTopX = object21 != null && (object21 = object21.getVertices()) != null && (object21 = (Vertex)CollectionsKt.getOrNull((List)object21, (int)0)) != null && (object21 = object21.getX()) != null ? (Integer)object21 : 0;
                                Object object22 = it3.getBoundingPoly();
                                lineLeftTopY = object22 != null && (object22 = object22.getVertices()) != null && (object22 = (Vertex)CollectionsKt.getOrNull((List)object22, (int)0)) != null && (object22 = object22.getY()) != null ? (Integer)object22 : 0;
                                Object object23 = it3.getBoundingPoly();
                                lineRightTopX = object23 != null && (object23 = object23.getVertices()) != null && (object23 = (Vertex)CollectionsKt.getOrNull((List)object23, (int)1)) != null && (object23 = object23.getX()) != null ? (Integer)object23 : 0;
                                Object object24 = it3.getBoundingPoly();
                                lineRightTopY = object24 != null && (object24 = object24.getVertices()) != null && (object24 = (Vertex)CollectionsKt.getOrNull((List)object24, (int)1)) != null && (object24 = object24.getY()) != null ? (Integer)object24 : 0;
                                Object object25 = it3.getBoundingPoly();
                                lineRightBottomX = object25 != null && (object25 = object25.getVertices()) != null && (object25 = (Vertex)CollectionsKt.getOrNull((List)object25, (int)2)) != null && (object25 = object25.getX()) != null ? (Integer)object25 : 0;
                                Object object26 = it3.getBoundingPoly();
                                lineRightBottomY = object26 != null && (object26 = object26.getVertices()) != null && (object26 = (Vertex)CollectionsKt.getOrNull((List)object26, (int)2)) != null && (object26 = object26.getY()) != null ? (Integer)object26 : 0;
                                Object object27 = it3.getBoundingPoly();
                                lineLeftBottomX = object27 != null && (object27 = object27.getVertices()) != null && (object27 = (Vertex)CollectionsKt.getOrNull((List)object27, (int)3)) != null && (object27 = object27.getX()) != null ? (Integer)object27 : 0;
                                Object object28 = it3.getBoundingPoly();
                                lineLeftBottomY = object28 != null && (object28 = object28.getVertices()) != null && (object28 = (Vertex)CollectionsKt.getOrNull((List)object28, (int)3)) != null && (object28 = object28.getY()) != null ? (Integer)object28 : 0;
                                Object[] objectArray5 = new Point[]{new Point(lineLeftTopX, lineLeftTopY), new Point(lineRightTopX, lineRightTopY), new Point(lineRightBottomX, lineRightBottomY), new Point(lineLeftBottomX, lineLeftBottomY)};
                                collection2.add(new Line(CollectionsKt.listOf((Object[])objectArray5)));
                            }
                            List fakeLinePoints = (List)destination$iv$iv;
                            Object object29 = paragraph;
                            if (object29 != null && (object29 = object29.getWords()) != null) {
                                Iterable $this$forEach$iv5 = (Iterable)object29;
                                boolean $i$f$forEach5 = false;
                                for (Object element$iv5 : $this$forEach$iv5) {
                                    Word it4 = (Word)element$iv5;
                                    boolean bl9 = false;
                                    List list6 = it4.getSymbols();
                                    Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getSymbols(...)");
                                    Iterable $this$forEach$iv6 = list6;
                                    boolean $i$f$forEach6 = false;
                                    for (Object element$iv6 : $this$forEach$iv6) {
                                        Symbol it5 = (Symbol)element$iv6;
                                        boolean bl10 = false;
                                        sb.append(it5.getText());
                                    }
                                    sb.append(" ");
                                }
                                unit4 = Unit.INSTANCE;
                            } else {
                                unit4 = null;
                            }
                            Object[] objectArray6 = new Point[]{new Point(leftTopX, leftTopY), new Point(rightTopX, rightTopY), new Point(rightBottomX, rightBottomY), new Point(leftBottomX, leftBottomY)};
                            Block block = new Block(((Object)StringsKt.trimEnd((CharSequence)sb)).toString(), new SerializableRect(boundingRect), CollectionsKt.listOf((Object[])objectArray6), fakeLinePoints);
                            blocks.add(block);
                        }
                    }
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        VisionRecognizeResult finalOcr = new VisionRecognizeResult(200, "success", (List<Block>)blocks);
        $this$forEach$iv2 = finalOcr.getBlocks();
        String string3 = "success";
        int n4 = 200;
        boolean $i$f$map = false;
        void var22_27 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            $this$forEach$iv = (Block)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl11 = false;
            if (it.getRect().getRight() >= bitmap.getWidth()) {
                it.getRect().setRight(bitmap.getWidth() - 1);
            }
            if (it.getRect().getBottom() >= bitmap.getHeight()) {
                it.getRect().setBottom(bitmap.getHeight() - 1);
            }
            if (it.getRect().getLeft() <= 0) {
                it.getRect().setLeft(0);
            }
            if (it.getRect().getTop() <= 0) {
                it.getRect().setTop(0);
            }
            collection.add((void)it);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Block)element$iv$iv;
            boolean bl12 = false;
            if (!(it.getRect().getLeft() + it.getRect().width() > bitmap.getWidth() ? false : (it.getRect().getTop() + it.getRect().height() > bitmap.getHeight() ? false : it.getRect().width() > 0 && it.getRect().height() > 0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        List list7 = CollectionsKt.toMutableList(collection);
        String string4 = string3;
        int n5 = n4;
        Object it6 = object2 = new VisionRecognizeResult(n5, string4, list7);
        boolean bl13 = false;
        this.mHistory = it6;
        return object2;
    }

    @Override
    @Nullable
    public FrameMetadata getFrameMetadata() {
        TransParams transParams = this.mTransParams;
        if (transParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTransParams");
            transParams = null;
        }
        return transParams.getMetaData();
    }

    @Override
    @Nullable
    public VisionRecognizeResult getHistory() {
        return this.mHistory;
    }

    @Override
    public int getType() {
        return 1;
    }

    private static final String doOcr$host() {
        return "https://api.translasion.com/";
    }

    public static final /* synthetic */ String access$doOcr$host() {
        return GoogleRecognizer.doOcr$host();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hiservice/textrecognize/GoogleRecognizer$Companion;", "", "<init>", "()V", "ANDROID_PACKAGE_HEADER", "", "ANDROID_CERT_HEADER", "TAG", "TEST_PACKAGE_NAME", "TEST_SHA1", "fun-text-recognize_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

