/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.textrecognize;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.core.content.ContextCompat;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u000f*\u00020\u0011\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0006\u0010\u0019\u001a\u00020\u000f\u001a\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u0012\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"H\u0002\u001a.\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010*\u001a\u00020\u0013*\u00020\u00112\u0006\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020,\u001a\u0010\u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010.\u001a\u00020/\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u00060"}, d2={"PREFER_KEY_SOURCE_LANG", "", "PREFER_KEY_TARGET_LANG", "PREFER_KEY_SOURCE_LANG_LABEL", "PREFER_KEY_TARGET_LANG_LABEL", "PREFER_NAME", "MAX_TEXT_SIZE", "", "MIN_TEXT_SIZE", "PERMISSIONS_REQUIRED", "", "getPERMISSIONS_REQUIRED", "()[Ljava/lang/String;", "[Ljava/lang/String;", "checkPermission", "", "context", "Landroid/content/Context;", "saveLanguage", "", "preferKey", "value", "isNetworkConnected", "crypt", "str", "isSDCardEnable", "getFreeSpace", "", "getSignature", "pm", "Landroid/content/pm/PackageManager;", "packageName", "signatureDigest", "sig", "Landroid/content/pm/Signature;", "getAutofitTextSize", "text", "paint", "Landroid/text/TextPaint;", "rect", "Landroid/graphics/Rect;", "maxTextSize", "clipboard", "label", "", "bitmapToBase64", "bitmap", "Landroid/graphics/Bitmap;", "fun-text-recognize_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/hiservice/textrecognize/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,270:1\n12434#2,2:271\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/hiservice/textrecognize/UtilsKt\n*L\n51#1:271,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String PREFER_KEY_SOURCE_LANG = "key_source_lang";
    @NotNull
    public static final String PREFER_KEY_TARGET_LANG = "key_target_lang";
    @NotNull
    public static final String PREFER_KEY_SOURCE_LANG_LABEL = "key_source_lang_label";
    @NotNull
    public static final String PREFER_KEY_TARGET_LANG_LABEL = "key_target_lang_label";
    @NotNull
    public static final String PREFER_NAME = "prefer_camera";
    public static final int MAX_TEXT_SIZE = 16;
    public static final int MIN_TEXT_SIZE = 4;
    @NotNull
    private static final String[] PERMISSIONS_REQUIRED;

    @NotNull
    public static final String[] getPERMISSIONS_REQUIRED() {
        return PERMISSIONS_REQUIRED;
    }

    public static final boolean checkPermission(@NotNull Context context) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String[] $this$all$iv = PERMISSIONS_REQUIRED;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (ContextCompat.checkSelfPermission((Context)context, (String)it) == 0) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final void saveLanguage(@NotNull Context context, @NotNull String preferKey, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preferKey, (String)"preferKey");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences prefer = context.getSharedPreferences(PREFER_NAME, 0);
        prefer.edit().putString(preferKey, value).apply();
    }

    public static /* synthetic */ void saveLanguage$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = PREFER_KEY_SOURCE_LANG;
        }
        UtilsKt.saveLanguage(context, string2, string3);
    }

    public static final boolean isNetworkConnected(@NotNull Context $this$isNetworkConnected) {
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkConnected, (String)"<this>");
        Object object = $this$isNetworkConnected.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = connectivityManager.getActiveNetwork();
            if (network == null) {
                return false;
            }
            Network nw = network;
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(nw);
            if (networkCapabilities == null) {
                return false;
            }
            NetworkCapabilities actNw = networkCapabilities;
            return actNw.hasTransport(1) ? true : (actNw.hasTransport(0) ? true : (actNw.hasTransport(3) ? true : actNw.hasTransport(2)));
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        NetworkInfo nwInfo = networkInfo;
        return nwInfo.isConnected();
    }

    @NotNull
    public static final String crypt(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (((CharSequence)str).length() == 0) {
            return "";
        }
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String string2 = str;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            md.update(byArray);
            byte[] hash = md.digest();
            int n = hash.length;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                StringBuffer stringBuffer = (0xFF & hash[it]) < 16 ? hexString.append('0' + Integer.toHexString(0xFF & hash[it])) : hexString.append(Integer.toHexString(0xFF & hash[it]));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String string3 = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    public static final boolean isSDCardEnable() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    public static final long getFreeSpace() {
        if (!UtilsKt.isSDCardEnable()) {
            return -1L;
        }
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        long size = availableBlocks * blockSize / 1024L;
        return size;
    }

    @Nullable
    public static final String getSignature(@NotNull PackageManager pm, @NotNull String packageName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            Signature[] signatureArray;
            block7: {
                block6: {
                    Signature[] packageInfo;
                    signatureArray = packageInfo = pm.getPackageInfo(packageName, 64);
                    if (packageInfo == null) break block6;
                    signatureArray = signatureArray.signatures;
                    if (signatureArray.signatures != null) break block7;
                }
                return null;
            }
            Signature[] signatures = signatureArray;
            Signature signature = signatures[0];
            if (signature == null) {
                return null;
            }
            Signature first = signature;
            string2 = UtilsKt.signatureDigest(first);
        }
        catch (PackageManager.NameNotFoundException e) {
            string2 = null;
        }
        return string2;
    }

    private static final String signatureDigest(Signature sig) {
        String string2;
        byte[] signature = sig.toByteArray();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(signature);
            string2 = BaseEncoding.base16().lowerCase().encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            string2 = null;
        }
        return string2;
    }

    public static final int getAutofitTextSize(@NotNull String text, @NotNull TextPaint paint, @NotNull Rect rect, int maxTextSize, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int textsize = maxTextSize;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        paint.setTextSize(TypedValue.applyDimension((int)2, (float)textsize, (DisplayMetrics)displayMetrics));
        StaticLayout staticLayout = new StaticLayout((CharSequence)text, paint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        while (staticLayout.getHeight() > rect.height() && textsize > 4) {
            paint.setTextSize(TypedValue.applyDimension((int)2, (float)(--textsize), (DisplayMetrics)displayMetrics));
            staticLayout = new StaticLayout((CharSequence)text, paint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        }
        return textsize;
    }

    public static final void clipboard(@NotNull Context $this$clipboard, @NotNull CharSequence label, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)$this$clipboard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            String newLabel = $this$clipboard.getPackageName() + '_' + label;
            Object object = $this$clipboard.getSystemService("clipboard");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
            ClipboardManager cm = (ClipboardManager)object;
            ClipData clipData = ClipData.newPlainText((CharSequence)newLabel, (CharSequence)text);
            cm.setPrimaryClip(clipData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static final String bitmapToBase64(@NotNull Bitmap bitmap) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            result = null;
            baos = null;
            try {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
                baos.flush();
                baos.close();
                bitmapBytes = baos.toByteArray();
                result = Base64.encodeToString((byte[])bitmapBytes, (int)0);
                ** try [egrp 1[TRYBLOCK] [0 : 53->65)] { 
            }
            catch (IOException e) {
                e.printStackTrace();
                break block12;
            }
            finally {
                try {
                    if (baos != null) {
                        baos.flush();
                        baos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                baos.flush();
                baos.close();
            }
lbl18:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            {
            }
        }
        return result;
    }

    static {
        String[] stringArray = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        PERMISSIONS_REQUIRED = stringArray;
    }
}

