/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import com.hiservice.tools.Hex;
import com.hiservice.translate.HiTranslator$TranslateResult$;
import com.hiservice.translate.HiTranslator$Translation$;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 !2\u00020\u0001:\u0003!\"#BS\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0002J0\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0011J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0005*\u00020\u0003H\u0002J\f\u0010 \u001a\u00020\u0005*\u00020\u0005H\u0002R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/hiservice/translate/HiTranslator;", "", "applicationContext", "Landroid/content/Context;", "sourceLanguage", "", "targetLanguage", "texts", "", "isMultiTranslate", "", "appKey", "secret", "isDebug", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Z)V", "[Ljava/lang/String;", "connect", "Lcom/hiservice/translate/HiTranslator$TranslateResult;", "generateNonce", "generateSign", "timestamp", "", "nonce", "readInputStream", "inputStream", "Ljava/io/InputStream;", "translate", "writeOutputStream", "", "outputStream", "Ljava/io/OutputStream;", "getServerBaseUrl", "md5", "Companion", "TranslateResult", "Translation", "fun-translate_release"})
@Keep
public final class HiTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @Nullable
    private final String sourceLanguage;
    @NotNull
    private final String targetLanguage;
    @NotNull
    private final String[] texts;
    private final boolean isMultiTranslate;
    @NotNull
    private final String appKey;
    @NotNull
    private final String secret;
    private final boolean isDebug;
    @NotNull
    private static final String BASE_URL_RELEASE = "https://api.translasion.com/v2/translate";
    @NotNull
    private static final String BASE_URL_DEBUG = "https://tapi.translasion.com/v2/translate";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 8000;
    @NotNull
    private static final String REQUEST_METHOD = "POST";
    @NotNull
    private static final String CONTENT_TYPE = "application/json";

    public HiTranslator(@NotNull Context applicationContext, @Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String[] texts, boolean isMultiTranslate, @NotNull String appKey, @NotNull String secret, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.applicationContext = applicationContext;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.texts = texts;
        this.isMultiTranslate = isMultiTranslate;
        this.appKey = appKey;
        this.secret = secret;
        this.isDebug = isDebug;
    }

    public /* synthetic */ HiTranslator(Context context, String string, String string2, String[] stringArray, boolean bl, String string3, String string4, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        this(context, string, string2, stringArray, bl, string3, string4, bl2);
    }

    @NotNull
    public final TranslateResult translate() throws IOException {
        return this.connect();
    }

    private final TranslateResult connect() throws IOException {
        URL url = new URL(this.getServerBaseUrl(this.applicationContext));
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(8000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
        this.writeOutputStream(outputStream);
        outputStream.close();
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
        TranslateResult result = this.readInputStream(inputStream);
        inputStream.close();
        connection.disconnect();
        return result;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = this.generateNonce();
        String sig = this.generateSign(this.appKey, this.targetLanguage, timestamp, this.secret, nonce);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("app_key", (Object)this.appKey);
        jsonObj.put("to", (Object)this.targetLanguage);
        if (this.isMultiTranslate) {
            jsonObj.put("texts", (Object)new JSONArray((Object)this.texts));
        } else {
            String string = (String)ArraysKt.firstOrNull((Object[])this.texts);
            if (string != null) {
                String it = string;
                boolean bl = false;
                jsonObj.put("text", (Object)it);
            }
        }
        jsonObj.put("timestamp", timestamp);
        jsonObj.put("nonce", (Object)nonce);
        jsonObj.put("sig", (Object)sig);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string = jsonObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObj.toString()");
        string = json = string;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        outputStream.write(byArray);
        outputStream.flush();
    }

    private final String generateNonce() {
        Object[] objectArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        Object[] charArray = objectArray;
        int index1 = RangesKt.random((IntRange)ArraysKt.getIndices((Object[])charArray), (Random)((Random)Random.Default));
        int index2 = RangesKt.random((IntRange)ArraysKt.getIndices((Object[])charArray), (Random)((Random)Random.Default));
        int index3 = RangesKt.random((IntRange)ArraysKt.getIndices((Object[])charArray), (Random)((Random)Random.Default));
        int index4 = RangesKt.random((IntRange)ArraysKt.getIndices((Object[])charArray), (Random)((Random)Random.Default));
        return "" + ((Character)charArray[index1]).charValue() + ((Character)charArray[index2]).charValue() + ((Character)charArray[index3]).charValue() + ((Character)charArray[index4]).charValue();
    }

    private final String generateSign(String appKey, String targetLanguage, long timestamp, String secret, String nonce) {
        String value = appKey + '&' + targetLanguage + '&' + timestamp + '&' + secret + '&' + nonce;
        return this.md5(value);
    }

    private final String md5(String $this$md5) {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] data = digest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
        char[] charArray = Hex.INSTANCE.encodeHex(data);
        return new String(charArray);
    }

    private final TranslateResult readInputStream(InputStream inputStream) {
        JSONArray texts;
        String source;
        JSONObject resObj;
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        String content = new String(bytes, Charsets.UTF_8);
        Log.d((String)"HiService", (String)Intrinsics.stringPlus((String)"translate content==", (Object)content));
        TranslateResult translateResultBean = new TranslateResult(0, "", null, 4, null);
        JSONObject obj = new JSONObject(content);
        translateResultBean.setCode$fun_translate_release(obj.optInt("code"));
        String string = obj.optString("message");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"obj.optString(\"message\")");
        translateResultBean.setMessage(string);
        JSONObject jSONObject = resObj = obj.optJSONObject("result");
        String text = jSONObject == null ? null : jSONObject.optString("text");
        JSONObject jSONObject2 = resObj;
        String string2 = source = jSONObject2 == null ? null : jSONObject2.optString("source");
        if (text != null) {
            translateResultBean.setResult(new Translation(text, null, source));
        }
        JSONObject jSONObject3 = resObj;
        JSONArray jSONArray = texts = jSONObject3 == null ? null : jSONObject3.optJSONArray("texts");
        if (texts != null) {
            String[] strs = new String[texts.length()];
            int n = 0;
            int n2 = texts.length();
            while (n < n2) {
                int i = n++;
                strs[i] = texts.getString(i);
            }
            translateResultBean.setResult(new Translation(null, strs, source));
        }
        return translateResultBean;
    }

    private final String getServerBaseUrl(Context $this$getServerBaseUrl) {
        return BASE_URL_RELEASE;
    }

    @kotlinx.serialization.Serializable
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 -2\u00020\u0001:\u0002,-B5\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0019\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u00c6\u0003J)\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\b\u0010#\u001a\u00020\u001fH\u0007J\b\u0010$\u001a\u00020\u0006H\u0016J!\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u00c7\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/hiservice/translate/HiTranslator$TranslateResult;", "Ljava/io/Serializable;", "seen1", "", "code", "message", "", "result", "Lcom/hiservice/translate/HiTranslator$Translation;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IILjava/lang/String;Lcom/hiservice/translate/HiTranslator$Translation;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(ILjava/lang/String;Lcom/hiservice/translate/HiTranslator$Translation;)V", "getCode$fun_translate_release", "()I", "setCode$fun_translate_release", "(I)V", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "getResult", "()Lcom/hiservice/translate/HiTranslator$Translation;", "setResult", "(Lcom/hiservice/translate/HiTranslator$Translation;)V", "component1", "component1$fun_translate_release", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "isSuccess", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "fun-translate_release"})
    @Keep
    public static final class TranslateResult
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int code;
        @NotNull
        private String message;
        @Nullable
        private Translation result;

        public TranslateResult(int code, @NotNull String message, @Nullable Translation result) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.code = code;
            this.message = message;
            this.result = result;
        }

        public /* synthetic */ TranslateResult(int n, String string, Translation translation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                translation = null;
            }
            this(n, string, translation);
        }

        public final int getCode$fun_translate_release() {
            return this.code;
        }

        public final void setCode$fun_translate_release(int n) {
            this.code = n;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.message = string;
        }

        @Nullable
        public final Translation getResult() {
            return this.result;
        }

        public final void setResult(@Nullable Translation translation) {
            this.result = translation;
        }

        @Keep
        public final boolean isSuccess() {
            return this.code == 1000;
        }

        @NotNull
        public String toString() {
            return "TranslateResult(code=" + this.code + ", message='" + this.message + "', result=" + this.result + ')';
        }

        public final int component1$fun_translate_release() {
            return this.code;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final Translation component3() {
            return this.result;
        }

        @NotNull
        public final TranslateResult copy(int code, @NotNull String message, @Nullable Translation result) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new TranslateResult(code, message, result);
        }

        public static /* synthetic */ TranslateResult copy$default(TranslateResult translateResult, int n, String string, Translation translation, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = translateResult.code;
            }
            if ((n2 & 2) != 0) {
                string = translateResult.message;
            }
            if ((n2 & 4) != 0) {
                translation = translateResult.result;
            }
            return translateResult.copy(n, string, translation);
        }

        public int hashCode() {
            int result = Integer.hashCode(this.code);
            result = result * 31 + this.message.hashCode();
            result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TranslateResult)) {
                return false;
            }
            TranslateResult translateResult = (TranslateResult)other;
            if (this.code != translateResult.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)translateResult.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.result, (Object)translateResult.result);
        }

        @JvmStatic
        public static final void write$Self(@NotNull TranslateResult self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            output.encodeIntElement(serialDesc, 0, self.code);
            output.encodeStringElement(serialDesc, 1, self.message);
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.result != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)Translation$$serializer.INSTANCE, (Object)self.result);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ TranslateResult(int seen1, int code, String message, Translation result, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)TranslateResult$$serializer.INSTANCE.getDescriptor());
            }
            this.code = code;
            this.message = message;
            this.result = (seen1 & 4) == 0 ? null : result;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/translate/HiTranslator$TranslateResult$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/hiservice/translate/HiTranslator$TranslateResult;", "fun-translate_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TranslateResult> serializer() {
                return (KSerializer)TranslateResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlinx.serialization.Serializable
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0002%&B?\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB+\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0018\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J:\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J!\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u00c7\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/hiservice/translate/HiTranslator$Translation;", "Ljava/io/Serializable;", "seen1", "", "text", "", "texts", "", "source", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;[Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "getText", "getTexts", "()[Ljava/lang/String;", "[Ljava/lang/String;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Lcom/hiservice/translate/HiTranslator$Translation;", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "fun-translate_release"})
    @Keep
    public static final class Translation
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String text;
        @Nullable
        private final String[] texts;
        @Nullable
        private final String source;

        public Translation(@Nullable String text, @Nullable String[] texts, @Nullable String source) {
            this.text = text;
            this.texts = texts;
            this.source = source;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String[] getTexts() {
            return this.texts;
        }

        @Nullable
        public final String getSource() {
            return this.source;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.hiservice.translate.HiTranslator.Translation");
            }
            Translation cfr_ignored_0 = (Translation)object2;
            if (!Intrinsics.areEqual((Object)this.text, (Object)((Translation)other).text)) {
                return false;
            }
            if (this.texts != null) {
                if (((Translation)other).texts == null) {
                    return false;
                }
                if (!Arrays.equals(this.texts, ((Translation)other).texts)) {
                    return false;
                }
            } else if (((Translation)other).texts != null) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)((Translation)other).source);
        }

        public int hashCode() {
            int n;
            String string = this.text;
            int result = string == null ? 0 : (n = string.hashCode());
            Object[] objectArray = this.texts;
            result = 31 * result + (objectArray == null ? 0 : (n = Arrays.hashCode(objectArray)));
            String string2 = this.source;
            result = 31 * result + (string2 == null ? 0 : (n = string2.hashCode()));
            return result;
        }

        @NotNull
        public String toString() {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Translation(text=").append((Object)this.text).append(", texts=");
            Object[] objectArray = this.texts;
            if (objectArray == null) {
                string = null;
            } else {
                String string2 = Arrays.toString(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
                string = string2;
            }
            return stringBuilder.append((Object)string).append(", source=").append((Object)this.source).append(')').toString();
        }

        @Nullable
        public final String component1() {
            return this.text;
        }

        @Nullable
        public final String[] component2() {
            return this.texts;
        }

        @Nullable
        public final String component3() {
            return this.source;
        }

        @NotNull
        public final Translation copy(@Nullable String text, @Nullable String[] texts, @Nullable String source) {
            return new Translation(text, texts, source);
        }

        public static /* synthetic */ Translation copy$default(Translation translation, String string, String[] stringArray, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = translation.text;
            }
            if ((n & 2) != 0) {
                stringArray = translation.texts;
            }
            if ((n & 4) != 0) {
                string2 = translation.source;
            }
            return translation.copy(string, stringArray, string2);
        }

        @JvmStatic
        public static final void write$Self(@NotNull Translation self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.text);
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)new ReferenceArraySerializer(Reflection.getOrCreateKotlinClass(String.class), BuiltinSerializersKt.getNullable((KSerializer)((KSerializer)StringSerializer.INSTANCE))), (Object)self.texts);
            output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.source);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ Translation(int seen1, String text, String[] texts, String source, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)7, (SerialDescriptor)Translation$$serializer.INSTANCE.getDescriptor());
            }
            this.text = text;
            this.texts = texts;
            this.source = source;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/translate/HiTranslator$Translation$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/hiservice/translate/HiTranslator$Translation;", "fun-translate_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Translation> serializer() {
                return (KSerializer)Translation$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/hiservice/translate/HiTranslator$Companion;", "", "()V", "BASE_URL_DEBUG", "", "BASE_URL_RELEASE", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "READ_TIME_OUT", "REQUEST_METHOD", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

