/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.tools;

import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import com.google.common.primitives.Floats;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;

public final class TensorUtils {
    public static OnnxTensor createInt64TensorWithSingleValue(OrtEnvironment onnxEnv, long value, long[] shape) {
        LongBuffer buffer;
        long flat_length = shape[0];
        for (int i = 1; i < shape.length; ++i) {
            flat_length *= shape[i];
        }
        if (value != 0L) {
            long[] array = new long[(int)flat_length];
            Arrays.fill(array, value);
            buffer = LongBuffer.wrap(array);
        } else {
            buffer = ByteBuffer.allocateDirect((int)(flat_length * 8L)).asLongBuffer();
        }
        try {
            return OnnxTensor.createTensor((OrtEnvironment)onnxEnv, (LongBuffer)buffer, (long[])shape);
        }
        catch (OrtException e) {
            throw new RuntimeException(e);
        }
    }

    public static float[] flattenFloatArray(float[][][] data) {
        float[][] dataFlatTemp = new float[data.length][data[0].length * data[0][0].length];
        for (int j = 0; j < data.length; ++j) {
            dataFlatTemp[j] = Floats.concat((float[][])data[j]);
        }
        return Floats.concat((float[][])dataFlatTemp);
    }

    public static OnnxTensor convertBooleanToTensor(OrtEnvironment env, boolean input) throws OrtException {
        long[] shape = new long[]{1L};
        byte[] inputBytes = new byte[]{0};
        if (input) {
            inputBytes[0] = 1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(inputBytes);
        return OnnxTensor.createTensor((OrtEnvironment)env, (ByteBuffer)byteBuffer, (long[])shape, (OnnxJavaType)OnnxJavaType.BOOL);
    }

    public static OnnxTensor createFloatTensorWithSingleValue(OrtEnvironment env, float value, long[] shape) throws OrtException {
        FloatBuffer buffer;
        long flat_length = shape[0];
        for (int i = 1; i < shape.length; ++i) {
            flat_length *= shape[i];
        }
        if (value != 0.0f) {
            float[] array = new float[(int)flat_length];
            Arrays.fill(array, value);
            buffer = FloatBuffer.wrap(array);
        } else {
            buffer = ByteBuffer.allocateDirect((int)(flat_length * 4L)).asFloatBuffer();
        }
        return OnnxTensor.createTensor((OrtEnvironment)env, (FloatBuffer)buffer, (long[])shape);
    }
}

