/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.tools;

import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import android.content.Context;
import android.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;

public class Utils {
    public static String copyAssetToInternalStorage(Context context, String assetFilePath, String destinationFileName) throws IOException {
        File file = new File(context.getFilesDir(), destinationFileName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        try (InputStream inputStream = context.getAssets().open(assetFilePath);
             FileOutputStream outputStream = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
        }
        return file.getAbsolutePath();
    }

    public static OnnxTensor createTensor(OrtEnvironment onnxEnv, int[][] data) throws OrtException {
        long[] shape = new long[]{data.length, data[0].length};
        long[] longData = new long[data.length * data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                longData[i * data[i].length + j] = data[i][j];
            }
        }
        return OnnxTensor.createTensor((OrtEnvironment)onnxEnv, (LongBuffer)LongBuffer.wrap(longData), (long[])shape);
    }

    public static OnnxTensor createTensor(OrtEnvironment onnxEnv, int[] data) throws OrtException {
        long[] shape = new long[]{1L, data.length};
        long[] longData = Arrays.stream(data).mapToLong(i -> i).toArray();
        return OnnxTensor.createTensor((OrtEnvironment)onnxEnv, (LongBuffer)LongBuffer.wrap(longData), (long[])shape);
    }

    public static OnnxTensor createTensor(OrtEnvironment onnxEnv, long[] shape, float[] data) throws OrtException {
        FloatBuffer floatBuffer = FloatBuffer.wrap(data);
        return OnnxTensor.createTensor((OrtEnvironment)onnxEnv, (FloatBuffer)floatBuffer, (long[])shape);
    }

    public static int argmax(float[] array) {
        int maxIndex = 0;
        float maxValue = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > maxValue)) continue;
            maxValue = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static List<Pair<Integer, Float>> argTopK(float[] array, int k) {
        PriorityQueue<Pair> minHeap = new PriorityQueue<Pair>(k, (a, b) -> Float.compare(((Float)a.second).floatValue(), ((Float)b.second).floatValue()));
        for (int i = 0; i < array.length; ++i) {
            if (minHeap.size() < k) {
                minHeap.offer(new Pair((Object)i, (Object)Float.valueOf(array[i])));
                continue;
            }
            if (!(array[i] > ((Float)((Pair)minHeap.peek()).second).floatValue())) continue;
            minHeap.poll();
            minHeap.offer(new Pair((Object)i, (Object)Float.valueOf(array[i])));
        }
        return new ArrayList<Pair<Integer, Float>>(minHeap);
    }
}

