/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.WorkerThread;
import com.hiservice.translate.HiLanguageKt;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/hiservice/translate/HiLanguage;", "", "<init>", "()V", "list", "Lcom/hiservice/translate/HiLanguage$HiLanguageListBean;", "type", "Lcom/hiservice/translate/HiLanguage$Type;", "readInputStream", "inputStream", "Ljava/io/InputStream;", "Companion", "Type", "HiLanguageListBean", "HiLanguageBean", "fun-translate_release"})
public final class HiLanguage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BASE_URL_RELEASE = "https://api.translasion.com/v1/language_list?type=";
    private static int CONNECT_TIME_OUT_MS = 6000;
    private static int READ_TIME_OUT_MS = 8000;
    @NotNull
    private static final String REQUEST_METHOD = "GET";
    @NotNull
    private static final String CONTENT_TYPE = "application/json";
    public static final int ERROR_CODE_NO_CODE = -1;
    public static final int ERROR_CODE_EXCEPTION = -2;

    @WorkerThread
    @NotNull
    public final HiLanguageListBean list(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        try {
            URL url = new URL(BASE_URL_RELEASE + type.getIndex());
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod(REQUEST_METHOD);
            connection.setRequestProperty("content-type", CONTENT_TYPE);
            connection.setConnectTimeout(CONNECT_TIME_OUT_MS);
            connection.setReadTimeout(READ_TIME_OUT_MS);
            connection.setDefaultUseCaches(true);
            connection.setDoOutput(false);
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNull((Object)inputStream);
            HiLanguageListBean result = this.readInputStream(inputStream);
            inputStream.close();
            connection.disconnect();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HiLanguageListBean(-2, e.getMessage(), null, 4, null);
        }
    }

    public static /* synthetic */ HiLanguageListBean list$default(HiLanguage hiLanguage, Type type, int n, Object object) {
        if ((n & 1) != 0) {
            type = Type.TEXT;
        }
        return hiLanguage.list(type);
    }

    private final HiLanguageListBean readInputStream(InputStream inputStream) {
        JSONArray dataObj;
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        String content = new String(bytes, Charsets.UTF_8);
        Log.v((String)"HiService", (String)("language list:" + content));
        JSONObject obj = new JSONObject(content);
        int code = obj.has("code") ? obj.optInt("code") : -1;
        String message = obj.has("message") ? obj.optString("message") : "";
        JSONArray jSONArray = dataObj = obj.has("data") ? obj.optJSONArray("data") : null;
        if (dataObj == null) {
            return new HiLanguageListBean(code, message, null);
        }
        int length = dataObj.length();
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (int i = 0; i < length; ++i) {
            Object object = dataObj.optJSONObject(i);
            if (object == null || (object = HiLanguageKt.access$toHiLanguageBean(object)) == null) continue;
            Object it = object;
            boolean bl = false;
            data.add((JSONObject)it);
        }
        return new HiLanguageListBean(code, message, (List<HiLanguageBean>)data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hiservice/translate/HiLanguage$Companion;", "", "<init>", "()V", "BASE_URL_RELEASE", "", "CONNECT_TIME_OUT_MS", "", "getCONNECT_TIME_OUT_MS", "()I", "setCONNECT_TIME_OUT_MS", "(I)V", "READ_TIME_OUT_MS", "getREAD_TIME_OUT_MS", "setREAD_TIME_OUT_MS", "REQUEST_METHOD", "CONTENT_TYPE", "ERROR_CODE_NO_CODE", "ERROR_CODE_EXCEPTION", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCONNECT_TIME_OUT_MS() {
            return CONNECT_TIME_OUT_MS;
        }

        public final void setCONNECT_TIME_OUT_MS(int n) {
            CONNECT_TIME_OUT_MS = n;
        }

        public final int getREAD_TIME_OUT_MS() {
            return READ_TIME_OUT_MS;
        }

        public final void setREAD_TIME_OUT_MS(int n) {
            READ_TIME_OUT_MS = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlinx.serialization.Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u0003H\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/hiservice/translate/HiLanguage$HiLanguageBean;", "Ljava/io/Serializable;", "code", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "getName", "setName", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "fun-translate_release"})
    @Keep
    public static final class HiLanguageBean
    implements Serializable {
        @NotNull
        private String code;
        @Nullable
        private String name;

        public HiLanguageBean(@NotNull String code, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
            this.name = name;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public final void setCode(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.code = string;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @NotNull
        public String toString() {
            return this.name + '(' + this.code + ')';
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final HiLanguageBean copy(@NotNull String code, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new HiLanguageBean(code, name);
        }

        public static /* synthetic */ HiLanguageBean copy$default(HiLanguageBean hiLanguageBean, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = hiLanguageBean.code;
            }
            if ((n & 2) != 0) {
                string2 = hiLanguageBean.name;
            }
            return hiLanguageBean.copy(string, string2);
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HiLanguageBean)) {
                return false;
            }
            HiLanguageBean hiLanguageBean = (HiLanguageBean)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)hiLanguageBean.code)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)hiLanguageBean.name);
        }
    }

    @kotlinx.serialization.Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/hiservice/translate/HiLanguage$HiLanguageListBean;", "Ljava/io/Serializable;", "code", "", "message", "", "list", "", "Lcom/hiservice/translate/HiLanguage$HiLanguageBean;", "<init>", "(ILjava/lang/String;Ljava/util/List;)V", "getCode", "()I", "getMessage", "()Ljava/lang/String;", "getList", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "fun-translate_release"})
    @Keep
    public static final class HiLanguageListBean
    implements Serializable {
        private final int code;
        @Nullable
        private final String message;
        @Nullable
        private final List<HiLanguageBean> list;

        public HiLanguageListBean(int code, @Nullable String message, @Nullable List<HiLanguageBean> list) {
            this.code = code;
            this.message = message;
            this.list = list;
        }

        public /* synthetic */ HiLanguageListBean(int n, String string, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                list = null;
            }
            this(n, string, list);
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final List<HiLanguageBean> getList() {
            return this.list;
        }

        public final int component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final List<HiLanguageBean> component3() {
            return this.list;
        }

        @NotNull
        public final HiLanguageListBean copy(int code, @Nullable String message, @Nullable List<HiLanguageBean> list) {
            return new HiLanguageListBean(code, message, list);
        }

        public static /* synthetic */ HiLanguageListBean copy$default(HiLanguageListBean hiLanguageListBean, int n, String string, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = hiLanguageListBean.code;
            }
            if ((n2 & 2) != 0) {
                string = hiLanguageListBean.message;
            }
            if ((n2 & 4) != 0) {
                list = hiLanguageListBean.list;
            }
            return hiLanguageListBean.copy(n, string, list);
        }

        @NotNull
        public String toString() {
            return "HiLanguageListBean(code=" + this.code + ", message=" + this.message + ", list=" + this.list + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.code);
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + (this.list == null ? 0 : ((Object)this.list).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HiLanguageListBean)) {
                return false;
            }
            HiLanguageListBean hiLanguageListBean = (HiLanguageListBean)other;
            if (this.code != hiLanguageListBean.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)hiLanguageListBean.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.list, hiLanguageListBean.list);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/hiservice/translate/HiLanguage$Type;", "", "index", "", "<init>", "(Ljava/lang/String;II)V", "getIndex", "()I", "TEXT", "SPEECH2TEXT", "TEXT2SPEECH", "OCR", "fun-translate_release"})
    public static final class Type
    extends Enum<Type> {
        private final int index;
        public static final /* enum */ Type TEXT = new Type(1);
        public static final /* enum */ Type SPEECH2TEXT = new Type(2);
        public static final /* enum */ Type TEXT2SPEECH = new Type(3);
        public static final /* enum */ Type OCR = new Type(4);
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.TEXT, Type.SPEECH2TEXT, Type.TEXT2SPEECH, Type.OCR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

