/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.WorkerThread;
import com.hiservice.tools.ExtKt;
import com.hiservice.tools.SPUtil;
import com.hiservice.translate.OfflineTranslateHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper;", "", "context", "Landroid/content/Context;", "listener", "Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;", "<init>", "(Landroid/content/Context;Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;)V", "downloadLanguageMode", "", "languageCode", "", "isFileDownloaded", "", "url", "unzipFile", "zipFile", "Ljava/io/File;", "targetDirectory", "Companion", "DownloadListener", "fun-translate_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nLanguageModelDownloadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageModelDownloadHelper.kt\ncom/hiservice/translate/LanguageModelDownloadHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n1#2:316\n*E\n"})
public final class LanguageModelDownloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DownloadListener listener;
    @NotNull
    private static final String TAG = "LangDownloadHelper";
    @NotNull
    private static final Map<String, String> languageModeMap;
    public static final long TIME_OUT = 30L;
    @NotNull
    public static final String LANGUAGE_MODE_PATH = "com.google.mlkit.translate.models";
    @NotNull
    public static final String FILE_NAME = "language_model.zip";
    @NotNull
    private static final String URL = "https://api.translasion.com/v1/language_list/text/translate";
    @NotNull
    private static final String URL_DEBUG = "https://test.translasion.com/v1/language_list/text/translate";

    public LanguageModelDownloadHelper(@NotNull Context context, @NotNull DownloadListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.context = context;
        this.listener = listener;
    }

    @WorkerThread
    public final void downloadLanguageMode(@NotNull String languageCode) {
        String url;
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        String string = languageModeMap.get(languageCode);
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(url = string)).length() == 0) {
            this.listener.onError(new Exception("Can't find download url"), url);
            return;
        }
        if (this.isFileDownloaded(url)) {
            this.listener.onDownloadComplete(url);
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        this.listener.onStartDownload(url);
        client.newCall(request).enqueue(new Callback(this, url){
            final /* synthetic */ LanguageModelDownloadHelper this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(e, this.$url);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void onResponse(Call call, Response response) {
                InputStream inputStream;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(new IOException("Unexpected code " + response), this.$url);
                    return;
                }
                File customDir = OfflineTranslateHelper.Companion.getInstance().getCustomModuleDir();
                File defaultDir = new File(LanguageModelDownloadHelper.access$getContext$p(this.this$0).getNoBackupFilesDir(), "com.google.mlkit.translate.models");
                File noBackupDir = null;
                File file = customDir;
                if (file == null) {
                    file = defaultDir;
                }
                if (!(noBackupDir = file).exists()) {
                    noBackupDir.mkdirs();
                }
                File file2 = new File(noBackupDir, "language_model.zip");
                InputStream inputStream2 = null;
                FileOutputStream outputStream = null;
                try {
                    ResponseBody responseBody = response.body();
                    inputStream2 = responseBody != null ? responseBody.byteStream() : null;
                    outputStream = new FileOutputStream(file2);
                    byte[] buffer = new byte[2048];
                    int bytesRead = 0;
                    ResponseBody responseBody2 = response.body();
                    long totalSize = responseBody2 != null ? responseBody2.contentLength() : 0L;
                    long downloadedSize = 0L;
                    InputStream inputStream3 = inputStream2;
                    if (inputStream3 != null) {
                        InputStream inputStream4 = inputStream3;
                        LanguageModelDownloadHelper languageModelDownloadHelper = this.this$0;
                        String string = this.$url;
                        InputStream it = inputStream4;
                        boolean bl = false;
                        while (true) {
                            int n;
                            int it2 = n = it.read(buffer);
                            boolean bl2 = false;
                            bytesRead = it2;
                            if (n == -1) break;
                            outputStream.write(buffer, 0, bytesRead);
                            downloadedSize += (long)bytesRead;
                            if (totalSize <= 0L) continue;
                            int progress = (int)(downloadedSize * (long)100 / totalSize);
                            LanguageModelDownloadHelper.access$getListener$p(languageModelDownloadHelper).onProgressUpdate(progress, string);
                        }
                        outputStream.flush();
                        int reuse = ExtKt.safeToInt$default(ExtKt.getParamsFromUrl(string, "reuse"), 0, 1, null);
                        if (reuse == 1) {
                            void $this$filterTo$iv$iv;
                            String checksum = ExtKt.getParamsFromUrl(string, "checksum");
                            ExtKt.log("\u65b0\u7248\u79bb\u7ebf\u5305 checksum:" + checksum, "lbx_LangDownloadHelper");
                            SPUtil.INSTANCE.saveCheckSum(LanguageModelDownloadHelper.access$getContext$p(languageModelDownloadHelper), string, checksum);
                            String string2 = ExtKt.getFileNameFromUrl(string);
                            if (string2 == null) {
                                string2 = "";
                            }
                            if (!(noBackupDir = new File(noBackupDir, string2)).exists()) {
                                noBackupDir.mkdirs();
                            }
                            Map $this$filter$iv = LanguageModelDownloadHelper.access$getLanguageModeMap$cp();
                            boolean $i$f$filter = false;
                            Map map = $this$filter$iv;
                            Map destination$iv$iv = new LinkedHashMap<K, V>();
                            boolean $i$f$filterTo = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv$iv;
                                Map.Entry<K, V> e = element$iv$iv = iterator.next();
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(e.getValue(), (Object)string)) continue;
                                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                            }
                            List supportList = CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
                            ExtKt.log(noBackupDir.getName() + " \u652f\u6301\u7684\u8bed\u8a00\uff1a" + supportList, "lbx_LangDownloadHelper");
                            Context context = LanguageModelDownloadHelper.access$getContext$p(languageModelDownloadHelper);
                            String string3 = noBackupDir.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                            SPUtil.INSTANCE.saveSupportLanguages(context, string3, supportList);
                        } else {
                            String key = ExtKt.getFileNameFromUrl(string);
                            int version = ExtKt.safeToInt(ExtKt.getParamsFromUrl(string, "version"), 1);
                            ExtKt.log("\u65b0\u7248\u79bb\u7ebf\u5305 key:" + key + " version:" + version, "lbx_LangDownloadHelper");
                            SPUtil.INSTANCE.saveLanguageVersion(LanguageModelDownloadHelper.access$getContext$p(languageModelDownloadHelper), key, version);
                        }
                        LanguageModelDownloadHelper.access$unzipFile(languageModelDownloadHelper, file2, noBackupDir);
                        LanguageModelDownloadHelper.access$getListener$p(languageModelDownloadHelper).onDownloadComplete(string);
                        file2.delete();
                    }
                    inputStream = inputStream2;
                }
                catch (Exception e) {
                    InputStream inputStream5;
                    try {
                        LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(e, this.$url);
                        inputStream5 = inputStream2;
                    }
                    catch (Throwable throwable) {
                        InputStream inputStream6 = inputStream2;
                        if (inputStream6 != null) {
                            inputStream6.close();
                        }
                        FileOutputStream fileOutputStream = outputStream;
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        throw throwable;
                    }
                    if (inputStream5 != null) {
                        inputStream5.close();
                    }
                    FileOutputStream fileOutputStream = outputStream;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                outputStream.close();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFileDownloaded(String url) {
        boolean bl;
        File customDir = OfflineTranslateHelper.Companion.getInstance().getCustomModuleDir();
        File defaultDir = new File(this.context.getNoBackupFilesDir(), LANGUAGE_MODE_PATH);
        File file = customDir;
        if (file == null) {
            file = defaultDir;
        }
        File noBackupDir = file;
        String folderPath = noBackupDir.getAbsolutePath();
        String string = ExtKt.getFileNameFromUrl(url);
        if (string == null) {
            string = "";
        }
        String fileName = string;
        String filePath = folderPath + '/' + fileName;
        File file2 = new File(filePath);
        int reuse = ExtKt.safeToInt$default(ExtKt.getParamsFromUrl(url, "reuse"), 0, 1, null);
        int version = ExtKt.safeToInt(ExtKt.getParamsFromUrl(url, "version"), 1);
        if (reuse == 1 && version >= 5) {
            String saveChecksum;
            String checksum = ExtKt.getParamsFromUrl(url, "checksum");
            boolean hasNew = !Intrinsics.areEqual((Object)checksum, (Object)(saveChecksum = SPUtil.INSTANCE.getCheckSum(this.context, url)));
            ExtKt.log("\u65b0\u7248\u79bb\u7ebf\u5305 hasNew:" + hasNew + "  file.exists():" + file2.exists(), "lbx_LangDownloadHelper");
            bl = hasNew;
        } else {
            int saveVersion = SPUtil.INSTANCE.getLanguageVersion(this.context, fileName);
            ExtKt.log("\u65e7\u7248\u79bb\u7ebf\u5305 version:" + version + " saveVersion:" + saveVersion, "lbx_LangDownloadHelper");
            if (version > saveVersion) {
                return false;
            }
            bl = false;
        }
        boolean hasNewVersion = bl;
        if (hasNewVersion) return false;
        if (!file2.exists()) return false;
        if (file2.length() <= 0L) return false;
        File[] fileArray = file2.listFiles();
        if (fileArray == null) return false;
        int n = fileArray.length;
        if (n <= 2) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void unzipFile(File zipFile, File targetDirectory) throws IOException {
        ExtKt.log("unzipFile " + zipFile.getAbsolutePath() + " -> " + targetDirectory, "lbx_LangDownloadHelper");
        var3_3 = new ZipInputStream(new FileInputStream(zipFile));
        var4_4 = null;
        try {
            zis = (ZipInputStream)var3_3;
            $i$a$-use-LanguageModelDownloadHelper$unzipFile$1 = false;
            zipEntry = null;
            buffer = new byte[1024];
            while (true) lbl-1000:
            // 4 sources

            {
                it = var9_11 = zis.getNextEntry();
                $i$a$-also-LanguageModelDownloadHelper$unzipFile$1$1 = false;
                zipEntry = it;
                if (var9_11 == null) ** break;
                v0 = zipEntry;
                Intrinsics.checkNotNull((Object)v0);
                newFile = new File(targetDirectory, v0.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + newFile.getAbsolutePath());
                }
                parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent.getAbsolutePath());
                }
                var11_14 = new FileOutputStream(newFile);
                var12_15 = null;
                try {
                    fos = (FileOutputStream)var11_14;
                    $i$a$-use-LanguageModelDownloadHelper$unzipFile$1$2 = false;
                    len = 0;
                    while (true) {
                        it = var16_21 = zis.read(buffer);
                        $i$a$-also-LanguageModelDownloadHelper$unzipFile$1$2$1 = false;
                        len = it;
                        if (var16_21 <= 0) break;
                        fos.write(buffer, 0, len);
                    }
                    var13_16 = Unit.INSTANCE;
                }
                catch (Throwable var14_18) {
                    var12_15 = var14_18;
                    throw var14_18;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var11_14, (Throwable)var12_15);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            var5_5 = Unit.INSTANCE;
        }
        catch (Throwable var6_7) {
            var4_4 = var6_7;
            throw var6_7;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_4);
        }
    }

    @JvmStatic
    public static final void fetchLanguageModeMap$fun_translate_release() {
        Companion.fetchLanguageModeMap$fun_translate_release();
    }

    public static final /* synthetic */ Map access$getLanguageModeMap$cp() {
        return languageModeMap;
    }

    public static final /* synthetic */ DownloadListener access$getListener$p(LanguageModelDownloadHelper $this) {
        return $this.listener;
    }

    public static final /* synthetic */ Context access$getContext$p(LanguageModelDownloadHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$unzipFile(LanguageModelDownloadHelper $this, File zipFile, File targetDirectory) {
        $this.unzipFile(zipFile, targetDirectory);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"af", (Object)"https://support.igofun.mobi/offline_translate/af_en.zip"), TuplesKt.to((Object)"ar", (Object)"https://support.igofun.mobi/offline_translate/ar_en.zip"), TuplesKt.to((Object)"be", (Object)"https://support.igofun.mobi/offline_translate/be_en.zip"), TuplesKt.to((Object)"bg", (Object)"https://support.igofun.mobi/offline_translate/bg_en.zip"), TuplesKt.to((Object)"bn", (Object)"https://support.igofun.mobi/offline_translate/bn_en.zip"), TuplesKt.to((Object)"ca", (Object)"https://support.igofun.mobi/offline_translate/ca_en.zip"), TuplesKt.to((Object)"cs", (Object)"https://support.igofun.mobi/offline_translate/cs_en.zip"), TuplesKt.to((Object)"cy", (Object)"https://support.igofun.mobi/offline_translate/cy_en.zip"), TuplesKt.to((Object)"da", (Object)"https://support.igofun.mobi/offline_translate/da_en.zip"), TuplesKt.to((Object)"de", (Object)"https://support.igofun.mobi/offline_translate/de_en.zip"), TuplesKt.to((Object)"el", (Object)"https://support.igofun.mobi/offline_translate/el_en.zip"), TuplesKt.to((Object)"eo", (Object)"https://support.igofun.mobi/offline_translate/en_eo.zip"), TuplesKt.to((Object)"es", (Object)"https://support.igofun.mobi/offline_translate/en_es.zip"), TuplesKt.to((Object)"et", (Object)"https://support.igofun.mobi/offline_translate/en_et.zip"), TuplesKt.to((Object)"fa", (Object)"https://support.igofun.mobi/offline_translate/en_fa.zip"), TuplesKt.to((Object)"fi", (Object)"https://support.igofun.mobi/offline_translate/en_fi.zip"), TuplesKt.to((Object)"fr", (Object)"https://support.igofun.mobi/offline_translate/en_fr.zip"), TuplesKt.to((Object)"ga", (Object)"https://support.igofun.mobi/offline_translate/en_ga.zip"), TuplesKt.to((Object)"gl", (Object)"https://support.igofun.mobi/offline_translate/en_gl.zip"), TuplesKt.to((Object)"gu", (Object)"https://support.igofun.mobi/offline_translate/en_gu.zip"), TuplesKt.to((Object)"he", (Object)"https://support.igofun.mobi/offline_translate/en_iw.zip"), TuplesKt.to((Object)"hi", (Object)"https://support.igofun.mobi/offline_translate/en_hi.zip"), TuplesKt.to((Object)"hr", (Object)"https://support.igofun.mobi/offline_translate/en_hr.zip"), TuplesKt.to((Object)"ht", (Object)"https://support.igofun.mobi/offline_translate/en_ht.zip"), TuplesKt.to((Object)"hu", (Object)"https://support.igofun.mobi/offline_translate/en_hu.zip"), TuplesKt.to((Object)"id", (Object)"https://support.igofun.mobi/offline_translate/en_id.zip"), TuplesKt.to((Object)"is", (Object)"https://support.igofun.mobi/offline_translate/en_is.zip"), TuplesKt.to((Object)"it", (Object)"https://support.igofun.mobi/offline_translate/en_it.zip"), TuplesKt.to((Object)"ja", (Object)"https://support.igofun.mobi/offline_translate/en_ja.zip"), TuplesKt.to((Object)"ka", (Object)"https://support.igofun.mobi/offline_translate/en_ka.zip"), TuplesKt.to((Object)"kn", (Object)"https://support.igofun.mobi/offline_translate/en_kn.zip"), TuplesKt.to((Object)"ko", (Object)"https://support.igofun.mobi/offline_translate/en_ko.zip"), TuplesKt.to((Object)"lt", (Object)"https://support.igofun.mobi/offline_translate/en_lt.zip"), TuplesKt.to((Object)"lv", (Object)"https://support.igofun.mobi/offline_translate/en_lv.zip"), TuplesKt.to((Object)"mk", (Object)"https://support.igofun.mobi/offline_translate/en_mk.zip"), TuplesKt.to((Object)"mr", (Object)"https://support.igofun.mobi/offline_translate/en_mr.zip"), TuplesKt.to((Object)"ms", (Object)"https://support.igofun.mobi/offline_translate/en_ms.zip"), TuplesKt.to((Object)"mt", (Object)"https://support.igofun.mobi/offline_translate/en_mt.zip"), TuplesKt.to((Object)"nl", (Object)"https://support.igofun.mobi/offline_translate/en_nl.zip"), TuplesKt.to((Object)"no", (Object)"https://support.igofun.mobi/offline_translate/en_no.zip"), TuplesKt.to((Object)"pl", (Object)"https://support.igofun.mobi/offline_translate/en_pl.zip"), TuplesKt.to((Object)"pt", (Object)"https://support.igofun.mobi/offline_translate/en_pt.zip"), TuplesKt.to((Object)"ro", (Object)"https://support.igofun.mobi/offline_translate/en_ro.zip"), TuplesKt.to((Object)"ru", (Object)"https://support.igofun.mobi/offline_translate/en_ru.zip"), TuplesKt.to((Object)"sk", (Object)"https://support.igofun.mobi/offline_translate/en_sk.zip"), TuplesKt.to((Object)"sl", (Object)"https://support.igofun.mobi/offline_translate/en_sl.zip"), TuplesKt.to((Object)"sq", (Object)"https://support.igofun.mobi/offline_translate/en_sq.zip"), TuplesKt.to((Object)"sv", (Object)"https://support.igofun.mobi/offline_translate/en_sv.zip"), TuplesKt.to((Object)"sw", (Object)"https://support.igofun.mobi/offline_translate/en_sw.zip"), TuplesKt.to((Object)"ta", (Object)"https://support.igofun.mobi/offline_translate/en_ta.zip"), TuplesKt.to((Object)"te", (Object)"https://support.igofun.mobi/offline_translate/en_te.zip"), TuplesKt.to((Object)"th", (Object)"https://support.igofun.mobi/offline_translate/en_th.zip"), TuplesKt.to((Object)"tl", (Object)"https://support.igofun.mobi/offline_translate/en_tl.zip"), TuplesKt.to((Object)"tr", (Object)"https://support.igofun.mobi/offline_translate/en_tr.zip"), TuplesKt.to((Object)"uk", (Object)"https://support.igofun.mobi/offline_translate/en_uk.zip"), TuplesKt.to((Object)"ur", (Object)"https://support.igofun.mobi/offline_translate/en_ur.zip"), TuplesKt.to((Object)"vi", (Object)"https://support.igofun.mobi/offline_translate/en_vi.zip"), TuplesKt.to((Object)"zh", (Object)"https://support.igofun.mobi/offline_translate/en_zh.zip")};
        languageModeMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper$Companion;", "", "<init>", "()V", "TAG", "", "languageModeMap", "", "TIME_OUT", "", "LANGUAGE_MODE_PATH", "FILE_NAME", "URL", "URL_DEBUG", "fetchLanguageModeMap", "", "fetchLanguageModeMap$fun_translate_release", "fetchLanguageModeMapImpl", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void fetchLanguageModeMap$fun_translate_release() {
            try {
                this.fetchLanguageModeMapImpl();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)LanguageModelDownloadHelper.TAG, (String)"fetchLanguageModeMap exception", (Throwable)e);
            }
        }

        private final void fetchLanguageModeMapImpl() {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            String reqUrl = LanguageModelDownloadHelper.URL;
            Request request = new Request.Builder().url(reqUrl + "?to=en&package_name=com.hiservice&version_code=4&version_name=3.0.2").build();
            client.newCall(request).enqueue(new Callback(){

                public void onResponse(Call call, Response response) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        JSONObject obj;
                        int code;
                        boolean bl = false;
                        Object object = response.body();
                        if (object == null || (object = object.string()) == null) {
                            object = "";
                        }
                        if ((code = (obj = new JSONObject((String)object)).optInt("code")) == 1000) {
                            JSONArray jSONArray = obj.optJSONArray("data");
                            if (jSONArray == null) {
                                return;
                            }
                            JSONArray array = jSONArray;
                            int n = array.length();
                            for (int i = 0; i < n; ++i) {
                                JSONObject translate;
                                JSONObject item;
                                if (array.optJSONObject(i) == null || item.optJSONObject("translate") == null) continue;
                                String key = translate.optString("code");
                                CharSequence charSequence = key;
                                if (charSequence == null || charSequence.length() == 0) {
                                    key = item.optString("code");
                                }
                                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"checksum", (Object)translate.optString("checksum")), TuplesKt.to((Object)"version", (Object)translate.optString("version")), TuplesKt.to((Object)"reuse", (Object)String.valueOf(translate.optInt("reuse", 0)))};
                                String string = ExtKt.appendParametersToUrl(translate.optString("url"), MapsKt.mapOf((Pair[])pairArray));
                                if (string == null) {
                                    string = "";
                                }
                                String value = string;
                                LanguageModelDownloadHelper.access$getLanguageModeMap$cp().put(key, value);
                            }
                            ExtKt.log("fetch success", "lbx_LangDownloadHelper");
                        }
                        Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }

                public void onFailure(Call call, IOException e) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\n\u001a\u00020\u00032\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;", "", "onStartDownload", "", "url", "", "onProgressUpdate", "percentage", "", "onDownloadComplete", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "fun-translate_release"})
    public static interface DownloadListener {
        public void onStartDownload(@NotNull String var1);

        public void onProgressUpdate(int var1, @NotNull String var2);

        public void onDownloadComplete(@NotNull String var1);

        public void onError(@NotNull Exception var1, @NotNull String var2);
    }
}

