/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate.offline;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.mlkit.common.model.DownloadConditions;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.model.RemoteModelManager;
import com.google.mlkit.common.sdkinternal.model.ModelFileHelper;
import com.google.mlkit.nl.translate.TranslateLanguage;
import com.google.mlkit.nl.translate.TranslateRemoteModel;
import com.google.mlkit.nl.translate.Translation;
import com.google.mlkit.nl.translate.Translator;
import com.google.mlkit.nl.translate.TranslatorOptions;
import com.hiservice.translate.OfflineTranslateHelper;
import com.hiservice.translate.offline.IDownloadCallback;
import com.hiservice.translate.offline.IDownloadStatusCallback;
import com.hiservice.translate.offline.IOfflineTranslate;
import com.hiservice.translate.offline.ITranslateCallback;
import com.hiservice.translate.offline.LanguageTagErrorException;
import com.hiservice.translate.offline.OfflineApplication;
import com.hiservice.translate.offline.ParamDownload;
import com.hiservice.translate.offline.ParamModel;
import com.hiservice.translate.offline.ParamTranslateText;
import com.hiservice.translate.offline.cases.FixModuleCase;
import com.hiservice.translate_v5.TranslateV5;
import com.hiservice.translate_v5.TranslateV5Manager;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\"\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\u001a\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\b\u0010\u0018\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020\u0015H\u0016J\u001a\u0010'\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010)\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0016J\u0012\u0010-\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010\nH\u0002J,\u0010\u001a\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u001fH\u0002J4\u00100\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\n2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u00010\r2\b\u00104\u001a\u0004\u0018\u00010\u001fH\u0002J*\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J$\u00109\u001a\u00020\u00152\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010:\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006<"}, d2={"Lcom/hiservice/translate/offline/OfflineTranslate;", "Lcom/hiservice/translate/offline/IOfflineTranslate;", "DBG", "", "count", "", "<init>", "(ZI)V", "clientMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/mlkit/nl/translate/Translator;", "customModuleDir", "Ljava/io/File;", "mFixModuleCase", "Lcom/hiservice/translate/offline/cases/FixModuleCase;", "getMFixModuleCase", "()Lcom/hiservice/translate/offline/cases/FixModuleCase;", "mFixModuleCase$delegate", "Lkotlin/Lazy;", "downloadMode", "", "paramDownload", "Lcom/hiservice/translate/offline/ParamDownload;", "callback", "Lcom/hiservice/translate/offline/IDownloadCallback;", "translate", "context", "Landroid/content/Context;", "paramTranslateText", "Lcom/hiservice/translate/offline/ParamTranslateText;", "Lcom/hiservice/translate/offline/ITranslateCallback;", "allLanguageTags", "", "isDownloadedMode", "paramModel", "Lcom/hiservice/translate/offline/ParamModel;", "Lcom/hiservice/translate/offline/IDownloadStatusCallback;", "destroy", "setCustomModuleDir", "file", "getCustomModuleDir", "getModuleDir", "fromCode", "toCode", "setCustomModuleSubDir", "customDir", "text", "translateV5", "from", "to", "mode", "cb", "downloadModeImpl", "languageTag", "requireWifi", "requireCharging", "ensureMapSizeLimit", "maxSize", "Companion", "fun-translate_release"})
@SourceDebugExtension(value={"SMAP\nOfflineTranslate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineTranslate.kt\ncom/hiservice/translate/offline/OfflineTranslate\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,407:1\n216#2,2:408\n*S KotlinDebug\n*F\n+ 1 OfflineTranslate.kt\ncom/hiservice/translate/offline/OfflineTranslate\n*L\n104#1:408,2\n*E\n"})
public final class OfflineTranslate
implements IOfflineTranslate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean DBG;
    private final int count;
    @NotNull
    private final ConcurrentHashMap<String, Translator> clientMap;
    @Nullable
    private File customModuleDir;
    @NotNull
    private final Lazy mFixModuleCase$delegate;
    @NotNull
    private static final String TAG = "OfflineTranslate";

    public OfflineTranslate(boolean DBG, int count) {
        this.DBG = DBG;
        this.count = count;
        this.clientMap = new ConcurrentHashMap();
        this.mFixModuleCase$delegate = LazyKt.lazy(() -> OfflineTranslate.mFixModuleCase_delegate$lambda$0(this));
    }

    public /* synthetic */ OfflineTranslate(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(bl, n);
    }

    private final FixModuleCase getMFixModuleCase() {
        Lazy lazy = this.mFixModuleCase$delegate;
        return (FixModuleCase)lazy.getValue();
    }

    @Override
    @WorkerThread
    public void downloadMode(@NotNull ParamDownload paramDownload, @Nullable IDownloadCallback callback) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)paramDownload, (String)"paramDownload");
            try {
                String languageTag = paramDownload.getLanguageTag();
                boolean requireWifi = paramDownload.getRequireWifi();
                boolean requireCharging = paramDownload.getRequireCharging();
                this.downloadModeImpl(languageTag, requireWifi, requireCharging, callback);
            }
            catch (Exception e) {
                e.printStackTrace();
                IDownloadCallback iDownloadCallback = callback;
                if (iDownloadCallback == null) break block3;
                String string = paramDownload.getLanguageTag();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "-1";
                }
                iDownloadCallback.downloadFailed(string, string2);
            }
        }
    }

    @Override
    public void translate(@NotNull Context context, @NotNull ParamTranslateText paramTranslateText, @Nullable ITranslateCallback callback) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)paramTranslateText, (String)"paramTranslateText");
            try {
                File mode;
                String form = paramTranslateText.getFromLanguageCode();
                String to = paramTranslateText.getToLanguageCode();
                if (this.DBG) {
                    Log.e((String)TAG, (String)("translate start, " + form + " ->. " + to));
                }
                if ((mode = TranslateV5Manager.INSTANCE.getMode$fun_translate_release(context, form, to)) == null) {
                    this.translate(paramTranslateText.getText(), form, to, callback);
                } else {
                    this.translateV5(paramTranslateText.getText(), form, to, mode, callback);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.DBG) {
                    Log.e((String)TAG, (String)"translate exception", (Throwable)e);
                }
                ITranslateCallback iTranslateCallback = callback;
                if (iTranslateCallback == null) break block7;
                String string = paramTranslateText.getText();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "-2";
                }
                iTranslateCallback.translateFailed(string, string2);
            }
        }
    }

    @Override
    @NotNull
    public List<String> allLanguageTags() {
        List list = TranslateLanguage.getAllLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLanguages(...)");
        return list;
    }

    @Override
    public void isDownloadedMode(@NotNull ParamModel paramModel, @Nullable IDownloadStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)paramModel, (String)"paramModel");
        String string = TranslateLanguage.fromLanguageTag((String)paramModel.getLanguageTag());
        if (string == null) {
            boolean bl = false;
            String msg = "error languageTag:" + paramModel + ".languageTag";
            Log.e((String)TAG, (String)msg);
            throw new LanguageTagErrorException(msg);
        }
        String languageTag = string;
        TranslateRemoteModel translateRemoteModel = new TranslateRemoteModel.Builder(languageTag).build();
        Intrinsics.checkNotNullExpressionValue((Object)translateRemoteModel, (String)"build(...)");
        TranslateRemoteModel translateMode = translateRemoteModel;
        RemoteModelManager remoteModelManager = RemoteModelManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)remoteModelManager, (String)"getInstance(...)");
        RemoteModelManager modelManager = remoteModelManager;
        modelManager.isModelDownloaded((RemoteModel)translateMode).addOnSuccessListener(arg_0 -> OfflineTranslate.isDownloadedMode$lambda$3(arg_0 -> OfflineTranslate.isDownloadedMode$lambda$2(callback, arg_0), arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.isDownloadedMode$lambda$4(callback, arg_0));
    }

    @Override
    public void destroy() {
        try {
            Map $this$forEach$iv = this.clientMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Translator translator = (Translator)entry.getValue();
                try {
                    translator.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.clientMap.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setCustomModuleDir(@NotNull Context context, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context app = context.getApplicationContext();
        if (!(app instanceof OfflineApplication)) {
            Log.e((String)TAG, (String)"setCustomModuleDir, application is not OfflineApplication");
            return false;
        }
        File file2 = file;
        if (file2 == null) {
            return false;
        }
        File f = file2;
        if (!f.exists() && !f.mkdirs()) {
            Log.e((String)TAG, (String)("setCustomModuleDir, file is not exists:" + f.getAbsolutePath()));
            return false;
        }
        if (!f.isDirectory()) {
            Log.e((String)TAG, (String)("setCustomModuleDir, file is not directory:" + f.getAbsolutePath()));
            return false;
        }
        String moduleDirName = f.getName();
        CharSequence charSequence = moduleDirName;
        if (charSequence == null || charSequence.length() == 0) {
            Log.e((String)TAG, (String)("setCustomModuleDir, moduleDirName is Empty :" + moduleDirName));
            return false;
        }
        this.customModuleDir = f;
        this.setCustomModuleSubDir(moduleDirName);
        Log.i((String)TAG, (String)("setCustomModuleDir success, custom module dir:" + f.getAbsolutePath()));
        return true;
    }

    @Override
    @Nullable
    public File getCustomModuleDir() {
        File file = this.customModuleDir;
        if (file == null) {
            return null;
        }
        File file2 = file;
        Log.i((String)TAG, (String)("getCustomModuleDir success, custom dir:" + file2.getAbsolutePath() + '.'));
        return file2;
    }

    @Override
    @Nullable
    public File getModuleDir(@NotNull Context context, @NotNull String fromCode, @NotNull String toCode) {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fromCode, (String)"fromCode");
        Intrinsics.checkNotNullParameter((Object)toCode, (String)"toCode");
        File customDir = OfflineTranslateHelper.Companion.getInstance().getCustomModuleDir();
        File defaultDir = new File(context.getNoBackupFilesDir(), "com.google.mlkit.translate.models");
        File file2 = customDir;
        if (file2 == null) {
            file2 = defaultDir;
        }
        File noBackupDir = file2;
        String folderPath = noBackupDir.getAbsolutePath();
        if (this.DBG) {
            Log.v((String)TAG, (String)("fromCode:" + fromCode + ", toCode:" + toCode));
            Log.v((String)TAG, (String)("folderPath:" + folderPath));
        }
        if ((file = new File(noBackupDir, fromCode + '_' + toCode)).exists()) {
            if (this.DBG) {
                Log.v((String)TAG, (String)("folderPath:" + file.getAbsolutePath()));
            }
            return file;
        }
        File file3 = new File(noBackupDir, toCode + '_' + fromCode);
        if (file3.exists()) {
            if (this.DBG) {
                Log.v((String)TAG, (String)("folderPath3:" + file3.getAbsolutePath()));
            }
            return file3;
        }
        if (this.DBG) {
            Log.v((String)TAG, (String)"folderPath5:null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCustomModuleSubDir(String customDir) {
        try {
            String string = customDir;
            if (string != null) {
                String it = string;
                boolean bl = false;
                String string2 = ModelFileHelper.zza;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"zza");
                String before = string2;
                Log.i((String)TAG, (String)("Updated zza value: " + before));
                Class<?> clazz = Class.forName("com.google.mlkit.common.sdkinternal.model.ModelFileHelper");
                Field field = clazz.getDeclaredField("zza");
                field.setAccessible(true);
                field.set(null, it);
                Log.e((String)TAG, (String)("Updated zza value: " + field.get(null) + ", zza:" + ModelFileHelper.zza));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void translate(String text, String fromCode, String toCode, ITranslateCallback callback) {
        String string;
        String fixTranslatedEnText = this.getMFixModuleCase().translate(text, fromCode, "en");
        if (fixTranslatedEnText != null) {
            fixTranslatedEnText = this.getMFixModuleCase().translate(fixTranslatedEnText, "en", toCode);
        }
        if ((string = fixTranslatedEnText) != null) {
            String it = string;
            boolean bl = false;
            if (this.DBG) {
                Log.i((String)TAG, (String)("translate success by fix:" + text + " ->:" + it));
            }
            ITranslateCallback iTranslateCallback = callback;
            if (iTranslateCallback != null) {
                iTranslateCallback.translateSuccess(text, it);
            }
            return;
        }
        String key = fromCode + toCode;
        Translator translator = this.clientMap.get(key);
        if (translator == null) {
            TranslatorOptions translatorOptions = new TranslatorOptions.Builder().setSourceLanguage(fromCode).setTargetLanguage(toCode).build();
            Intrinsics.checkNotNullExpressionValue((Object)translatorOptions, (String)"build(...)");
            TranslatorOptions options = translatorOptions;
            translator = Translation.getClient((TranslatorOptions)options);
            this.ensureMapSizeLimit(this.clientMap, Math.max(this.count - 1, 0));
            ((Map)this.clientMap).put(key, translator);
        }
        if (this.DBG) {
            Log.i((String)TAG, (String)("offline translate " + fromCode + " -> " + toCode + ", txt:" + text));
        }
        translator.translate(text).addOnSuccessListener(arg_0 -> OfflineTranslate.translate$lambda$9(arg_0 -> OfflineTranslate.translate$lambda$8(this, text, callback, arg_0), arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.translate$lambda$10(this, callback, text, arg_0));
    }

    static /* synthetic */ void translate$default(OfflineTranslate offlineTranslate, String string, String string2, String string3, ITranslateCallback iTranslateCallback, int n, Object object) {
        if ((n & 8) != 0) {
            iTranslateCallback = null;
        }
        offlineTranslate.translate(string, string2, string3, iTranslateCallback);
    }

    private final void translateV5(String text, String from, String to, File mode, ITranslateCallback cb) {
        block18: {
            block17: {
                if (this.DBG) {
                    Log.d((String)TAG, (String)("translateV5, " + from + " -> " + to + ", text:" + text));
                }
                if (((CharSequence)text).length() == 0) break block17;
                String string = from.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String string2 = to.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string, (Object)string2)) break block18;
            }
            ITranslateCallback iTranslateCallback = cb;
            if (iTranslateCallback != null) {
                iTranslateCallback.translateSuccess(text, text);
            }
            return;
        }
        File file = mode;
        if (!(file != null ? file.exists() : false)) {
            if (this.DBG) {
                File file2 = mode;
                Log.e((String)TAG, (String)("translate failed:mode not exits:" + (file2 != null ? file2.getAbsolutePath() : null)));
            }
            ITranslateCallback iTranslateCallback = cb;
            if (iTranslateCallback != null) {
                iTranslateCallback.translateFailed(text, "translate failed:mode not exits");
            }
            return;
        }
        if (TranslateV5Manager.INSTANCE.getV5$fun_translate_release() == null) {
            TranslateV5Manager.INSTANCE.createV5$fun_translate_release(mode);
        }
        TranslateV5 translateV5 = TranslateV5Manager.INSTANCE.getV5$fun_translate_release();
        String result = translateV5 != null ? translateV5.translate(text, from, to, 1) : null;
        CharSequence charSequence = result;
        if (charSequence == null || charSequence.length() == 0) {
            if (this.DBG) {
                Log.e((String)TAG, (String)("translate failed: result is " + result));
            }
            ITranslateCallback iTranslateCallback = cb;
            if (iTranslateCallback != null) {
                iTranslateCallback.translateFailed(text, "translate failed: result is " + result);
            }
        } else {
            if (this.DBG) {
                Log.i((String)TAG, (String)("translate success: result is " + result));
            }
            ITranslateCallback iTranslateCallback = cb;
            if (iTranslateCallback != null) {
                iTranslateCallback.translateSuccess(text, result);
            }
            if (this.DBG) {
                Log.i((String)TAG, (String)"translate done.");
            }
        }
    }

    private final void downloadModeImpl(String languageTag, boolean requireWifi, boolean requireCharging, IDownloadCallback callback) {
        Log.v((String)TAG, (String)("start download offline translate mode: " + languageTag + ", requireWifi:" + requireWifi + ", requireCharging:" + requireCharging));
        String string = TranslateLanguage.fromLanguageTag((String)languageTag);
        if (string == null) {
            boolean bl = false;
            String msg = "error languageTag:" + languageTag;
            Log.e((String)TAG, (String)msg);
            throw new LanguageTagErrorException(msg);
        }
        String translateLangTag = string;
        TranslateRemoteModel translateRemoteModel = new TranslateRemoteModel.Builder(translateLangTag).build();
        Intrinsics.checkNotNullExpressionValue((Object)translateRemoteModel, (String)"build(...)");
        TranslateRemoteModel translateMode = translateRemoteModel;
        DownloadConditions.Builder builder = new DownloadConditions.Builder();
        if (requireWifi) {
            builder.requireWifi();
        }
        if (requireCharging && Build.VERSION.SDK_INT >= 24) {
            builder.requireCharging();
        }
        DownloadConditions downloadConditions = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)downloadConditions, (String)"build(...)");
        DownloadConditions conditions = downloadConditions;
        RemoteModelManager.getInstance().download((RemoteModel)translateMode, conditions).addOnSuccessListener(arg_0 -> OfflineTranslate.downloadModeImpl$lambda$13(arg_0 -> OfflineTranslate.downloadModeImpl$lambda$12(callback, languageTag, arg_0), arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.downloadModeImpl$lambda$14(callback, languageTag, arg_0));
    }

    private final void ensureMapSizeLimit(ConcurrentHashMap<String, Translator> clientMap, int maxSize) {
        if (clientMap.size() > maxSize) {
            Iterator<Map.Entry<String, Translator>> iterator = clientMap.entrySet().iterator();
            while (clientMap.size() > maxSize && iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                try {
                    Map.Entry<String, Translator> entry;
                    entry.getValue().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                iterator.remove();
            }
        }
    }

    private static final FixModuleCase mFixModuleCase_delegate$lambda$0(OfflineTranslate this$0) {
        return new FixModuleCase(this$0.DBG);
    }

    private static final Unit isDownloadedMode$lambda$2(IDownloadStatusCallback $callback, Boolean isDownloaded) {
        block0: {
            IDownloadStatusCallback iDownloadStatusCallback = $callback;
            if (iDownloadStatusCallback == null) break block0;
            Intrinsics.checkNotNull((Object)isDownloaded);
            iDownloadStatusCallback.onSuccess(isDownloaded);
        }
        return Unit.INSTANCE;
    }

    private static final void isDownloadedMode$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void isDownloadedMode$lambda$4(IDownloadStatusCallback $callback, Exception e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IDownloadStatusCallback iDownloadStatusCallback = $callback;
            if (iDownloadStatusCallback == null) break block0;
            iDownloadStatusCallback.onFailure(e);
        }
    }

    private static final Unit translate$lambda$8(OfflineTranslate this$0, String $text, ITranslateCallback $callback, String translatedText) {
        block1: {
            if (this$0.DBG) {
                Log.i((String)TAG, (String)("offline translate success:" + $text + " ->:" + translatedText));
            }
            ITranslateCallback iTranslateCallback = $callback;
            if (iTranslateCallback == null) break block1;
            Intrinsics.checkNotNull((Object)translatedText);
            iTranslateCallback.translateSuccess($text, translatedText);
        }
        return Unit.INSTANCE;
    }

    private static final void translate$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void translate$lambda$10(OfflineTranslate this$0, ITranslateCallback $callback, String $text, Exception e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.printStackTrace();
            if (this$0.DBG) {
                Log.e((String)TAG, (String)"offline translate failed.", (Throwable)e);
            }
            ITranslateCallback iTranslateCallback = $callback;
            if (iTranslateCallback == null) break block1;
            iTranslateCallback.translateFailed($text, String.valueOf(e.getMessage()));
        }
    }

    private static final Unit downloadModeImpl$lambda$12(IDownloadCallback $callback, String $languageTag, Void it) {
        IDownloadCallback iDownloadCallback = $callback;
        if (iDownloadCallback != null) {
            iDownloadCallback.downloadSuccess($languageTag);
        }
        Log.i((String)TAG, (String)($languageTag + " download success"));
        return Unit.INSTANCE;
    }

    private static final void downloadModeImpl$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void downloadModeImpl$lambda$14(IDownloadCallback $callback, String $languageTag, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IDownloadCallback iDownloadCallback = $callback;
        if (iDownloadCallback != null) {
            iDownloadCallback.downloadFailed($languageTag, String.valueOf(it.getMessage()));
        }
        Log.e((String)TAG, (String)($languageTag + " download failed:" + it.getMessage()));
    }

    public OfflineTranslate() {
        this(false, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/translate/offline/OfflineTranslate$Companion;", "", "<init>", "()V", "TAG", "", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

