/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate.offline.cases;

import android.util.Log;
import com.hiservice.translate.OfflineTranslateHelper;
import com.hiservice.translate.offline.cases.TranslationItem;
import com.hiservice.translate.offline.cases.Translations;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hiservice/translate/offline/cases/FixModuleCase;", "", "dbg", "", "<init>", "(Z)V", "translate", "", "text", "fromCode", "toCode", "parseJsonManually", "Lcom/hiservice/translate/offline/cases/Translations;", "jsonString", "Companion", "fun-translate_release"})
@SourceDebugExtension(value={"SMAP\nFixModuleCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixModuleCase.kt\ncom/hiservice/translate/offline/cases/FixModuleCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n295#2,2:96\n*S KotlinDebug\n*F\n+ 1 FixModuleCase.kt\ncom/hiservice/translate/offline/cases/FixModuleCase\n*L\n43#1:96,2\n*E\n"})
public final class FixModuleCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean dbg;
    @NotNull
    private static final String KEY_DATA_JSON = ".json";
    @NotNull
    private static final String TAG = "FixModuleCase";

    public FixModuleCase(boolean dbg) {
        this.dbg = dbg;
    }

    public /* synthetic */ FixModuleCase(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String translate(@NotNull String text, @NotNull String fromCode, @NotNull String toCode) {
        Object v2;
        block22: {
            Object inputStream;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)fromCode, (String)"fromCode");
            Intrinsics.checkNotNullParameter((Object)toCode, (String)"toCode");
            if (Intrinsics.areEqual((Object)fromCode, (Object)toCode)) {
                return text;
            }
            File file = OfflineTranslateHelper.Companion.getInstance().getModuleDir(fromCode, toCode);
            if (file == null) {
                return null;
            }
            File moduleDir = file;
            File dataJsonFile = new File(moduleDir, fromCode + '_' + toCode + KEY_DATA_JSON);
            if (this.dbg) {
                Log.v((String)TAG, (String)("translate, dataJsonFile:" + dataJsonFile.getAbsolutePath()));
            }
            if (!dataJsonFile.exists()) {
                if (this.dbg) {
                    Log.e((String)TAG, (String)("translate, dataJsonFile:" + dataJsonFile.getAbsolutePath() + ", not exists."));
                }
                return null;
            }
            Closeable closeable = new FileInputStream(dataJsonFile);
            Throwable throwable = null;
            try {
                Object reader;
                inputStream = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader((InputStream)inputStream);
                Throwable throwable2 = null;
                try {
                    reader = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    reader = TextStreamsKt.readText((Reader)((Reader)reader));
                }
                catch (Throwable bl2) {
                    throwable2 = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                inputStream = reader;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object jsonString = inputStream;
            Translations translations = this.parseJsonManually((String)jsonString);
            if (translations == null) {
                return null;
            }
            Translations translations2 = translations;
            Iterable $this$firstOrNull$iv = translations2.getTms();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TranslationItem it = (TranslationItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSrc(), (Object)text)) continue;
                v2 = element$iv;
                break block22;
            }
            v2 = null;
        }
        TranslationItem first = v2;
        if (first == null) {
            if (this.dbg) {
                Log.e((String)TAG, (String)"translate, translations.tms not ket.");
            }
            return null;
        }
        if (this.dbg) {
            Log.i((String)TAG, (String)("translate, return:" + first.getTgt()));
        }
        return first.getTgt();
    }

    private final Translations parseJsonManually(String jsonString) {
        Translations translations;
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            JSONArray jSONArray = jsonObject.getJSONArray("tms");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"getJSONArray(...)");
            JSONArray tmsArray = jSONArray;
            List translationItems = new ArrayList();
            int n = tmsArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject itemObject = tmsArray.getJSONObject(i);
                String src = itemObject.getString("src");
                String tgt = itemObject.getString("tgt");
                Intrinsics.checkNotNull((Object)src);
                Intrinsics.checkNotNull((Object)tgt);
                translationItems.add(new TranslationItem(src, tgt));
            }
            translations = new Translations(translationItems);
        }
        catch (Exception e) {
            e.printStackTrace();
            translations = null;
        }
        return translations;
    }

    public FixModuleCase() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/hiservice/translate/offline/cases/FixModuleCase$Companion;", "", "<init>", "()V", "KEY_DATA_JSON", "", "TAG", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

