/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate_v5;

import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtSession;
import com.hiservice.translate_v5.CustomSPMEncoder;
import com.hiservice.translate_v5.RunOnnxReRAMWithBeam;
import com.hiservice.translate_v5.SessionDelegate;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J,\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019`\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J*\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0012\u0010\u000bR\u001b\u0010\u0014\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0015\u0010\u000bR*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/hiservice/translate_v5/TranslateV5;", "Lcom/hiservice/translate_v5/RunOnnxReRAMWithBeam;", "mode", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "env", "Lai/onnxruntime/OrtEnvironment;", "encoder", "Lai/onnxruntime/OrtSession;", "getEncoder", "()Lai/onnxruntime/OrtSession;", "encoder$delegate", "Lcom/hiservice/translate_v5/SessionDelegate;", "decoder", "getDecoder", "decoder$delegate", "cacheInit", "getCacheInit", "cacheInit$delegate", "embedAndLmHead", "getEmbedAndLmHead", "embedAndLmHead$delegate", "languages", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "spme", "Lcom/hiservice/translate_v5/CustomSPMEncoder;", "create", "", "", "parseLanguagesFromFile", "translate", "text", "from", "to", "numBeam", "", "Companion", "fun-translate_release"})
public final class TranslateV5
extends RunOnnxReRAMWithBeam {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final OrtEnvironment env;
    @NotNull
    private final SessionDelegate encoder$delegate;
    @NotNull
    private final SessionDelegate decoder$delegate;
    @NotNull
    private final SessionDelegate cacheInit$delegate;
    @NotNull
    private final SessionDelegate embedAndLmHead$delegate;
    @NotNull
    private final LinkedHashMap<String, String> languages;
    @NotNull
    private final CustomSPMEncoder spme;
    @NotNull
    private static final String TAG = "TranslateV5";

    private TranslateV5(File mode) {
        OrtEnvironment ortEnvironment = OrtEnvironment.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)ortEnvironment, (String)"getEnvironment(...)");
        this.env = ortEnvironment;
        this.encoder$delegate = new SessionDelegate(this.env, mode, "encoder.onnx");
        this.decoder$delegate = new SessionDelegate(this.env, mode, "decoder.onnx");
        this.cacheInit$delegate = new SessionDelegate(this.env, mode, "cache_initializer.onnx");
        this.embedAndLmHead$delegate = new SessionDelegate(this.env, mode, "embed_and_lm_head.onnx");
        this.languages = this.parseLanguagesFromFile(mode);
        Collection<String> collection = this.languages.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        CustomSPMEncoder customSPMEncoder = CustomSPMEncoder.create(mode, CollectionsKt.toList((Iterable)collection));
        Intrinsics.checkNotNullExpressionValue((Object)customSPMEncoder, (String)"create(...)");
        this.spme = customSPMEncoder;
        this.load();
    }

    private final OrtSession getEncoder() {
        return this.encoder$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final OrtSession getDecoder() {
        return this.decoder$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final OrtSession getCacheInit() {
        return this.cacheInit$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final OrtSession getEmbedAndLmHead() {
        return this.embedAndLmHead$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Override
    @NotNull
    public List<Object> create() {
        Object[] objectArray = new Object[]{this.env, this.getEncoder(), this.getDecoder(), this.getCacheInit(), this.getEmbedAndLmHead(), this.spme};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final LinkedHashMap<String, String> parseLanguagesFromFile(File mode) {
        File file = new File(mode.getAbsolutePath(), "config.json");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String configJson = FilesKt.readText$default((File)file, null, (int)1, null);
        JSONObject jsonObject = new JSONObject(configJson);
        JSONArray languagesArray = jsonObject.getJSONArray("supported_languages");
        int n = languagesArray.length();
        for (int i = 0; i < n; ++i) {
            String key;
            JSONArray languagePair = languagesArray.getJSONArray(i);
            String string = languagePair.getString(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            String value = languagePair.getString(1);
            ((Map)map).put(key, value);
        }
        return map;
    }

    @Override
    @Nullable
    public String translate(@NotNull String text, @NotNull String from, @NotNull String to, int numBeam) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        String string = from.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = to.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return super.translate(text, this.languages.get(string), this.languages.get(string2), numBeam);
    }

    @JvmStatic
    @NotNull
    public static final TranslateV5 newInstance(@NotNull File mode) {
        return Companion.newInstance(mode);
    }

    public /* synthetic */ TranslateV5(File mode, DefaultConstructorMarker $constructor_marker) {
        this(mode);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TranslateV5.class, "encoder", "getEncoder()Lai/onnxruntime/OrtSession;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TranslateV5.class, "decoder", "getDecoder()Lai/onnxruntime/OrtSession;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TranslateV5.class, "cacheInit", "getCacheInit()Lai/onnxruntime/OrtSession;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TranslateV5.class, "embedAndLmHead", "getEmbedAndLmHead()Lai/onnxruntime/OrtSession;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hiservice/translate_v5/TranslateV5$Companion;", "", "<init>", "()V", "TAG", "", "newInstance", "Lcom/hiservice/translate_v5/TranslateV5;", "mode", "Ljava/io/File;", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TranslateV5 newInstance(@NotNull File mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            return new TranslateV5(mode, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

