/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import com.iabtcf.BitReader;
import com.iabtcf.FieldDefs;
import com.iabtcf.decoder.TCString;
import com.iabtcf.decoder.TCStringV1;
import com.iabtcf.decoder.TCStringV2;
import com.iabtcf.exceptions.ByteParseException;
import com.iabtcf.exceptions.UnsupportedVersionException;
import java.util.Base64;

class TCStringDecoder {
    TCStringDecoder() {
    }

    static BitReader vectorFromString(String base64UrlEncodedString) {
        byte[] bytes = Base64.getUrlDecoder().decode(base64UrlEncodedString);
        return new BitReader(bytes);
    }

    public static TCString decode(String consentString) throws IllegalArgumentException, ByteParseException, UnsupportedVersionException {
        String[] split = consentString.split("\\.");
        String base64UrlEncodedString = split[0];
        BitReader bitVector = TCStringDecoder.vectorFromString(base64UrlEncodedString);
        byte version = bitVector.readBits6(FieldDefs.CORE_VERSION);
        switch (version) {
            case 1: {
                return TCStringV1.fromBitVector(bitVector);
            }
            case 2: {
                if (split.length > 1) {
                    BitReader[] remaining = new BitReader[split.length - 1];
                    for (int i = 1; i < split.length; ++i) {
                        remaining[i - 1] = TCStringDecoder.vectorFromString(split[i]);
                    }
                    return TCStringV2.fromBitVector(bitVector, remaining);
                }
                return TCStringV2.fromBitVector(bitVector, new BitReader[0]);
            }
        }
        throw new UnsupportedVersionException("Version " + version + "is unsupported yet");
    }
}

