/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.utils;

import com.iabtcf.utils.IntIterable;
import com.iabtcf.utils.IntIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;

public class BitSetIntIterable
extends IntIterable {
    private final BitSet bs;
    public static final BitSetIntIterable EMPTY = new BitSetIntIterable(new BitSet());

    public static BitSetIntIterable from(BitSet bs) {
        return new BitSetIntIterable((BitSet)bs.clone());
    }

    public static BitSetIntIterable from(IntIterable ii) {
        if (ii instanceof BitSetIntIterable) {
            return ((BitSetIntIterable)ii).clone();
        }
        BitSet bs = new BitSet();
        IntIterator i = ii.intIterator();
        while (i.hasNext()) {
            bs.set(i.nextInt());
        }
        return new BitSetIntIterable(bs);
    }

    public static BitSetIntIterable from(int ... values) {
        BitSet bs = new BitSet();
        for (int i = 0; i < values.length; ++i) {
            bs.set(values[i]);
        }
        return new BitSetIntIterable(bs);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(BitSetIntIterable prototype) {
        return new Builder(prototype);
    }

    public static Builder newBuilder(BitSet bs) {
        return new Builder(new BitSetIntIterable(bs));
    }

    private BitSetIntIterable(BitSet bs) {
        this.bs = bs;
    }

    public BitSet toBitSet() {
        return (BitSet)this.bs.clone();
    }

    public BitSetIntIterable clone() {
        return new BitSetIntIterable((BitSet)this.bs.clone());
    }

    @Override
    public boolean contains(int value) {
        try {
            return this.bs.get(value);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public IntIterator intIterator() {
        return new IntIterator(){
            int currentIndex = this.start();

            public int start() {
                if (BitSetIntIterable.this.bs.isEmpty()) {
                    return -1;
                }
                return BitSetIntIterable.this.bs.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex != -1;
            }

            @Override
            public Integer next() {
                return this.nextInt();
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int next = this.currentIndex;
                this.currentIndex = BitSetIntIterable.this.bs.nextSetBit(this.currentIndex + 1);
                return next;
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bs == null ? 0 : this.bs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSetIntIterable other = (BitSetIntIterable)obj;
        if (this.bs == null) {
            return other.bs == null;
        }
        return this.bs.equals(other.bs);
    }

    public String toString() {
        return this.bs.toString();
    }

    public static Builder newBuilder(IntIterable purposesConsent) {
        return new Builder(BitSetIntIterable.from(purposesConsent));
    }

    public static class Builder {
        private final BitSet bs;

        private Builder() {
            this(new BitSet());
        }

        private Builder(BitSet bs) {
            this.bs = bs;
        }

        private Builder(BitSetIntIterable prototype) {
            this(prototype.clone().bs);
        }

        public Builder add(int value) {
            this.bs.set(value);
            return this;
        }

        public Builder add(BitSetIntIterable value) {
            this.bs.or(value.bs);
            return this;
        }

        public Builder add(IntIterable value) {
            IntIterator ii = value.intIterator();
            while (ii.hasNext()) {
                this.bs.set(ii.nextInt());
            }
            return this;
        }

        public Builder add(Builder value) {
            this.bs.or(value.bs);
            return this;
        }

        public Builder clear() {
            this.bs.clear();
            return this;
        }

        public int max() {
            if (this.bs.isEmpty()) {
                return 0;
            }
            return this.bs.length() - 1;
        }

        public BitSetIntIterable build() {
            return new BitSetIntIterable((BitSet)this.bs.clone());
        }
    }
}

