/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.WriteOptions;
import com.influxdb.client.internal.AbstractWriteClient;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jetbrains.annotations.Nullable;
import retrofit2.HttpException;

final class RetryAttempt {
    private static final Integer ABLE_TO_RETRY_ERROR = 429;
    private static final Logger LOG = Logger.getLogger(AbstractWriteClient.class.getName());
    private final Throwable throwable;
    private final int count;
    private final WriteOptions writeOptions;

    RetryAttempt(Throwable throwable, int count, WriteOptions writeOptions) {
        this.throwable = throwable;
        this.count = count;
        this.writeOptions = writeOptions;
    }

    boolean isRetry() {
        if (this.count > this.writeOptions.getMaxRetries()) {
            LOG.log(Level.WARNING, "Max write retries exceeded.", this.throwable);
            return false;
        }
        if (this.throwable instanceof HttpException) {
            HttpException he = (HttpException)this.throwable;
            return he.code() >= ABLE_TO_RETRY_ERROR;
        }
        if (this.throwable instanceof IOException) {
            if (this.throwable instanceof ProtocolException) {
                return false;
            }
            if (this.throwable instanceof InterruptedIOException) {
                return this.throwable instanceof SocketTimeoutException;
            }
            if (this.throwable instanceof SSLHandshakeException && this.throwable.getCause() instanceof CertificateException) {
                return false;
            }
            return !(this.throwable instanceof SSLPeerUnverifiedException);
        }
        return false;
    }

    long getRetryInterval() {
        long retryInterval;
        String retryAfter = this.getRetryAfter();
        if (retryAfter != null) {
            retryInterval = TimeUnit.MILLISECONDS.convert(Integer.parseInt(retryAfter), TimeUnit.SECONDS);
        } else {
            retryInterval = (long)this.writeOptions.getRetryInterval() * (long)Math.pow(this.writeOptions.getExponentialBase(), this.count - 1);
            retryInterval = Math.min(retryInterval, (long)this.writeOptions.getMaxRetryDelay());
            String msg = "The InfluxDB does not specify \"Retry-After\". Use the default retryInterval: {0}";
            LOG.log(Level.FINEST, msg, retryInterval);
        }
        return retryInterval += (long)RetryAttempt.jitterDelay(this.writeOptions.getJitterInterval());
    }

    Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    private String getRetryAfter() {
        if (this.throwable instanceof HttpException) {
            return ((HttpException)this.throwable).response().headers().get("Retry-After");
        }
        return null;
    }

    static int jitterDelay(int jitterInterval) {
        return (int)(Math.random() * (double)jitterInterval);
    }
}

