/*
 * Decompiled with CFR 0.152.
 */
package com.inthecheesefactory.lib.fblike.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.share.widget.LikeView;
import com.inthecheesefactory.lib.fblike.R;
import com.inthecheesefactory.lib.fblike.bus.BusEventCallbackManagerActivityResult;
import com.inthecheesefactory.lib.fblike.bus.BusEventLoginStatusUpdated;
import com.inthecheesefactory.lib.fblike.bus.FBLikeBus;
import com.squareup.otto.Subscribe;
import java.util.Arrays;

public class FBLikeView
extends FrameLayout {
    LinearLayout btnLoginToLike;
    LikeView likeView;
    TextView tvLogin;
    private static CallbackManager callbackManager;

    public FBLikeView(Context context) {
        super(context);
        this.initInflate();
        this.initInstances();
    }

    public FBLikeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initInflate();
        this.initInstances();
        this.initWithAttrs(attrs, 0, 0);
    }

    public FBLikeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initInflate();
        this.initInstances();
        this.initWithAttrs(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public FBLikeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initInflate();
        this.initInstances();
        this.initWithAttrs(attrs, defStyleAttr, defStyleRes);
    }

    private void initInflate() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.login_to_like, (ViewGroup)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWithAttrs(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int[] set = new int[]{16843087};
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, set, defStyleAttr, defStyleRes);
        try {
            if (a.hasValue(0)) {
                String text = a.getString(0);
                this.setText(text);
            }
        }
        finally {
            a.recycle();
        }
    }

    private void initInstances() {
        this.btnLoginToLike = (LinearLayout)this.findViewById(R.id.btnLoginToLike);
        this.tvLogin = (TextView)this.findViewById(R.id.tvLogin);
        this.likeView = (LikeView)this.findViewById(R.id.likeView);
        this.likeView.setLikeViewStyle(LikeView.Style.STANDARD);
        this.likeView.setAuxiliaryViewPosition(LikeView.AuxiliaryViewPosition.INLINE);
        this.btnLoginToLike.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FBLikeView.this.getContext() != null && FBLikeView.this.getContext() instanceof Activity) {
                    LoginManager.getInstance().logInWithReadPermissions((Activity)FBLikeView.this.getContext(), Arrays.asList("public_profile"));
                }
            }
        });
        FBLikeView.initializeCallbackManager();
        this.refreshButtonsState();
    }

    public LikeView getLikeView() {
        return this.likeView;
    }

    public void setText(@Nullable CharSequence text) {
        this.tvLogin.setText(text);
    }

    public void setText(@Nullable CharSequence text, @Nullable TextView.BufferType type) {
        this.tvLogin.setText(text, type);
    }

    public void setText(char[] text, int start, int len) {
        this.tvLogin.setText(text, start, len);
    }

    public void setText(int resId) {
        this.tvLogin.setText(resId);
    }

    public void setText(int resId, @Nullable TextView.BufferType type) {
        this.tvLogin.setText(resId, type);
    }

    public CharSequence getText() {
        return this.tvLogin.getText();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.refreshButtonsState();
        FBLikeBus.getInstance().register((Object)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        FBLikeBus.getInstance().unregister((Object)this);
    }

    @Subscribe
    public void busReceived(BusEventLoginStatusUpdated event) {
        this.refreshButtonsState();
    }

    @Subscribe
    public void busReceived(BusEventCallbackManagerActivityResult event) {
        FBLikeView._onActivityResult(event.getRequestCode(), event.getResultCode(), event.getData());
    }

    private void refreshButtonsState() {
        if (!FBLikeView.isLoggedIn()) {
            this.btnLoginToLike.setVisibility(0);
            this.likeView.setVisibility(8);
        } else {
            this.btnLoginToLike.setVisibility(8);
            this.likeView.setVisibility(0);
        }
    }

    private static void initializeCallbackManager() {
        if (callbackManager == null) {
            callbackManager = CallbackManager.Factory.create();
            LoginManager.getInstance().registerCallback(callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

                public void onSuccess(LoginResult loginResult) {
                    FBLikeView.loginStatusChanged();
                }

                public void onCancel() {
                }

                public void onError(FacebookException e) {
                }
            });
        }
    }

    public static void loginStatusChanged() {
        FBLikeBus.getInstance().post(new BusEventLoginStatusUpdated());
    }

    public static void onActivityResult(int requestCode, int resultCode, Intent data) {
        FBLikeBus.getInstance().post(new BusEventCallbackManagerActivityResult(requestCode, resultCode, data));
    }

    public static void _onActivityResult(int requestCode, int resultCode, Intent data) {
        if (callbackManager != null) {
            callbackManager.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static boolean isLoggedIn() {
        return AccessToken.getCurrentAccessToken() != null;
    }

    public static void logout() {
        LoginManager.getInstance().logOut();
        FBLikeView.loginStatusChanged();
    }
}

