/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import com.android.dx.mockito.inline.InvocationHandlerAdapter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MockMethodAdvice {
    private final Map<Object, InvocationHandlerAdapter> interceptors;
    private final Pattern methodPattern = Pattern.compile("(.*)#(.*)\\((.*)\\)");
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();

    MockMethodAdvice(Map<Object, InvocationHandlerAdapter> interceptors) {
        this.interceptors = interceptors;
    }

    private static Object tryInvoke(Method origin, Object instance, Object[] arguments) throws Throwable {
        try {
            return origin.invoke(instance, arguments);
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
    }

    private static Throwable hideRecursiveCall(Throwable throwable, int current, Class<?> targetType) {
        try {
            StackTraceElement next;
            StackTraceElement[] stack = throwable.getStackTrace();
            int skip = 0;
            while (!(next = stack[stack.length - current - ++skip]).getClassName().equals(targetType.getName())) {
            }
            int top = stack.length - current - skip;
            StackTraceElement[] cleared = new StackTraceElement[stack.length - skip];
            System.arraycopy(stack, 0, cleared, 0, top);
            System.arraycopy(stack, top + skip, cleared, top, current);
            throwable.setStackTrace(cleared);
            return throwable;
        }
        catch (RuntimeException ignored) {
            return throwable;
        }
    }

    public Method getOrigin(Object instance, String methodWithTypeAndSignature) throws Throwable {
        if (!this.isMocked(instance)) {
            return null;
        }
        Matcher methodComponents = this.methodPattern.matcher(methodWithTypeAndSignature);
        boolean wasFound = methodComponents.find();
        if (!wasFound) {
            throw new IllegalArgumentException();
        }
        String[] argTypeNames = methodComponents.group(3).split(",");
        ArrayList argTypes = new ArrayList(argTypeNames.length);
        block36: for (String argTypeName : argTypeNames) {
            if (argTypeName.equals("")) continue;
            switch (argTypeName) {
                case "byte": {
                    argTypes.add(Byte.TYPE);
                    continue block36;
                }
                case "short": {
                    argTypes.add(Short.TYPE);
                    continue block36;
                }
                case "int": {
                    argTypes.add(Integer.TYPE);
                    continue block36;
                }
                case "long": {
                    argTypes.add(Long.TYPE);
                    continue block36;
                }
                case "char": {
                    argTypes.add(Character.TYPE);
                    continue block36;
                }
                case "float": {
                    argTypes.add(Float.TYPE);
                    continue block36;
                }
                case "double": {
                    argTypes.add(Double.TYPE);
                    continue block36;
                }
                case "boolean": {
                    argTypes.add(Boolean.TYPE);
                    continue block36;
                }
                case "byte[]": {
                    argTypes.add(byte[].class);
                    continue block36;
                }
                case "short[]": {
                    argTypes.add(short[].class);
                    continue block36;
                }
                case "int[]": {
                    argTypes.add(int[].class);
                    continue block36;
                }
                case "long[]": {
                    argTypes.add(long[].class);
                    continue block36;
                }
                case "char[]": {
                    argTypes.add(char[].class);
                    continue block36;
                }
                case "float[]": {
                    argTypes.add(float[].class);
                    continue block36;
                }
                case "double[]": {
                    argTypes.add(double[].class);
                    continue block36;
                }
                case "boolean[]": {
                    argTypes.add(boolean[].class);
                    continue block36;
                }
                default: {
                    if (argTypeName.endsWith("[]")) {
                        argTypes.add(Class.forName("[L" + argTypeName.substring(0, argTypeName.length() - 2) + ";"));
                        continue block36;
                    }
                    argTypes.add(Class.forName(argTypeName));
                }
            }
        }
        Method origin = Class.forName(methodComponents.group(1)).getDeclaredMethod(methodComponents.group(2), argTypes.toArray(new Class[0]));
        if (this.isOverridden(instance, origin)) {
            return null;
        }
        return origin;
    }

    public Callable<?> handle(Object instance, Method origin, Object[] arguments) throws Throwable {
        InvocationHandlerAdapter interceptor = this.interceptors.get(instance);
        if (interceptor == null) {
            return null;
        }
        return new ReturnValueWrapper(interceptor.interceptEntryHook(instance, origin, arguments, new SuperMethodCall(this.selfCallInfo, origin, instance, arguments)));
    }

    public boolean isMock(Object instance) {
        return this.interceptors.containsKey(instance);
    }

    public boolean isMocked(Object instance) {
        return this.selfCallInfo.shouldMockMethod(instance) && this.isMock(instance);
    }

    public boolean isOverridden(Object instance, Method origin) {
        Class<?> currentType = instance.getClass();
        while (true) {
            try {
                return !origin.equals(currentType.getDeclaredMethod(origin.getName(), origin.getParameterTypes()));
            }
            catch (NoSuchMethodException ignored) {
                if ((currentType = currentType.getSuperclass()) != null) continue;
                return true;
            }
            break;
        }
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        boolean shouldMockMethod(Object value) {
            Object current = this.get();
            if (current == value) {
                this.set(null);
                return false;
            }
            return true;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class SuperMethodCall
    implements InvocationHandlerAdapter.SuperMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final WeakReference<Object> instance;
        private final Object[] arguments;

        private SuperMethodCall(SelfCallInfo selfCallInfo, Method origin, Object instance, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instance = new WeakReference<Object>(instance);
            this.arguments = arguments;
        }

        @Override
        public Object invoke() throws Throwable {
            if (!Modifier.isPublic(this.origin.getDeclaringClass().getModifiers() & this.origin.getModifiers())) {
                this.origin.setAccessible(true);
            }
            this.selfCallInfo.set(this.instance.get());
            return MockMethodAdvice.tryInvoke(this.origin, this.instance.get(), this.arguments);
        }
    }
}

