/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.mikepenz.fastadapter.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class RecyclerViewCacheUtil<Item extends IItem> {
    private int mCacheSize = 2;

    public RecyclerViewCacheUtil withCacheSize(int cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    public void apply(RecyclerView recyclerView, Iterable<Item> items) {
        if (items != null) {
            HashMap cache = new HashMap();
            for (IItem d : items) {
                if (!cache.containsKey(d.getType())) {
                    cache.put(d.getType(), new Stack());
                }
                if (this.mCacheSize == -1 || ((Stack)cache.get(d.getType())).size() <= this.mCacheSize) {
                    ((Stack)cache.get(d.getType())).push(d.getViewHolder((ViewGroup)recyclerView));
                }
                RecyclerView.RecycledViewPool recyclerViewPool = new RecyclerView.RecycledViewPool();
                for (Map.Entry entry : cache.entrySet()) {
                    recyclerViewPool.setMaxRecycledViews(((Integer)entry.getKey()).intValue(), this.mCacheSize);
                    for (RecyclerView.ViewHolder holder : (Stack)entry.getValue()) {
                        recyclerViewPool.putRecycledView(holder);
                    }
                    ((Stack)entry.getValue()).clear();
                }
                cache.clear();
                recyclerView.setRecycledViewPool(recyclerViewPool);
            }
        }
    }
}

