/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.Utils;

public class IconicsDrawable
extends Drawable {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_PADDING_DP = 1;
    private Context mContext;
    private int mSizeX = -1;
    private int mSizeY = -1;
    private Paint mIconPaint;
    private Paint mContourPaint;
    private Paint mBackgroundPaint = null;
    private int mRoundedCornerRx = -1;
    private int mRoundedCornerRy = -1;
    private Rect mPaddingBounds;
    private RectF mPathBounds;
    private Path mPath;
    private int mIconPadding;
    private int mContourWidth;
    private int mIconOffsetX = 0;
    private int mIconOffsetY = 0;
    private int mAlpha = 255;
    private boolean mDrawContour;
    private IIcon mIcon;
    private String mPlainIcon;

    public IconicsDrawable(Context context) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(Character.valueOf(' '));
    }

    public IconicsDrawable(Context context, Character icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(icon);
    }

    public IconicsDrawable(Context context, String icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        try {
            ITypeface font = Iconics.findFont(context, icon.substring(0, 3));
            icon = icon.replace("-", "_");
            this.icon(font.getIcon(icon));
        }
        catch (Exception ex) {
            Log.e((String)Iconics.TAG, (String)("Wrong icon name: " + icon));
        }
    }

    public IconicsDrawable(Context context, IIcon icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(icon);
    }

    public IconicsDrawable(Context context, ITypeface typeface, IIcon icon) {
        this.mContext = context.getApplicationContext();
        this.prepare();
        this.icon(typeface, icon);
    }

    private void prepare() {
        this.mIconPaint = new Paint(1);
        this.mBackgroundPaint = new Paint(1);
        this.mContourPaint = new Paint(1);
        this.mContourPaint.setStyle(Paint.Style.STROKE);
        this.mPath = new Path();
        this.mPathBounds = new RectF();
        this.mPaddingBounds = new Rect();
    }

    public IconicsDrawable icon(Character icon) {
        return this.icon(icon.toString());
    }

    public IconicsDrawable icon(String icon) {
        this.mPlainIcon = icon;
        this.mIcon = null;
        this.mIconPaint.setTypeface(Typeface.DEFAULT);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable icon(IIcon icon) {
        this.mIcon = icon;
        this.mPlainIcon = null;
        ITypeface typeface = icon.getTypeface();
        this.mIconPaint.setTypeface(typeface.getTypeface(this.mContext));
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable icon(ITypeface typeface, IIcon icon) {
        this.mIcon = icon;
        this.mIconPaint.setTypeface(typeface.getTypeface(this.mContext));
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable color(int color) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        this.mIconPaint.setColor(Color.rgb((int)red, (int)green, (int)blue));
        this.setAlpha(Color.alpha((int)color));
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable colorRes(int colorRes) {
        return this.color(this.mContext.getResources().getColor(colorRes));
    }

    public IconicsDrawable iconOffsetXRes(int iconOffsetXRes) {
        return this.iconOffsetXPx(this.mContext.getResources().getDimensionPixelSize(iconOffsetXRes));
    }

    public IconicsDrawable iconOffsetXDp(int iconOffsetXDp) {
        return this.iconOffsetXPx(Utils.convertDpToPx(this.mContext, iconOffsetXDp));
    }

    public IconicsDrawable iconOffsetXPx(int iconOffsetX) {
        this.mIconOffsetX = iconOffsetX;
        return this;
    }

    public IconicsDrawable iconOffsetYRes(int iconOffsetYRes) {
        return this.iconOffsetYPx(this.mContext.getResources().getDimensionPixelSize(iconOffsetYRes));
    }

    public IconicsDrawable iconOffsetYDp(int iconOffsetYDp) {
        return this.iconOffsetYPx(Utils.convertDpToPx(this.mContext, iconOffsetYDp));
    }

    public IconicsDrawable iconOffsetYPx(int iconOffsetY) {
        this.mIconOffsetY = iconOffsetY;
        return this;
    }

    public IconicsDrawable paddingRes(int dimenRes) {
        return this.paddingPx(this.mContext.getResources().getDimensionPixelSize(dimenRes));
    }

    public IconicsDrawable paddingDp(int iconPadding) {
        return this.paddingPx(Utils.convertDpToPx(this.mContext, iconPadding));
    }

    public IconicsDrawable paddingPx(int iconPadding) {
        if (this.mIconPadding != iconPadding) {
            this.mIconPadding = iconPadding;
            if (this.mDrawContour) {
                this.mIconPadding += this.mContourWidth;
            }
            this.invalidateSelf();
        }
        return this;
    }

    @Deprecated
    public IconicsDrawable actionBarSize() {
        return this.sizeDp(24);
    }

    public IconicsDrawable actionBar() {
        this.sizeDp(24);
        this.paddingDp(1);
        return this;
    }

    public IconicsDrawable sizeRes(int dimenRes) {
        return this.sizePx(this.mContext.getResources().getDimensionPixelSize(dimenRes));
    }

    public IconicsDrawable sizeDp(int size) {
        return this.sizePx(Utils.convertDpToPx(this.mContext, size));
    }

    public IconicsDrawable sizePx(int size) {
        this.mSizeX = size;
        this.mSizeY = size;
        this.setBounds(0, 0, size, size);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable sizeResX(int dimenResX) {
        return this.sizePxX(this.mContext.getResources().getDimensionPixelSize(dimenResX));
    }

    public IconicsDrawable sizeDpX(int sizeX) {
        return this.sizePxX(Utils.convertDpToPx(this.mContext, sizeX));
    }

    public IconicsDrawable sizePxX(int sizeX) {
        this.mSizeX = sizeX;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable sizeResY(int dimenResY) {
        return this.sizePxY(this.mContext.getResources().getDimensionPixelSize(dimenResY));
    }

    public IconicsDrawable sizeDpY(int sizeY) {
        return this.sizePxY(Utils.convertDpToPx(this.mContext, sizeY));
    }

    public IconicsDrawable sizePxY(int sizeY) {
        this.mSizeY = sizeY;
        this.setBounds(0, 0, this.mSizeX, this.mSizeY);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable contourColor(int contourColor) {
        this.mContourPaint.setColor(contourColor);
        this.drawContour(true);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable contourColorRes(int contourColorRes) {
        this.mContourPaint.setColor(this.mContext.getResources().getColor(contourColorRes));
        this.drawContour(true);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable backgroundColor(int backgroundColor) {
        this.mBackgroundPaint.setColor(backgroundColor);
        this.mRoundedCornerRx = 0;
        this.mRoundedCornerRy = 0;
        return this;
    }

    public IconicsDrawable backgroundColorRes(int backgroundColorRes) {
        return this.backgroundColor(this.mContext.getResources().getColor(backgroundColorRes));
    }

    public IconicsDrawable roundedCornersRxRes(int roundedCornerRxRes) {
        this.mRoundedCornerRx = this.mContext.getResources().getDimensionPixelSize(roundedCornerRxRes);
        return this;
    }

    public IconicsDrawable roundedCornersRxDp(int roundedCornerRxDp) {
        this.mRoundedCornerRx = Utils.convertDpToPx(this.mContext, roundedCornerRxDp);
        return this;
    }

    public IconicsDrawable roundedCornersRxPx(int roundedCornerRxPx) {
        this.mRoundedCornerRx = roundedCornerRxPx;
        return this;
    }

    public IconicsDrawable roundedCornersRyRes(int roundedCornerRyRes) {
        this.mRoundedCornerRy = this.mContext.getResources().getDimensionPixelSize(roundedCornerRyRes);
        return this;
    }

    public IconicsDrawable roundedCornersRyDp(int roundedCornerRyDp) {
        this.mRoundedCornerRy = Utils.convertDpToPx(this.mContext, roundedCornerRyDp);
        return this;
    }

    public IconicsDrawable roundedCornersRyPx(int roundedCornerRyPx) {
        this.mRoundedCornerRy = roundedCornerRyPx;
        return this;
    }

    public IconicsDrawable roundedCornersRes(int roundedCornerRes) {
        this.mRoundedCornerRy = this.mRoundedCornerRx = this.mContext.getResources().getDimensionPixelSize(roundedCornerRes);
        return this;
    }

    public IconicsDrawable roundedCornersDp(int roundedCornerDp) {
        this.mRoundedCornerRy = this.mRoundedCornerRx = Utils.convertDpToPx(this.mContext, roundedCornerDp);
        return this;
    }

    public IconicsDrawable roundedCornersPx(int roundedCornerPx) {
        this.mRoundedCornerRy = this.mRoundedCornerRx = roundedCornerPx;
        return this;
    }

    public IconicsDrawable contourWidthRes(int contourWidthRes) {
        return this.contourWidthPx(this.mContext.getResources().getDimensionPixelSize(contourWidthRes));
    }

    public IconicsDrawable contourWidthDp(int contourWidthDp) {
        return this.contourWidthPx(Utils.convertDpToPx(this.mContext, contourWidthDp));
    }

    public IconicsDrawable contourWidthPx(int contourWidth) {
        this.mContourWidth = contourWidth;
        this.mContourPaint.setStrokeWidth((float)this.mContourWidth);
        this.drawContour(true);
        this.invalidateSelf();
        return this;
    }

    public IconicsDrawable drawContour(boolean drawContour) {
        if (this.mDrawContour != drawContour) {
            this.mDrawContour = drawContour;
            this.mIconPadding = this.mDrawContour ? (this.mIconPadding += this.mContourWidth) : (this.mIconPadding -= this.mContourWidth);
            this.invalidateSelf();
        }
        return this;
    }

    public IconicsDrawable colorFilter(ColorFilter cf) {
        this.setColorFilter(cf);
        return this;
    }

    public IconicsDrawable alpha(int alpha) {
        this.setAlpha(alpha);
        return this;
    }

    public IconicsDrawable style(Paint.Style style) {
        this.mIconPaint.setStyle(style);
        return this;
    }

    public IconicsDrawable typeface(Typeface typeface) {
        this.mIconPaint.setTypeface(typeface);
        return this;
    }

    public void draw(Canvas canvas) {
        if (this.mIcon != null || this.mPlainIcon != null) {
            Rect viewBounds = this.getBounds();
            this.updatePaddingBounds(viewBounds);
            this.updateTextSize(viewBounds);
            this.offsetIcon(viewBounds);
            if (this.mBackgroundPaint != null && this.mRoundedCornerRy > -1 && this.mRoundedCornerRx > -1) {
                canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)viewBounds.width(), (float)viewBounds.height()), (float)this.mRoundedCornerRx, (float)this.mRoundedCornerRy, this.mBackgroundPaint);
            }
            this.mPath.close();
            if (this.mDrawContour) {
                canvas.drawPath(this.mPath, this.mContourPaint);
            }
            this.mIconPaint.setAlpha(this.mAlpha);
            canvas.drawPath(this.mPath, this.mIconPaint);
        }
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(int[] stateSet) {
        this.setAlpha(this.mAlpha);
        return true;
    }

    public int getIntrinsicWidth() {
        return this.mSizeX;
    }

    public int getIntrinsicHeight() {
        return this.mSizeY;
    }

    public int getOpacity() {
        return -1;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public int getCompatAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mIconPaint.setColorFilter(cf);
    }

    public Bitmap toBitmap() {
        if (this.mSizeX == -1 || this.mSizeY == -1) {
            this.actionBar();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getIntrinsicWidth(), (int)this.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.style(Paint.Style.FILL);
        Canvas canvas = new Canvas(bitmap);
        this.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        this.draw(canvas);
        return bitmap;
    }

    private void updatePaddingBounds(Rect viewBounds) {
        if (this.mIconPadding >= 0 && this.mIconPadding * 2 <= viewBounds.width() && this.mIconPadding * 2 <= viewBounds.height()) {
            this.mPaddingBounds.set(viewBounds.left + this.mIconPadding, viewBounds.top + this.mIconPadding, viewBounds.right - this.mIconPadding, viewBounds.bottom - this.mIconPadding);
        }
    }

    private void updateTextSize(Rect viewBounds) {
        float textSize = (float)viewBounds.height() * 2.0f;
        this.mIconPaint.setTextSize(textSize);
        String textValue = this.mIcon != null ? String.valueOf(this.mIcon.getCharacter()) : String.valueOf(this.mPlainIcon);
        this.mIconPaint.getTextPath(textValue, 0, textValue.length(), 0.0f, (float)viewBounds.height(), this.mPath);
        this.mPath.computeBounds(this.mPathBounds, true);
        float deltaWidth = (float)this.mPaddingBounds.width() / this.mPathBounds.width();
        float deltaHeight = (float)this.mPaddingBounds.height() / this.mPathBounds.height();
        float delta = deltaWidth < deltaHeight ? deltaWidth : deltaHeight;
        this.mIconPaint.setTextSize(textSize *= delta);
        this.mIconPaint.getTextPath(textValue, 0, textValue.length(), 0.0f, (float)viewBounds.height(), this.mPath);
        this.mPath.computeBounds(this.mPathBounds, true);
    }

    private void offsetIcon(Rect viewBounds) {
        float startX = (float)viewBounds.centerX() - this.mPathBounds.width() / 2.0f;
        float offsetX = startX - this.mPathBounds.left;
        float startY = (float)viewBounds.centerY() - this.mPathBounds.height() / 2.0f;
        float offsetY = startY - this.mPathBounds.top;
        this.mPath.offset(offsetX + (float)this.mIconOffsetX, offsetY + (float)this.mIconOffsetY);
    }

    public IconicsDrawable clone() {
        IconicsDrawable iconicsDrawable = new IconicsDrawable(this.mContext).paddingPx(this.mIconPadding).roundedCornersRxPx(this.mRoundedCornerRx).roundedCornersRyPx(this.mRoundedCornerRy).sizePxX(this.mSizeX).sizePxY(this.mSizeY).iconOffsetXPx(this.mIconOffsetX).iconOffsetYPx(this.mIconOffsetY).contourColor(this.mContourPaint.getColor()).contourWidthPx(this.mContourWidth).backgroundColor(this.mBackgroundPaint.getColor()).color(this.mIconPaint.getColor()).alpha(this.mAlpha).drawContour(this.mDrawContour).typeface(this.mIconPaint.getTypeface());
        if (this.mIcon != null) {
            iconicsDrawable.icon(this.mIcon);
        } else if (this.mPlainIcon != null) {
            iconicsDrawable.icon(this.mPlainIcon);
        }
        return iconicsDrawable;
    }
}

