/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.BaseAdapterConfiguration;
import com.mopub.common.OnNetworkInitializationFinishedListener;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.sdk.ReferenceSdk;
import java.util.Map;

public class ReferenceAdapterConfiguration
extends BaseAdapterConfiguration {
    private static final String ADAPTER_NAME = ReferenceAdapterConfiguration.class.getSimpleName();
    private static final String ADAPTER_VERSION = "1.0.0.0";
    private static final String MOPUB_NETWORK_NAME = "reference_network";

    @NonNull
    public String getAdapterVersion() {
        return ADAPTER_VERSION;
    }

    @Nullable
    public String getBiddingToken(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        return "good_token";
    }

    @NonNull
    public String getMoPubNetworkName() {
        return MOPUB_NETWORK_NAME;
    }

    @NonNull
    public String getNetworkSdkVersion() {
        String adapterVersion = this.getAdapterVersion();
        return !TextUtils.isEmpty((CharSequence)adapterVersion) ? adapterVersion.substring(0, adapterVersion.lastIndexOf(46)) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeNetwork(@NonNull Context context, @Nullable Map<String, String> configuration, final @NonNull OnNetworkInitializationFinishedListener listener) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)listener);
        Class<ReferenceAdapterConfiguration> clazz = ReferenceAdapterConfiguration.class;
        synchronized (ReferenceAdapterConfiguration.class) {
            try {
                ReferenceSdk.initialize(new ReferenceSdk.ReferenceInitializationListener(){

                    @Override
                    public void onInitializationFinished() {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{ADAPTER_NAME, "Reference Network initialized."});
                        listener.onNetworkInitializationFinished(ReferenceAdapterConfiguration.class, MoPubErrorCode.ADAPTER_INITIALIZATION_SUCCESS);
                    }
                });
            }
            catch (Exception exception) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{ADAPTER_NAME, "Initializing the Reference Network has encountered an exception.", exception});
                listener.onNetworkInitializationFinished(ReferenceAdapterConfiguration.class, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            }
            return;
        }
    }
}

