/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.LifecycleListener;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.BaseAd;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.ReferenceAdapterConfiguration;
import com.mopub.sdk.ReferenceFullScreenAd;
import java.util.Map;

public class ReferenceFullscreenAdapter
extends BaseAd
implements ReferenceFullScreenAd.ReferenceFullScreenAdListener {
    private final String ADAPTER_NAME = ReferenceFullscreenAdapter.class.getSimpleName();
    private String mAdUnitId;
    private boolean mIsRewarded;
    @Nullable
    private ReferenceFullScreenAd mFullScreenAd;
    @NonNull
    private final ReferenceAdapterConfiguration mReferenceAdapterConfiguration = new ReferenceAdapterConfiguration();

    protected void load(@NonNull Context context, @NonNull AdData adData) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)adData);
        this.setAutomaticImpressionAndClickTracking(false);
        Map extras = adData.getExtras();
        if (extras.isEmpty()) {
            this.failAdRequest("Reference fullscreen ad failed to load because no data is provided for the ad request. Make sure your ad unit setup on the MoPub dashboard is correct.");
            return;
        }
        this.mAdUnitId = (String)extras.get("adUnitId");
        this.mIsRewarded = Boolean.parseBoolean((String)extras.get("isRewarded"));
        this.mReferenceAdapterConfiguration.setCachedInitializationParameters(context, extras);
        this.mFullScreenAd = new ReferenceFullScreenAd(context, this);
        this.mFullScreenAd.loadAd(this.mIsRewarded);
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{this.ADAPTER_NAME});
    }

    protected boolean checkAndInitializeSdk(@NonNull Activity launcherActivity, @NonNull AdData adData) {
        Preconditions.checkNotNull((Object)launcherActivity);
        Preconditions.checkNotNull((Object)adData);
        return false;
    }

    protected void onInvalidate() {
        if (this.mFullScreenAd != null) {
            this.mFullScreenAd.destroy();
            this.mFullScreenAd = null;
        }
    }

    private boolean hasVideoAvailable() {
        if (this.mFullScreenAd != null) {
            return this.mFullScreenAd.isAdLoaded();
        }
        return false;
    }

    protected void show() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_ATTEMPTED, (Object[])new Object[]{this.ADAPTER_NAME});
        if (this.mFullScreenAd != null && this.hasVideoAvailable()) {
            this.mFullScreenAd.show();
        } else {
            this.failAdRequest("Reference fullscreen ad failed to show. An ad was not ready.");
        }
    }

    @Nullable
    protected LifecycleListener getLifecycleListener() {
        return null;
    }

    @NonNull
    protected String getAdNetworkId() {
        return this.mAdUnitId == null ? "" : this.mAdUnitId;
    }

    @Override
    public void onFullScreenAdLoaded() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{this.ADAPTER_NAME});
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoaded();
        }
    }

    @Override
    public void onFullScreenAdLoadFailed() {
        this.failAdRequest("Reference fullscreen ad failed to load.");
    }

    @Override
    public void onFullScreenAdShowFailed() {
        this.failAdRequest("Reference fullscreen ad failed to show.");
    }

    @Override
    public void onFullScreenAdShown() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_SUCCESS, (Object[])new Object[]{this.ADAPTER_NAME});
        if (this.mInteractionListener != null) {
            this.mInteractionListener.onAdShown();
            this.mInteractionListener.onAdImpression();
        }
    }

    @Override
    public void onFullScreenAdClicked() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CLICKED, (Object[])new Object[]{this.ADAPTER_NAME});
        if (this.mInteractionListener != null) {
            this.mInteractionListener.onAdClicked();
        }
    }

    @Override
    public void onFullScreenAdDismissed() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.DID_DISAPPEAR, (Object[])new Object[]{this.ADAPTER_NAME});
        if (this.mInteractionListener != null) {
            this.mInteractionListener.onAdDismissed();
        }
    }

    @Override
    public void onFullScreenAdRewarded() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOULD_REWARD, (Object[])new Object[]{this.ADAPTER_NAME, 0, ""});
        if (this.mInteractionListener != null && this.mIsRewarded) {
            this.mInteractionListener.onAdComplete(MoPubReward.success((String)"", (int)0));
        }
    }

    private void failAdRequest(String errorMsg) {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{this.ADAPTER_NAME, errorMsg});
        if (this.mInteractionListener == null && this.mLoadListener != null) {
            MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{this.ADAPTER_NAME, MoPubErrorCode.NO_FILL.getIntCode(), MoPubErrorCode.NO_FILL});
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.NO_FILL);
        } else if (this.mInteractionListener != null) {
            MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_FAILED, (Object[])new Object[]{this.ADAPTER_NAME, MoPubErrorCode.AD_SHOW_ERROR.getIntCode(), MoPubErrorCode.AD_SHOW_ERROR});
            this.mInteractionListener.onAdFailed(MoPubErrorCode.NO_FILL);
        }
    }
}

