/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.LifecycleListener;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.BaseAd;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.ReferenceAdapterConfiguration;
import com.mopub.sdk.ReferenceInlineAd;
import java.util.Map;

public class ReferenceInlineAdapter
extends BaseAd
implements ReferenceInlineAd.ReferenceInlineAdListener {
    private static final String ADAPTER_NAME = ReferenceInlineAdapter.class.getSimpleName();
    private static final String AD_UNIT_ID_KEY = "adUnitId";
    @Nullable
    private ReferenceInlineAd mInlineAd;
    private String mAdUnitId;
    @NonNull
    private final ReferenceAdapterConfiguration mReferenceAdapterConfiguration = new ReferenceAdapterConfiguration();

    protected void load(@NonNull Context context, @NonNull AdData adData) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)adData);
        this.setAutomaticImpressionAndClickTracking(false);
        Map extras = adData.getExtras();
        if (extras.isEmpty()) {
            this.failAdRequest("Reference inline ad failed to load because no data is provided for the ad request. Make sure your ad unit setup on the MoPub dashboard is correct.");
            return;
        }
        this.mAdUnitId = (String)extras.get(AD_UNIT_ID_KEY);
        this.mReferenceAdapterConfiguration.setCachedInitializationParameters(context, extras);
        this.mInlineAd = new ReferenceInlineAd(context, this);
        this.mInlineAd.loadAd();
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
    }

    public View getAdView() {
        if (this.mInlineAd != null) {
            return this.mInlineAd.getAdView();
        }
        return null;
    }

    protected void onInvalidate() {
        if (this.mInlineAd != null) {
            this.mInlineAd.destroy();
            this.mInlineAd = null;
        }
    }

    @Nullable
    protected LifecycleListener getLifecycleListener() {
        return null;
    }

    @NonNull
    public String getAdNetworkId() {
        return this.mAdUnitId == null ? "" : this.mAdUnitId;
    }

    protected boolean checkAndInitializeSdk(@NonNull Activity launcherActivity, @NonNull AdData adData) {
        Preconditions.checkNotNull((Object)launcherActivity);
        Preconditions.checkNotNull((Object)adData);
        return false;
    }

    @Override
    public void onAdLoaded() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoaded();
        }
    }

    @Override
    public void onAdImpression() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
        if (this.mInteractionListener != null) {
            this.mInteractionListener.onAdImpression();
        }
    }

    @Override
    public void onAdFailedToLoad() {
        this.failAdRequest("Reference inline ad failed to load.");
    }

    @Override
    public void onAdClicked() {
        MoPubLog.log((String)this.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CLICKED, (Object[])new Object[]{ADAPTER_NAME});
        if (this.mInteractionListener != null) {
            this.mInteractionListener.onAdClicked();
        }
    }

    private void failAdRequest(String errorMsg) {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{ADAPTER_NAME, errorMsg});
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, MoPubErrorCode.NO_FILL.getIntCode(), MoPubErrorCode.NO_FILL});
        if (this.mInteractionListener == null && this.mLoadListener != null) {
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.NO_FILL);
        } else if (this.mInteractionListener != null) {
            this.mInteractionListener.onAdFailed(MoPubErrorCode.NO_FILL);
        }
    }
}

