/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.NativeRendererHelper;
import com.mopub.nativeads.ReferenceNativeAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class ReferenceNativeAdRenderer
implements MoPubAdRenderer<ReferenceNativeAdapter.ReferenceNativeAd> {
    private final ReferenceViewBinder mViewBinder;
    @NonNull
    final WeakHashMap<View, ReferenceNativeViewHolder> mViewHolderMap;

    public ReferenceNativeAdRenderer(ReferenceViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
        this.mViewHolderMap = new WeakHashMap();
    }

    @NonNull
    public View createAdView(@NonNull Context context, ViewGroup parent) {
        Preconditions.checkNotNull((Object)context);
        return LayoutInflater.from((Context)context).inflate(this.mViewBinder.layoutId, parent, false);
    }

    public void renderAdView(@NonNull View view, @NonNull ReferenceNativeAdapter.ReferenceNativeAd referenceNativeAd) {
        Preconditions.checkNotNull((Object)referenceNativeAd);
        Preconditions.checkNotNull((Object)view);
        ReferenceNativeViewHolder referenceNativeViewHolder = this.mViewHolderMap.get(view);
        if (referenceNativeViewHolder == null) {
            referenceNativeViewHolder = ReferenceNativeViewHolder.fromViewBinder(view, this.mViewBinder);
            this.mViewHolderMap.put(view, referenceNativeViewHolder);
        }
        this.update(referenceNativeViewHolder, referenceNativeAd);
    }

    public boolean supports(@NonNull BaseNativeAd nativeAd) {
        Preconditions.checkNotNull((Object)nativeAd);
        return nativeAd instanceof ReferenceNativeAdapter.ReferenceNativeAd;
    }

    private void update(ReferenceNativeViewHolder referenceNativeViewHolder, ReferenceNativeAdapter.ReferenceNativeAd nativeAd) {
        NativeRendererHelper.addTextView((TextView)referenceNativeViewHolder.getTitleView(), (String)nativeAd.getTitle());
        NativeRendererHelper.addTextView((TextView)referenceNativeViewHolder.getTextView(), (String)nativeAd.getText());
        NativeRendererHelper.addTextView((TextView)referenceNativeViewHolder.getCallToActionView(), (String)nativeAd.getCallToAction());
        NativeRendererHelper.addTextView((TextView)referenceNativeViewHolder.getAdvertiserNameView(), (String)nativeAd.getAdvertiserName());
        NativeRendererHelper.addTextView((TextView)referenceNativeViewHolder.getSponsoredLabelView(), (String)nativeAd.getSponsoredName());
        NativeImageHelper.loadImageView((String)nativeAd.getMainImageUrl(), (ImageView)referenceNativeViewHolder.mainImageView);
        NativeImageHelper.loadImageView((String)nativeAd.getIconImageUrl(), (ImageView)referenceNativeViewHolder.iconImageView);
    }

    public static class ReferenceViewBinder {
        final int layoutId;
        final int titleId;
        final int textId;
        final int callToActionId;
        final int adChoicesRelativeLayoutId;
        @NonNull
        final Map<String, Integer> extras;
        final int mainImageId;
        final int iconImageId;
        final int advertiserNameId;
        final int sponsoredLabelId;

        private ReferenceViewBinder(@NonNull Builder builder) {
            Preconditions.checkNotNull((Object)builder);
            this.layoutId = builder.layoutId;
            this.titleId = builder.titleId;
            this.textId = builder.textId;
            this.callToActionId = builder.callToActionId;
            this.adChoicesRelativeLayoutId = builder.adChoicesRelativeLayoutId;
            this.extras = builder.extras;
            this.mainImageId = builder.mainImageId;
            this.iconImageId = builder.iconImageId;
            this.advertiserNameId = builder.advertiserNameId;
            this.sponsoredLabelId = builder.sponsoredLabelId;
        }

        public static class Builder {
            private final int layoutId;
            private int titleId;
            private int textId;
            private int callToActionId;
            private int adChoicesRelativeLayoutId;
            @NonNull
            private Map<String, Integer> extras;
            private int mainImageId;
            private int iconImageId;
            private int advertiserNameId;
            private int sponsoredLabelId;

            public Builder(int layoutId) {
                this.layoutId = layoutId;
                this.extras = new HashMap<String, Integer>();
            }

            @NonNull
            public final Builder titleId(int titleId) {
                this.titleId = titleId;
                return this;
            }

            @NonNull
            public final Builder textId(int textId) {
                this.textId = textId;
                return this;
            }

            @NonNull
            public final Builder callToActionId(int callToActionId) {
                this.callToActionId = callToActionId;
                return this;
            }

            @NonNull
            public final Builder adChoicesRelativeLayoutId(int adChoicesRelativeLayoutId) {
                this.adChoicesRelativeLayoutId = adChoicesRelativeLayoutId;
                return this;
            }

            @NonNull
            public final Builder extras(Map<String, Integer> resourceIds) {
                this.extras = new HashMap<String, Integer>(resourceIds);
                return this;
            }

            @NonNull
            public final Builder addExtra(String key, int resourceId) {
                this.extras.put(key, resourceId);
                return this;
            }

            @NonNull
            public Builder mainImageId(int mainImageId) {
                this.mainImageId = mainImageId;
                return this;
            }

            @NonNull
            public Builder iconImageId(int iconImageId) {
                this.iconImageId = iconImageId;
                return this;
            }

            @NonNull
            public Builder advertiserNameId(int advertiserNameId) {
                this.advertiserNameId = advertiserNameId;
                return this;
            }

            @NonNull
            public Builder sponsoredNameId(int sponsoredLabelId) {
                this.sponsoredLabelId = sponsoredLabelId;
                return this;
            }

            @NonNull
            public ReferenceViewBinder build() {
                return new ReferenceViewBinder(this);
            }
        }
    }

    static class ReferenceNativeViewHolder {
        @Nullable
        private TextView titleView;
        @Nullable
        private TextView textView;
        @Nullable
        private TextView callToActionView;
        @Nullable
        private RelativeLayout adChoicesContainer;
        @Nullable
        private ImageView mainImageView;
        @Nullable
        private ImageView iconImageView;
        @Nullable
        private TextView advertiserNameView;
        @Nullable
        private TextView sponsoredLabelView;

        private ReferenceNativeViewHolder() {
        }

        static ReferenceNativeViewHolder fromViewBinder(@Nullable View view, @Nullable ReferenceViewBinder referenceViewBinder) {
            if (view == null || referenceViewBinder == null) {
                return new ReferenceNativeViewHolder();
            }
            ReferenceNativeViewHolder viewHolder = new ReferenceNativeViewHolder();
            viewHolder.titleView = (TextView)view.findViewById(referenceViewBinder.titleId);
            viewHolder.textView = (TextView)view.findViewById(referenceViewBinder.textId);
            viewHolder.callToActionView = (TextView)view.findViewById(referenceViewBinder.callToActionId);
            viewHolder.adChoicesContainer = (RelativeLayout)view.findViewById(referenceViewBinder.adChoicesRelativeLayoutId);
            viewHolder.mainImageView = (ImageView)view.findViewById(referenceViewBinder.mainImageId);
            viewHolder.iconImageView = (ImageView)view.findViewById(referenceViewBinder.iconImageId);
            viewHolder.advertiserNameView = (TextView)view.findViewById(referenceViewBinder.advertiserNameId);
            viewHolder.sponsoredLabelView = (TextView)view.findViewById(referenceViewBinder.sponsoredLabelId);
            return viewHolder;
        }

        @Nullable
        public TextView getTitleView() {
            return this.titleView;
        }

        @Nullable
        public TextView getTextView() {
            return this.textView;
        }

        @Nullable
        public TextView getCallToActionView() {
            return this.callToActionView;
        }

        @Nullable
        public RelativeLayout getAdChoicesContainer() {
            return this.adChoicesContainer;
        }

        @Nullable
        public TextView getAdvertiserNameView() {
            return this.advertiserNameView;
        }

        @Nullable
        public TextView getSponsoredLabelView() {
            return this.sponsoredLabelView;
        }
    }
}

