/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.ReferenceAdapterConfiguration;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.sdk.ReferenceNativeAdBase;
import java.util.Map;

public class ReferenceNativeAdapter
extends CustomEventNative {
    private static final String ADAPTER_NAME = ReferenceNativeAdapter.class.getSimpleName();
    private static final String AD_UNIT_ID_KEY = "mAdUnitId";
    private static String mAdUnitId;
    private static CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
    @NonNull
    private final ReferenceAdapterConfiguration mReferenceAdapterConfiguration = new ReferenceAdapterConfiguration();

    protected void loadNativeAd(@NonNull Context context, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)customEventNativeListener);
        Preconditions.checkNotNull(localExtras);
        Preconditions.checkNotNull(serverExtras);
        if (serverExtras.isEmpty()) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NETWORK_NO_FILL);
            MoPubLog.log((String)ReferenceNativeAdapter.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.NETWORK_NO_FILL.getIntCode(), NativeErrorCode.NETWORK_NO_FILL});
            return;
        }
        mAdUnitId = serverExtras.get(AD_UNIT_ID_KEY);
        this.mReferenceAdapterConfiguration.setCachedInitializationParameters(context, serverExtras);
        ReferenceNativeAd referenceNativeAd = new ReferenceNativeAd(new ReferenceNativeAdBase(context), customEventNativeListener);
        referenceNativeAd.loadAd();
    }

    private static String getAdNetworkId() {
        return mAdUnitId == null ? "" : mAdUnitId;
    }

    public static class ReferenceNativeAd
    extends BaseNativeAd
    implements ReferenceNativeAdBase.ReferenceNativeAdListener {
        private ReferenceNativeAdBase mNativeAd;

        ReferenceNativeAd(ReferenceNativeAdBase nativeAd, CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.mNativeAd = nativeAd;
            mCustomEventNativeListener = customEventNativeListener;
            this.mNativeAd.setAdListener(this);
        }

        void loadAd() {
            this.mNativeAd.loadAd();
            MoPubLog.log((String)ReferenceNativeAdapter.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
        }

        public final String getMainImageUrl() {
            return this.mNativeAd.getMainImageUrl();
        }

        public final String getIconImageUrl() {
            return this.mNativeAd.getIconImageUrl();
        }

        public final String getAdvertiserName() {
            return this.mNativeAd.getAdvertiserName();
        }

        public final String getTitle() {
            return this.mNativeAd.getAdTitle();
        }

        public final String getText() {
            return this.mNativeAd.getAdBodyText();
        }

        public final String getCallToAction() {
            return this.mNativeAd.getAdCallToAction();
        }

        @Nullable
        public final String getSponsoredName() {
            return this.mNativeAd.getSponsoredTranslation();
        }

        public final String getPrivacyInformationIconClickThroughUrl() {
            return this.mNativeAd.getAdChoicesLinkUrl();
        }

        @Override
        public void onAdLoaded() {
            mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)this);
            MoPubLog.log((String)ReferenceNativeAdapter.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
        }

        @Override
        public void onAdImpression() {
            this.notifyAdImpressed();
            MoPubLog.log((String)ReferenceNativeAdapter.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
        }

        @Override
        public void onAdClicked() {
            this.notifyAdClicked();
            MoPubLog.log((String)ReferenceNativeAdapter.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CLICKED, (Object[])new Object[]{ADAPTER_NAME});
        }

        @Override
        public void onAdFailedToLoad() {
            MoPubLog.log((String)ReferenceNativeAdapter.getAdNetworkId(), (MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.NETWORK_NO_FILL.getIntCode(), NativeErrorCode.NETWORK_NO_FILL});
            if (mCustomEventNativeListener != null) {
                mCustomEventNativeListener.onNativeAdFailed(NativeErrorCode.NETWORK_NO_FILL);
            }
        }

        public void prepare(@NonNull View view) {
        }

        public void clear(@NonNull View view) {
            Preconditions.checkNotNull((Object)view);
        }

        public void destroy() {
            if (this.mNativeAd != null) {
                this.mNativeAd.destroy();
                this.mNativeAd = null;
            }
        }
    }
}

