/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.mopub.common.Preconditions;

public abstract class ReferenceBroadcastReceiver
extends BroadcastReceiver {
    private final long mBroadcastIdentifier;
    @Nullable
    private Context mContext;

    @NonNull
    public abstract IntentFilter getIntentFilter();

    public ReferenceBroadcastReceiver(long broadcastIdentifier) {
        this.mBroadcastIdentifier = broadcastIdentifier;
    }

    public static void broadcastAction(@NonNull Context context, long broadcastIdentifier, @NonNull String action) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)action);
        Intent intent = new Intent(action);
        intent.putExtra("broadcast_identifier", broadcastIdentifier);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast(intent);
    }

    public void register(@NonNull BroadcastReceiver broadcastReceiver, @NonNull Context context) {
        Preconditions.checkNotNull((Object)broadcastReceiver);
        Preconditions.checkNotNull((Object)context);
        this.mContext = context.getApplicationContext();
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(broadcastReceiver, this.getIntentFilter());
    }

    public void unregister(@Nullable BroadcastReceiver broadcastReceiver) {
        if (this.mContext != null && broadcastReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(broadcastReceiver);
            this.mContext = null;
        }
    }

    public boolean shouldConsumeBroadcast(@NonNull Intent intent) {
        Preconditions.checkNotNull((Object)intent);
        long receivedIdentifier = intent.getLongExtra("broadcast_identifier", -1L);
        return this.mBroadcastIdentifier == receivedIdentifier;
    }
}

