/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import com.mopub.sdk.ReferenceBroadcastReceiver;
import com.mopub.sdk.ReferenceFullScreenAd;

public class ReferenceEventForwardingBroadcastReceiver
extends ReferenceBroadcastReceiver {
    private final ReferenceFullScreenAd.ReferenceFullScreenAdListener mListener;
    private static IntentFilter sIntentFilter;

    public ReferenceEventForwardingBroadcastReceiver(ReferenceFullScreenAd.ReferenceFullScreenAdListener listener, long broadcastIdentifier) {
        super(broadcastIdentifier);
        this.mListener = listener;
        this.getIntentFilter();
    }

    @Override
    @NonNull
    public IntentFilter getIntentFilter() {
        if (sIntentFilter == null) {
            sIntentFilter = new IntentFilter();
            sIntentFilter.addAction("com.mopub.sdk.action.fullscreen.fail");
            sIntentFilter.addAction("com.mopub.sdk.action.fullscreen.show");
            sIntentFilter.addAction("com.mopub.sdk.action.fullscreen.dismiss");
            sIntentFilter.addAction("com.mopub.sdk.action.fullscreen.click");
            sIntentFilter.addAction("com.mopub.sdk.action.rewarded.reward");
        }
        return sIntentFilter;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mListener == null) {
            return;
        }
        if (!this.shouldConsumeBroadcast(intent)) {
            return;
        }
        String action = intent.getAction();
        if ("com.mopub.sdk.action.fullscreen.fail".equals(action)) {
            this.mListener.onFullScreenAdLoadFailed();
        } else if ("com.mopub.sdk.action.fullscreen.show".equals(action)) {
            this.mListener.onFullScreenAdShown();
        } else if ("com.mopub.sdk.action.fullscreen.dismiss".equals(action)) {
            this.mListener.onFullScreenAdDismissed();
            this.unregister(this);
        } else if ("com.mopub.sdk.action.fullscreen.click".equals(action)) {
            this.mListener.onFullScreenAdClicked();
        } else if ("com.mopub.sdk.action.rewarded.reward".equals(action)) {
            this.mListener.onFullScreenAdRewarded();
        }
    }
}

