/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.VideoView;
import com.mopub.mobileads.referencenetwork.R;
import com.mopub.sdk.ReferenceBroadcastReceiver;

public class ReferenceFullScreenActivity
extends Activity {
    private long mBroadcastIdentifier;
    private WebView mWebView;
    private VideoView mVideoView;
    private boolean mIsAdRewarded;

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_reference_full_screen_activity);
        String adMarkup = this.getIntent().getStringExtra("fullscreen_ad_markup");
        this.mBroadcastIdentifier = this.getIntent().getLongExtra("broadcast_identifier", -1L);
        this.mIsAdRewarded = this.getIntent().getBooleanExtra("rewarded", false);
        if (this.mIsAdRewarded) {
            this.mVideoView = (VideoView)this.findViewById(R.id.reference_fullscreen_videoview);
            this.mVideoView.setVisibility(0);
            this.mVideoView.setVideoPath(adMarkup);
            this.mVideoView.start();
            this.mVideoView.setOnTouchListener(new View.OnTouchListener(){
                long startTime = 0L;

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        this.startTime = System.currentTimeMillis();
                    }
                    if (event.getAction() == 1 && System.currentTimeMillis() - this.startTime < (long)ViewConfiguration.getTapTimeout()) {
                        ReferenceFullScreenActivity.this.cleanUp();
                        ReferenceFullScreenActivity.this.performClick();
                    }
                    return true;
                }
            });
        } else {
            this.mWebView = (WebView)this.findViewById(R.id.reference_fullscreen_webview);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.setVisibility(0);
            this.mWebView.setWebChromeClient(new WebChromeClient());
            this.mWebView.loadData(adMarkup, "text/html", "UTF-8");
            this.mWebView.setOnTouchListener(new View.OnTouchListener(){
                long startTime = 0L;

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        this.startTime = System.currentTimeMillis();
                    }
                    if (event.getAction() == 1 && System.currentTimeMillis() - this.startTime < (long)ViewConfiguration.getTapTimeout()) {
                        ReferenceFullScreenActivity.this.performClick();
                    }
                    return true;
                }
            });
        }
        ReferenceBroadcastReceiver.broadcastAction(this.getApplicationContext(), this.mBroadcastIdentifier, "com.mopub.sdk.action.fullscreen.show");
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.mIsAdRewarded) {
            ReferenceBroadcastReceiver.broadcastAction(this.getApplicationContext(), this.mBroadcastIdentifier, "com.mopub.sdk.action.rewarded.reward");
        }
        ReferenceBroadcastReceiver.broadcastAction(this.getApplicationContext(), this.mBroadcastIdentifier, "com.mopub.sdk.action.fullscreen.dismiss");
        this.cleanUp();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mIsAdRewarded) {
            ReferenceBroadcastReceiver.broadcastAction(this.getApplicationContext(), this.mBroadcastIdentifier, "com.mopub.sdk.action.rewarded.reward");
        }
        ReferenceBroadcastReceiver.broadcastAction(this.getApplicationContext(), this.mBroadcastIdentifier, "com.mopub.sdk.action.fullscreen.dismiss");
        this.cleanUp();
    }

    protected void onResume() {
        super.onResume();
        if (this.mIsAdRewarded && this.mVideoView == null) {
            this.cleanUp();
            this.finish();
        }
    }

    private void performClick() {
        ReferenceBroadcastReceiver.broadcastAction(this.getApplicationContext(), this.mBroadcastIdentifier, "com.mopub.sdk.action.fullscreen.click");
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.mopub.com"));
        browserIntent.setFlags(0x10000000);
        this.startActivity(browserIntent);
    }

    private void cleanUp() {
        if (this.mWebView != null) {
            this.mWebView.destroy();
            this.mWebView = null;
        }
        if (this.mVideoView != null) {
            this.mVideoView.stopPlayback();
            this.mVideoView.clearAnimation();
            this.mVideoView.suspend();
            this.mVideoView = null;
        }
    }
}

