/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import java.util.Arrays;

public class ReferenceNativeAdBase
extends Activity {
    private final Context mContext;
    private final String[] mNativeAdViewIds = new String[]{"native_main_image", "native_icon_image", "native_title", "native_text", "native_sponsored_text_view", "native_cta", "native_privacy_information_icon_image"};
    private ReferenceNativeAdListener mListener;

    public ReferenceNativeAdBase(Context context) {
        this.mContext = context;
    }

    public void setAdListener(ReferenceNativeAdListener listener) {
        this.mListener = listener;
    }

    public void loadAd() {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ReferenceNativeAdBase.this.mListener != null) {
                    ReferenceNativeAdBase.this.mListener.onAdLoaded();
                    Handler handler = new Handler();
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (ReferenceNativeAdBase.this.mContext instanceof Activity) {
                                Activity activity = (Activity)ReferenceNativeAdBase.this.mContext;
                                ViewGroup vg = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
                                ReferenceNativeAdBase.this.trackImpressionAndClick(vg);
                            }
                        }
                    }, 1000L);
                }
            }
        }, 500L);
    }

    public void trackImpressionAndClick(ViewGroup parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View view = parent.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.trackImpressionAndClick((ViewGroup)view);
                continue;
            }
            if (view.getId() == -1) continue;
            String id2 = view.getResources().getResourceName(view.getId());
            id2 = id2.substring(id2.indexOf(47) + 1);
            if (!Arrays.asList(this.mNativeAdViewIds).contains(id2)) continue;
            if (id2.equals("native_main_image") && view.getVisibility() == 0 && this.mListener != null) {
                this.mListener.onAdImpression();
            }
            view.setOnTouchListener(new View.OnTouchListener(){
                long startTime = 0L;

                @SuppressLint(value={"ClickableViewAccessibility"})
                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        this.startTime = System.currentTimeMillis();
                    }
                    if (event.getAction() == 1 && System.currentTimeMillis() - this.startTime < (long)ViewConfiguration.getTapTimeout()) {
                        if (ReferenceNativeAdBase.this.mListener != null) {
                            ReferenceNativeAdBase.this.mListener.onAdClicked();
                        }
                        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.mopub.com"));
                        browserIntent.setFlags(0x10000000);
                        ReferenceNativeAdBase.this.mContext.startActivity(browserIntent);
                    }
                    return true;
                }
            });
        }
    }

    public String getMainImageUrl() {
        return "https://images.squarespace-cdn.com/content/v1/54992035e4b0c49940a59e49/1586714639270-6O27VM796316NPD4R3DH/ke17ZwdGBToddI8pDm48kM67dVXED_yMBjHtlg_uL0sUqsxRUqqbr1mOJYKfIPR7LoDQ9mXPOjoJoqy81S2I8N_N4V1vUb5AoIIIbLZhVYxCRW4BPu10St3TBAUQYVKcNPDvIAs8f1WUKmWSu3fO4mWtI-U7sMj89S5lCDO4xNISmZH7m9nvOKn--z65CT5h/image-asset.jpeg";
    }

    public String getIconImageUrl() {
        return "https://cdn.vox-cdn.com/thumbor/RsL5FNihoaV9odgkWQWIATp1xr0=/0x16:1103x751/1400x1400/filters:focal(0x16:1103x751):format(png)/cdn.vox-cdn.com/uploads/chorus_image/image/46840054/Screenshot_2015-07-27_15.11.13.0.0.png";
    }

    public String getAdvertiserName() {
        return "Test Advertiser";
    }

    public String getAdTitle() {
        return "Test Title";
    }

    public String getAdBodyText() {
        return "Test Body";
    }

    public String getAdCallToAction() {
        return "Test";
    }

    public String getSponsoredTranslation() {
        return "Test Sponsor";
    }

    public String getAdChoicesLinkUrl() {
        return "https://www.mopub.com/en/legal/optout";
    }

    public void destroy() {
        this.mListener = null;
    }

    public static interface ReferenceNativeAdListener {
        public void onAdLoaded();

        public void onAdImpression();

        public void onAdFailedToLoad();

        public void onAdClicked();
    }
}

