/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.app.Activity;
import android.app.DialogFragment;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.nononsenseapps.filepicker.R;

public abstract class NewItemFragment
extends DialogFragment {
    private String itemName = null;
    private View okButton = null;
    private OnNewFolderListener listener = null;

    public void setListener(OnNewFolderListener listener) {
        this.listener = listener;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.setRetainInstance(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().setTitle(this.getDialogTitle());
        View view = inflater.inflate(R.layout.dialog_new_item, null);
        this.okButton = view.findViewById(R.id.button_ok);
        this.okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NewItemFragment.this.listener != null) {
                    NewItemFragment.this.listener.onNewFolder(NewItemFragment.this.itemName);
                }
                NewItemFragment.this.dismiss();
            }
        });
        view.findViewById(R.id.button_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewItemFragment.this.dismiss();
            }
        });
        EditText editText = (EditText)view.findViewById(R.id.edit_text);
        if (this.itemName == null) {
            this.okButton.setEnabled(false);
        } else {
            editText.setText((CharSequence)this.itemName);
            this.validateItemName();
        }
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                NewItemFragment.this.itemName = s.toString();
                NewItemFragment.this.validateItemName();
            }
        });
        return view;
    }

    private void validateItemName() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.validateName(this.itemName));
        }
    }

    protected abstract boolean validateName(String var1);

    protected abstract int getDialogTitle();

    public static interface OnNewFolderListener {
        public void onNewFolder(String var1);
    }
}

