/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.action;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.engine.action.Action;
import com.otaliastudios.cameraview.engine.action.ActionCallback;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
public abstract class BaseAction
implements Action {
    private final List<ActionCallback> callbacks = new ArrayList<ActionCallback>();
    private int state;
    private ActionHolder holder;
    private boolean needsOnStart;

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final void start(@NonNull ActionHolder holder) {
        this.holder = holder;
        holder.addAction(this);
        if (holder.getLastResult(this) != null) {
            this.onStart(holder);
        } else {
            this.needsOnStart = true;
        }
    }

    @Override
    public final void abort(@NonNull ActionHolder holder) {
        holder.removeAction(this);
        if (!this.isCompleted()) {
            this.onAbort(holder);
            this.setState(Integer.MAX_VALUE);
        }
        this.needsOnStart = false;
    }

    @CallSuper
    protected void onStart(@NonNull ActionHolder holder) {
        this.holder = holder;
    }

    protected void onAbort(@NonNull ActionHolder holder) {
    }

    @Override
    @CallSuper
    public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
        if (this.needsOnStart) {
            this.onStart(holder);
            this.needsOnStart = false;
        }
    }

    @Override
    public void onCaptureProgressed(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull CaptureResult result) {
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
    }

    protected final void setState(int newState) {
        if (newState != this.state) {
            this.state = newState;
            for (ActionCallback callback : this.callbacks) {
                callback.onActionStateChanged(this, this.state);
            }
            if (this.state == Integer.MAX_VALUE) {
                this.holder.removeAction(this);
                this.onCompleted(this.holder);
            }
        }
    }

    public boolean isCompleted() {
        return this.state == Integer.MAX_VALUE;
    }

    protected void onCompleted(@NonNull ActionHolder holder) {
    }

    @NonNull
    protected ActionHolder getHolder() {
        return this.holder;
    }

    @NonNull
    protected <T> T readCharacteristic(@NonNull CameraCharacteristics.Key<T> key, @NonNull T fallback) {
        Object value = this.holder.getCharacteristics(this).get(key);
        return (T)(value == null ? fallback : value);
    }

    @Override
    public void addCallback(@NonNull ActionCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
            callback.onActionStateChanged(this, this.getState());
        }
    }

    @Override
    public void removeCallback(@NonNull ActionCallback callback) {
        this.callbacks.remove(callback);
    }
}

