/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

public class OrientationHelper {
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Context mContext;
    private final Callback mCallback;
    @VisibleForTesting
    final OrientationEventListener mDeviceOrientationListener;
    private int mDeviceOrientation = -1;
    @VisibleForTesting
    final DisplayManager.DisplayListener mDisplayOffsetListener;
    private int mDisplayOffset = -1;
    private boolean mEnabled;

    public OrientationHelper(@NonNull Context context, @NonNull Callback callback) {
        this.mContext = context;
        this.mCallback = callback;
        this.mDeviceOrientationListener = new OrientationEventListener(context.getApplicationContext(), 3){

            public void onOrientationChanged(int orientation) {
                int deviceOrientation = 0;
                if (orientation == -1) {
                    deviceOrientation = OrientationHelper.this.mDeviceOrientation != -1 ? OrientationHelper.this.mDeviceOrientation : 0;
                } else if (orientation >= 315 || orientation < 45) {
                    deviceOrientation = 0;
                } else if (orientation >= 45 && orientation < 135) {
                    deviceOrientation = 90;
                } else if (orientation >= 135 && orientation < 225) {
                    deviceOrientation = 180;
                } else if (orientation >= 225 && orientation < 315) {
                    deviceOrientation = 270;
                }
                if (deviceOrientation != OrientationHelper.this.mDeviceOrientation) {
                    OrientationHelper.this.mDeviceOrientation = deviceOrientation;
                    OrientationHelper.this.mCallback.onDeviceOrientationChanged(OrientationHelper.this.mDeviceOrientation);
                }
            }
        };
        this.mDisplayOffsetListener = Build.VERSION.SDK_INT >= 17 ? new DisplayManager.DisplayListener(){

            public void onDisplayAdded(int displayId) {
            }

            public void onDisplayRemoved(int displayId) {
            }

            public void onDisplayChanged(int displayId) {
                int oldDisplayOffset = OrientationHelper.this.mDisplayOffset;
                int newDisplayOffset = OrientationHelper.this.findDisplayOffset();
                if (newDisplayOffset != oldDisplayOffset) {
                    OrientationHelper.this.mDisplayOffset = newDisplayOffset;
                    OrientationHelper.this.mCallback.onDisplayOffsetChanged();
                }
            }
        } : null;
    }

    public void enable() {
        if (this.mEnabled) {
            return;
        }
        this.mEnabled = true;
        this.mDisplayOffset = this.findDisplayOffset();
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayManager manager = (DisplayManager)this.mContext.getSystemService("display");
            manager.registerDisplayListener(this.mDisplayOffsetListener, this.mHandler);
        }
        this.mDeviceOrientationListener.enable();
    }

    public void disable() {
        if (!this.mEnabled) {
            return;
        }
        this.mEnabled = false;
        this.mDeviceOrientationListener.disable();
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayManager manager = (DisplayManager)this.mContext.getSystemService("display");
            manager.unregisterDisplayListener(this.mDisplayOffsetListener);
        }
        this.mDisplayOffset = -1;
        this.mDeviceOrientation = -1;
    }

    public int getLastDeviceOrientation() {
        return this.mDeviceOrientation;
    }

    public int getLastDisplayOffset() {
        return this.mDisplayOffset;
    }

    private int findDisplayOffset() {
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        switch (display.getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static interface Callback {
        public void onDeviceOrientationChanged(int var1);

        public void onDisplayOffsetChanged();
    }
}

