/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.overlay;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.overlay.Overlay;

@SuppressLint(value={"CustomViewStyleable"})
public class OverlayLayout
extends FrameLayout
implements Overlay {
    private static final String TAG = OverlayLayout.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    @VisibleForTesting
    Overlay.Target currentTarget = Overlay.Target.PREVIEW;
    private boolean mHardwareCanvasEnabled;

    public OverlayLayout(@NonNull Context context) {
        super(context);
        this.setWillNotDraw(false);
    }

    public boolean isOverlay(@Nullable AttributeSet set) {
        if (set == null) {
            return false;
        }
        TypedArray a = this.getContext().obtainStyledAttributes(set, R.styleable.CameraView_Layout);
        boolean isOverlay = a.hasValue(R.styleable.CameraView_Layout_layout_drawOnPreview) || a.hasValue(R.styleable.CameraView_Layout_layout_drawOnPictureSnapshot) || a.hasValue(R.styleable.CameraView_Layout_layout_drawOnVideoSnapshot);
        a.recycle();
        return isOverlay;
    }

    public boolean isOverlay(@NonNull ViewGroup.LayoutParams params) {
        return params instanceof LayoutParams;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(Canvas canvas) {
        LOG.i("normal draw called.");
        if (this.drawsOn(Overlay.Target.PREVIEW)) {
            this.drawOn(Overlay.Target.PREVIEW, canvas);
        }
    }

    @Override
    public boolean drawsOn(@NonNull Overlay.Target target) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            LayoutParams params = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (!params.drawsOn(target)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setHardwareCanvasEnabled(boolean on) {
        this.mHardwareCanvasEnabled = on;
    }

    @Override
    public boolean getHardwareCanvasEnabled() {
        return this.mHardwareCanvasEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOn(@NonNull Overlay.Target target, @NonNull Canvas canvas) {
        OverlayLayout overlayLayout = this;
        synchronized (overlayLayout) {
            this.currentTarget = target;
            switch (target) {
                case PREVIEW: {
                    super.draw(canvas);
                    break;
                }
                case VIDEO_SNAPSHOT: 
                case PICTURE_SNAPSHOT: {
                    canvas.save();
                    float widthScale = (float)canvas.getWidth() / (float)this.getWidth();
                    float heightScale = (float)canvas.getHeight() / (float)this.getHeight();
                    LOG.v(new Object[]{"draw", "target:", target, "canvas:", canvas.getWidth() + "x" + canvas.getHeight(), "view:", this.getWidth() + "x" + this.getHeight(), "widthScale:", Float.valueOf(widthScale), "heightScale:", Float.valueOf(heightScale), "hardwareCanvasMode:", this.mHardwareCanvasEnabled});
                    canvas.scale(widthScale, heightScale);
                    this.dispatchDraw(canvas);
                    canvas.restore();
                }
            }
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        LayoutParams params = (LayoutParams)child.getLayoutParams();
        if (params.drawsOn(this.currentTarget)) {
            LOG.v(new Object[]{"Performing drawing for view:", child.getClass().getSimpleName(), "target:", this.currentTarget, "params:", params});
            return this.doDrawChild(canvas, child, drawingTime);
        }
        LOG.v(new Object[]{"Skipping drawing for view:", child.getClass().getSimpleName(), "target:", this.currentTarget, "params:", params});
        return false;
    }

    @VisibleForTesting
    boolean doDrawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public boolean drawOnPreview = false;
        public boolean drawOnPictureSnapshot = false;
        public boolean drawOnVideoSnapshot = false;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutParams(@NonNull Context context, @NonNull AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraView_Layout);
            try {
                this.drawOnPreview = a.getBoolean(R.styleable.CameraView_Layout_layout_drawOnPreview, false);
                this.drawOnPictureSnapshot = a.getBoolean(R.styleable.CameraView_Layout_layout_drawOnPictureSnapshot, false);
                this.drawOnVideoSnapshot = a.getBoolean(R.styleable.CameraView_Layout_layout_drawOnVideoSnapshot, false);
            }
            finally {
                a.recycle();
            }
        }

        @VisibleForTesting
        boolean drawsOn(@NonNull Overlay.Target target) {
            return target == Overlay.Target.PREVIEW && this.drawOnPreview || target == Overlay.Target.VIDEO_SNAPSHOT && this.drawOnVideoSnapshot || target == Overlay.Target.PICTURE_SNAPSHOT && this.drawOnPictureSnapshot;
        }

        @NonNull
        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[drawOnPreview:" + this.drawOnPreview + ",drawOnPictureSnapshot:" + this.drawOnPictureSnapshot + ",drawOnVideoSnapshot:" + this.drawOnVideoSnapshot + "]";
        }
    }
}

