/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.AttrRes;
import com.otaliastudios.zoom.AbsolutePoint;
import com.otaliastudios.zoom.OverPanRangeProvider;
import com.otaliastudios.zoom.OverZoomRangeProvider;
import com.otaliastudios.zoom.R;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomApi;
import com.otaliastudios.zoom.ZoomEngine;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010*\u001a\u00020\u0010H\u0096\u0001J\b\u0010+\u001a\u00020\bH\u0014J\b\u0010,\u001a\u00020\bH\u0014J\b\u0010-\u001a\u00020\bH\u0014J\b\u0010.\u001a\u00020\bH\u0014J\t\u0010/\u001a\u00020\u0019H\u0096\u0001J\t\u00100\u001a\u00020\bH\u0096\u0001J\t\u00101\u001a\u00020\u0019H\u0096\u0001J\t\u00102\u001a\u00020\bH\u0096\u0001J)\u00103\u001a\u0002042\u0006\u0010(\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001J\"\u00108\u001a\u0002042\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0014J(\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\bH\u0014J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020DH\u0017J!\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001J!\u0010H\u001a\u0002042\u0006\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001J\u0019\u0010I\u001a\u0002042\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010J\u001a\u0002042\u0006\u0010K\u001a\u00020\bH\u0096\u0001J\u0011\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010N\u001a\u0002042\u0006\u0010O\u001a\u00020PH\u0096\u0001J\u0011\u0010Q\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010S\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0012\u0010T\u001a\u0002042\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u0011\u0010W\u001a\u0002042\u0006\u0010X\u001a\u00020\u0019H\u0096\u0001J\u0019\u0010W\u001a\u0002042\u0006\u0010X\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\bH\u0096\u0001J\u0011\u0010Z\u001a\u0002042\u0006\u0010[\u001a\u00020\u0019H\u0096\u0001J\u0019\u0010Z\u001a\u0002042\u0006\u0010[\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\bH\u0096\u0001J\u0011\u0010\\\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010]\u001a\u0002042\u0006\u0010^\u001a\u00020_H\u0096\u0001J\u0011\u0010`\u001a\u0002042\u0006\u0010a\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010b\u001a\u0002042\u0006\u0010c\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010d\u001a\u0002042\u0006\u0010c\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010e\u001a\u0002042\u0006\u0010^\u001a\u00020fH\u0096\u0001J\u0011\u0010g\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010h\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010i\u001a\u0002042\u0006\u0010j\u001a\u00020\bH\u0096\u0001J\u0019\u0010i\u001a\u0002042\u0006\u0010j\u001a\u00020\b2\u0006\u0010k\u001a\u00020\bH\u0096\u0001J\u0011\u0010l\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010m\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010n\u001a\u0002042\u0006\u0010R\u001a\u00020\u0010H\u0096\u0001J\u0019\u0010o\u001a\u0002042\u0006\u0010p\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001J\t\u0010q\u001a\u000204H\u0096\u0001J\t\u0010r\u001a\u000204H\u0096\u0001J\u0019\u0010s\u001a\u0002042\u0006\u0010(\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0010H\u0096\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0012\u0010\u001e\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u0012\u0010&\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u0012\u0010(\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001b\u00a8\u0006t"}, d2={"Lcom/otaliastudios/zoom/ZoomImageView;", "Landroid/widget/ImageView;", "Lcom/otaliastudios/zoom/ZoomApi;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILcom/otaliastudios/zoom/ZoomEngine;)V", "getEngine", "()Lcom/otaliastudios/zoom/ZoomEngine;", "isInSharedElementTransition", "", "()Z", "mMatrix", "Landroid/graphics/Matrix;", "pan", "Lcom/otaliastudios/zoom/AbsolutePoint;", "getPan", "()Lcom/otaliastudios/zoom/AbsolutePoint;", "panX", "", "getPanX", "()F", "panY", "getPanY", "realZoom", "getRealZoom", "scaledPan", "Lcom/otaliastudios/zoom/ScaledPoint;", "getScaledPan", "()Lcom/otaliastudios/zoom/ScaledPoint;", "scaledPanX", "getScaledPanX", "scaledPanY", "getScaledPanY", "zoom", "getZoom", "cancelAnimations", "computeHorizontalScrollOffset", "computeHorizontalScrollRange", "computeVerticalScrollOffset", "computeVerticalScrollRange", "getMaxZoom", "getMaxZoomType", "getMinZoom", "getMinZoomType", "moveTo", "", "x", "y", "animate", "moveToCenter", "(Ljava/lang/Float;Z)V", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "panBy", "dx", "dy", "panTo", "realZoomTo", "setAlignment", "alignment", "setAllowFlingInOverscroll", "allow", "setAnimationDuration", "duration", "", "setFlingEnabled", "enabled", "setHorizontalPanEnabled", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setMaxZoom", "maxZoom", "type", "setMinZoom", "minZoom", "setOneFingerScrollEnabled", "setOverPanRange", "provider", "Lcom/otaliastudios/zoom/OverPanRangeProvider;", "setOverPinchable", "overPinchable", "setOverScrollHorizontal", "overScroll", "setOverScrollVertical", "setOverZoomRange", "Lcom/otaliastudios/zoom/OverZoomRangeProvider;", "setScrollEnabled", "setThreeFingersScrollEnabled", "setTransformation", "transformation", "gravity", "setTwoFingersScrollEnabled", "setVerticalPanEnabled", "setZoomEnabled", "zoomBy", "zoomFactor", "zoomIn", "zoomOut", "zoomTo", "library_release"})
@SuppressLint(value={"AppCompatCustomView"})
public class ZoomImageView
extends ImageView
implements ZoomApi {
    @NotNull
    private final ZoomEngine engine;
    @NotNull
    private final Matrix mMatrix;

    private ZoomImageView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, ZoomEngine engine) {
        super(context, attrs, defStyleAttr);
        this.engine = engine;
        this.mMatrix = new Matrix();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ZoomEngine, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.ZoomEngine, defStyleAttr, 0)");
        TypedArray a = typedArray;
        boolean overScrollHorizontal = a.getBoolean(R.styleable.ZoomEngine_overScrollHorizontal, true);
        boolean overScrollVertical = a.getBoolean(R.styleable.ZoomEngine_overScrollVertical, true);
        boolean horizontalPanEnabled = a.getBoolean(R.styleable.ZoomEngine_horizontalPanEnabled, true);
        boolean verticalPanEnabled = a.getBoolean(R.styleable.ZoomEngine_verticalPanEnabled, true);
        boolean overPinchable = a.getBoolean(R.styleable.ZoomEngine_overPinchable, true);
        boolean zoomEnabled = a.getBoolean(R.styleable.ZoomEngine_zoomEnabled, true);
        boolean flingEnabled = a.getBoolean(R.styleable.ZoomEngine_flingEnabled, true);
        boolean scrollEnabled = a.getBoolean(R.styleable.ZoomEngine_scrollEnabled, true);
        boolean oneFingerScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_oneFingerScrollEnabled, true);
        boolean twoFingersScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_twoFingersScrollEnabled, true);
        boolean threeFingersScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_threeFingersScrollEnabled, true);
        boolean allowFlingInOverscroll = a.getBoolean(R.styleable.ZoomEngine_allowFlingInOverscroll, true);
        float minZoom = a.getFloat(R.styleable.ZoomEngine_minZoom, 0.8f);
        float maxZoom = a.getFloat(R.styleable.ZoomEngine_maxZoom, 2.5f);
        int minZoomMode = a.getInteger(R.styleable.ZoomEngine_minZoomType, 0);
        int maxZoomMode = a.getInteger(R.styleable.ZoomEngine_maxZoomType, 0);
        int transformation = a.getInteger(R.styleable.ZoomEngine_transformation, 0);
        int transformationGravity = a.getInt(R.styleable.ZoomEngine_transformationGravity, 0);
        int alignment = a.getInt(R.styleable.ZoomEngine_alignment, 51);
        long animationDuration = a.getInt(R.styleable.ZoomEngine_animationDuration, 280);
        a.recycle();
        this.engine.setContainer((View)this);
        this.engine.addListener(new ZoomEngine.Listener(){

            @Override
            public void onIdle(@NotNull ZoomEngine engine) {
                Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            }

            @Override
            public void onUpdate(@NotNull ZoomEngine engine, @NotNull Matrix matrix) {
                Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
                Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
                mMatrix.set(matrix);
                this.setImageMatrix(mMatrix);
                this.awakenScrollBars();
            }
        });
        this.setTransformation(transformation, transformationGravity);
        this.setAlignment(alignment);
        this.setOverScrollHorizontal(overScrollHorizontal);
        this.setOverScrollVertical(overScrollVertical);
        this.setHorizontalPanEnabled(horizontalPanEnabled);
        this.setVerticalPanEnabled(verticalPanEnabled);
        this.setOverPinchable(overPinchable);
        this.setZoomEnabled(zoomEnabled);
        this.setFlingEnabled(flingEnabled);
        this.setScrollEnabled(scrollEnabled);
        this.setOneFingerScrollEnabled(oneFingerScrollEnabled);
        this.setTwoFingersScrollEnabled(twoFingersScrollEnabled);
        this.setThreeFingersScrollEnabled(threeFingersScrollEnabled);
        this.setAllowFlingInOverscroll(allowFlingInOverscroll);
        this.setAnimationDuration(animationDuration);
        this.setMinZoom(minZoom, minZoomMode);
        this.setMaxZoom(maxZoom, maxZoomMode);
        this.setImageMatrix(this.mMatrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    /* synthetic */ ZoomImageView(Context context, AttributeSet attributeSet, int n, ZoomEngine zoomEngine, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            zoomEngine = new ZoomEngine(context);
        }
        this(context, attributeSet, n, zoomEngine);
    }

    @NotNull
    public final ZoomEngine getEngine() {
        return this.engine;
    }

    @Override
    public float getPanX() {
        return this.engine.getPanX();
    }

    @Override
    public float getPanY() {
        return this.engine.getPanY();
    }

    @Override
    public float getRealZoom() {
        return this.engine.getRealZoom();
    }

    @Override
    public float getScaledPanX() {
        return this.engine.getScaledPanX();
    }

    @Override
    public float getScaledPanY() {
        return this.engine.getScaledPanY();
    }

    @Override
    public float getZoom() {
        return this.engine.getZoom();
    }

    @Override
    public int getMaxZoomType() {
        return this.engine.getMaxZoomType();
    }

    @Override
    public int getMinZoomType() {
        return this.engine.getMinZoomType();
    }

    @Override
    public boolean cancelAnimations() {
        return this.engine.cancelAnimations();
    }

    @Override
    public float getMaxZoom() {
        return this.engine.getMaxZoom();
    }

    @Override
    public float getMinZoom() {
        return this.engine.getMinZoom();
    }

    @Override
    public void moveTo(float zoom, float x, float y, boolean animate) {
        this.engine.moveTo(zoom, x, y, animate);
    }

    @Override
    public void moveToCenter(@Nullable Float zoom, boolean animate) {
        this.engine.moveToCenter(zoom, animate);
    }

    @Override
    public void panBy(float dx, float dy, boolean animate) {
        this.engine.panBy(dx, dy, animate);
    }

    @Override
    public void panTo(float x, float y, boolean animate) {
        this.engine.panTo(x, y, animate);
    }

    @Override
    public void realZoomTo(float realZoom, boolean animate) {
        this.engine.realZoomTo(realZoom, animate);
    }

    @Override
    public void setAlignment(int alignment) {
        this.engine.setAlignment(alignment);
    }

    @Override
    public void setAllowFlingInOverscroll(boolean allow) {
        this.engine.setAllowFlingInOverscroll(allow);
    }

    @Override
    public void setAnimationDuration(long duration) {
        this.engine.setAnimationDuration(duration);
    }

    @Override
    public void setFlingEnabled(boolean enabled) {
        this.engine.setFlingEnabled(enabled);
    }

    @Override
    public void setHorizontalPanEnabled(boolean enabled) {
        this.engine.setHorizontalPanEnabled(enabled);
    }

    @Override
    public void setMaxZoom(float maxZoom) {
        this.engine.setMaxZoom(maxZoom);
    }

    @Override
    public void setMaxZoom(float maxZoom, int type) {
        this.engine.setMaxZoom(maxZoom, type);
    }

    @Override
    public void setMinZoom(float minZoom) {
        this.engine.setMinZoom(minZoom);
    }

    @Override
    public void setMinZoom(float minZoom, int type) {
        this.engine.setMinZoom(minZoom, type);
    }

    @Override
    public void setOneFingerScrollEnabled(boolean enabled) {
        this.engine.setOneFingerScrollEnabled(enabled);
    }

    @Override
    public void setOverPanRange(@NotNull OverPanRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.engine.setOverPanRange(provider);
    }

    @Override
    public void setOverPinchable(boolean overPinchable) {
        this.engine.setOverPinchable(overPinchable);
    }

    @Override
    public void setOverScrollHorizontal(boolean overScroll) {
        this.engine.setOverScrollHorizontal(overScroll);
    }

    @Override
    public void setOverScrollVertical(boolean overScroll) {
        this.engine.setOverScrollVertical(overScroll);
    }

    @Override
    public void setOverZoomRange(@NotNull OverZoomRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.engine.setOverZoomRange(provider);
    }

    @Override
    public void setScrollEnabled(boolean enabled) {
        this.engine.setScrollEnabled(enabled);
    }

    @Override
    public void setThreeFingersScrollEnabled(boolean enabled) {
        this.engine.setThreeFingersScrollEnabled(enabled);
    }

    @Override
    public void setTransformation(int transformation) {
        this.engine.setTransformation(transformation);
    }

    @Override
    public void setTransformation(int transformation, int gravity) {
        this.engine.setTransformation(transformation, gravity);
    }

    @Override
    public void setTwoFingersScrollEnabled(boolean enabled) {
        this.engine.setTwoFingersScrollEnabled(enabled);
    }

    @Override
    public void setVerticalPanEnabled(boolean enabled) {
        this.engine.setVerticalPanEnabled(enabled);
    }

    @Override
    public void setZoomEnabled(boolean enabled) {
        this.engine.setZoomEnabled(enabled);
    }

    @Override
    public void zoomBy(float zoomFactor, boolean animate) {
        this.engine.zoomBy(zoomFactor, animate);
    }

    @Override
    public void zoomIn() {
        this.engine.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.engine.zoomOut();
    }

    @Override
    public void zoomTo(float zoom, boolean animate) {
        this.engine.zoomTo(zoom, animate);
    }

    @Override
    @NotNull
    public AbsolutePoint getPan() {
        return this.engine.getPan();
    }

    @Override
    @NotNull
    public ScaledPoint getScaledPan() {
        return this.engine.getScaledPan();
    }

    @JvmOverloads
    public ZoomImageView(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, new ZoomEngine(context));
    }

    public /* synthetic */ ZoomImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final boolean isInSharedElementTransition() {
        return this.getWidth() != this.getMeasuredWidth() || this.getHeight() != this.getMeasuredHeight();
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        if (drawable != null) {
            if (drawable.getIntrinsicWidth() == -1 || drawable.getIntrinsicHeight() == -1) {
                throw new IllegalArgumentException("Drawables without intrinsic dimensions (such as a solid color) are not supported");
            }
            ZoomEngine.setContentSize$default(this.engine, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), false, 4, null);
        }
        super.setImageDrawable(drawable);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.engine.onTouchEvent(ev) | super.onTouchEvent(ev);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.engine.setContainerSize(this.getWidth(), this.getHeight(), true);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.isInSharedElementTransition()) {
            this.setImageMatrix(this.mMatrix);
        }
        super.onDraw(canvas);
    }

    protected int computeHorizontalScrollOffset() {
        return this.engine.computeHorizontalScrollOffset();
    }

    protected int computeHorizontalScrollRange() {
        return this.engine.computeHorizontalScrollRange();
    }

    protected int computeVerticalScrollOffset() {
        return this.engine.computeVerticalScrollOffset();
    }

    protected int computeVerticalScrollRange() {
        return this.engine.computeVerticalScrollRange();
    }

    @JvmOverloads
    public ZoomImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ZoomImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

