/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import com.otaliastudios.opengl.core.EglConfigChooser;
import com.otaliastudios.opengl.core.EglContextFactory;
import com.otaliastudios.opengl.draw.GlDrawable;
import com.otaliastudios.opengl.draw.GlRect;
import com.otaliastudios.opengl.extensions.MatrixKt;
import com.otaliastudios.opengl.program.GlFlatProgram;
import com.otaliastudios.opengl.program.GlProgram;
import com.otaliastudios.opengl.program.GlTextureProgram;
import com.otaliastudios.opengl.texture.GlTexture;
import com.otaliastudios.zoom.AbsolutePoint;
import com.otaliastudios.zoom.OverPanRangeProvider;
import com.otaliastudios.zoom.OverZoomRangeProvider;
import com.otaliastudios.zoom.R;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomApi;
import com.otaliastudios.zoom.ZoomEngine;
import com.otaliastudios.zoom.ZoomLogger;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0017\u0018\u0000 \u0093\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0004\u0092\u0001\u0093\u0001B\u001b\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0010J\t\u0010A\u001a\u00020\u0012H\u0096\u0001J\t\u0010B\u001a\u00020\"H\u0096\u0001J\t\u0010C\u001a\u00020\rH\u0096\u0001J\t\u0010D\u001a\u00020\"H\u0096\u0001J\t\u0010E\u001a\u00020\rH\u0096\u0001J)\u0010F\u001a\u00020?2\u0006\u0010<\u001a\u00020\"2\u0006\u0010G\u001a\u00020\"2\u0006\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001J\"\u0010J\u001a\u00020?2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001\u00a2\u0006\u0002\u0010KJ\b\u0010L\u001a\u00020?H\u0002J\b\u0010M\u001a\u00020?H\u0014J\u0018\u0010N\u001a\u00020?2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020PH\u0015J\u0010\u0010R\u001a\u00020?2\u0006\u0010S\u001a\u00020TH\u0017J\u0018\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\rH\u0014J \u0010X\u001a\u00020?2\u0006\u0010S\u001a\u00020T2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\rH\u0017J\u001c\u0010[\u001a\u00020?2\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0017J\u0010\u0010^\u001a\u00020\u00122\u0006\u0010_\u001a\u00020`H\u0017J!\u0010a\u001a\u00020?2\u0006\u0010b\u001a\u00020\"2\u0006\u0010c\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001J!\u0010d\u001a\u00020?2\u0006\u0010G\u001a\u00020\"2\u0006\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001J\u0019\u0010e\u001a\u00020?2\u0006\u0010'\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001J\b\u0010f\u001a\u00020?H\u0003J\u000e\u0010g\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0010J\u0011\u0010h\u001a\u00020?2\u0006\u0010i\u001a\u00020\rH\u0096\u0001J\u0011\u0010j\u001a\u00020?2\u0006\u0010k\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010l\u001a\u00020?2\u0006\u0010m\u001a\u00020nH\u0096\u0001J\u0010\u0010o\u001a\u00020?2\u0006\u0010p\u001a\u00020\rH\u0016J\u0016\u0010q\u001a\u00020?2\u0006\u0010Y\u001a\u00020\"2\u0006\u0010Z\u001a\u00020\"J\u0011\u0010r\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010t\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010u\u001a\u00020?2\u0006\u0010v\u001a\u00020\"H\u0096\u0001J\u0019\u0010u\u001a\u00020?2\u0006\u0010v\u001a\u00020\"2\u0006\u0010w\u001a\u00020\rH\u0096\u0001J\u0011\u0010x\u001a\u00020?2\u0006\u0010y\u001a\u00020\"H\u0096\u0001J\u0019\u0010x\u001a\u00020?2\u0006\u0010y\u001a\u00020\"2\u0006\u0010w\u001a\u00020\rH\u0096\u0001J\u0011\u0010z\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010{\u001a\u00020?2\u0006\u0010|\u001a\u00020}H\u0096\u0001J\u0011\u0010~\u001a\u00020?2\u0006\u0010\u007f\u001a\u00020\u0012H\u0096\u0001J\u0013\u0010\u0080\u0001\u001a\u00020?2\u0007\u0010\u0081\u0001\u001a\u00020\u0012H\u0096\u0001J\u0013\u0010\u0082\u0001\u001a\u00020?2\u0007\u0010\u0081\u0001\u001a\u00020\u0012H\u0096\u0001J\u0013\u0010\u0083\u0001\u001a\u00020?2\u0007\u0010|\u001a\u00030\u0084\u0001H\u0096\u0001J\u0012\u0010\u0085\u0001\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0012\u0010\u0086\u0001\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0013\u0010\u0087\u0001\u001a\u00020?2\u0007\u0010\u0088\u0001\u001a\u00020\rH\u0096\u0001J\u001c\u0010\u0087\u0001\u001a\u00020?2\u0007\u0010\u0088\u0001\u001a\u00020\r2\u0007\u0010\u0089\u0001\u001a\u00020\rH\u0096\u0001J\u0012\u0010\u008a\u0001\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0012\u0010\u008b\u0001\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u0012\u0010\u008c\u0001\u001a\u00020?2\u0006\u0010s\u001a\u00020\u0012H\u0096\u0001J\u001b\u0010\u008d\u0001\u001a\u00020?2\u0007\u0010\u008e\u0001\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001J\n\u0010\u008f\u0001\u001a\u00020?H\u0096\u0001J\n\u0010\u0090\u0001\u001a\u00020?H\u0096\u0001J\u001a\u0010\u0091\u0001\u001a\u00020?2\u0006\u0010<\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u0012H\u0096\u0001R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0012\u0010'\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010$R\u0012\u0010)\u001a\u00020*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010$R\u0012\u0010/\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u0010$R\"\u00103\u001a\u0004\u0018\u0001022\b\u00101\u001a\u0004\u0018\u000102@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R(\u00107\u001a\u0004\u0018\u0001062\b\u00101\u001a\u0004\u0018\u000106@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u0010$\u00a8\u0006\u0094\u0001"}, d2={"Lcom/otaliastudios/zoom/ZoomSurfaceView;", "Landroid/opengl/GLSurfaceView;", "Lcom/otaliastudios/zoom/ZoomApi;", "Landroid/opengl/GLSurfaceView$Renderer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "(Landroid/content/Context;Landroid/util/AttributeSet;Lcom/otaliastudios/zoom/ZoomEngine;)V", "backgroundColor", "", "callbacks", "", "Lcom/otaliastudios/zoom/ZoomSurfaceView$Callback;", "drawsBackgroundColor", "", "getEngine", "()Lcom/otaliastudios/zoom/ZoomEngine;", "glFlatProgram", "Lcom/otaliastudios/opengl/program/GlFlatProgram;", "glFlatRect", "Lcom/otaliastudios/opengl/draw/GlRect;", "glTextureProgram", "Lcom/otaliastudios/opengl/program/GlTextureProgram;", "glTextureRect", "hasExplicitContentSize", "pan", "Lcom/otaliastudios/zoom/AbsolutePoint;", "getPan", "()Lcom/otaliastudios/zoom/AbsolutePoint;", "panX", "", "getPanX", "()F", "panY", "getPanY", "realZoom", "getRealZoom", "scaledPan", "Lcom/otaliastudios/zoom/ScaledPoint;", "getScaledPan", "()Lcom/otaliastudios/zoom/ScaledPoint;", "scaledPanX", "getScaledPanX", "scaledPanY", "getScaledPanY", "<set-?>", "Landroid/view/Surface;", "surface", "getSurface", "()Landroid/view/Surface;", "Landroid/graphics/SurfaceTexture;", "surfaceTexture", "getSurfaceTexture$annotations", "()V", "getSurfaceTexture", "()Landroid/graphics/SurfaceTexture;", "zoom", "getZoom", "addCallback", "", "callback", "cancelAnimations", "getMaxZoom", "getMaxZoomType", "getMinZoom", "getMinZoomType", "moveTo", "x", "y", "animate", "moveToCenter", "(Ljava/lang/Float;Z)V", "onContentOrContainerSizeChanged", "onDetachedFromWindow", "onDraw", "modelMatrix", "", "textureTransformMatrix", "onDrawFrame", "gl", "Ljavax/microedition/khronos/opengles/GL10;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSurfaceChanged", "width", "height", "onSurfaceCreated", "config", "Ljavax/microedition/khronos/egl/EGLConfig;", "onTouchEvent", "ev", "Landroid/view/MotionEvent;", "panBy", "dx", "dy", "panTo", "realZoomTo", "releaseCurrentSurface", "removeCallback", "setAlignment", "alignment", "setAllowFlingInOverscroll", "allow", "setAnimationDuration", "duration", "", "setBackgroundColor", "color", "setContentSize", "setFlingEnabled", "enabled", "setHorizontalPanEnabled", "setMaxZoom", "maxZoom", "type", "setMinZoom", "minZoom", "setOneFingerScrollEnabled", "setOverPanRange", "provider", "Lcom/otaliastudios/zoom/OverPanRangeProvider;", "setOverPinchable", "overPinchable", "setOverScrollHorizontal", "overScroll", "setOverScrollVertical", "setOverZoomRange", "Lcom/otaliastudios/zoom/OverZoomRangeProvider;", "setScrollEnabled", "setThreeFingersScrollEnabled", "setTransformation", "transformation", "gravity", "setTwoFingersScrollEnabled", "setVerticalPanEnabled", "setZoomEnabled", "zoomBy", "zoomFactor", "zoomIn", "zoomOut", "zoomTo", "Callback", "Companion", "library_release"})
@RequiresApi(value=18)
public class ZoomSurfaceView
extends GLSurfaceView
implements ZoomApi,
GLSurfaceView.Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomEngine engine;
    @NotNull
    private final List<Callback> callbacks;
    @Nullable
    private Surface surface;
    @Nullable
    private SurfaceTexture surfaceTexture;
    @NotNull
    private final GlRect glTextureRect;
    @NotNull
    private final GlRect glFlatRect;
    @Nullable
    private GlTextureProgram glTextureProgram;
    @Nullable
    private GlFlatProgram glFlatProgram;
    private int backgroundColor;
    private boolean drawsBackgroundColor;
    private boolean hasExplicitContentSize;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;
    private static final int EGLOO_DRAWABLE_FULL_SIZE = 2;
    private static final float EGLOO_DRAWABLE_TOPLEFT_X = -1.0f;
    private static final float EGLOO_DRAWABLE_TOPLEFT_Y = 1.0f;

    private ZoomSurfaceView(Context context, AttributeSet attrs, ZoomEngine engine) {
        super(context, attrs);
        this.engine = engine;
        boolean bl = false;
        this.callbacks = new ArrayList();
        this.glTextureRect = new GlRect();
        this.glFlatRect = new GlRect();
        this.backgroundColor = Color.rgb((int)25, (int)25, (int)25);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ZoomEngine, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.ZoomEngine, 0, 0)");
        TypedArray a = typedArray;
        boolean overScrollHorizontal = a.getBoolean(R.styleable.ZoomEngine_overScrollHorizontal, false);
        boolean overScrollVertical = a.getBoolean(R.styleable.ZoomEngine_overScrollVertical, false);
        boolean horizontalPanEnabled = a.getBoolean(R.styleable.ZoomEngine_horizontalPanEnabled, true);
        boolean verticalPanEnabled = a.getBoolean(R.styleable.ZoomEngine_verticalPanEnabled, true);
        boolean overPinchable = a.getBoolean(R.styleable.ZoomEngine_overPinchable, false);
        boolean zoomEnabled = a.getBoolean(R.styleable.ZoomEngine_zoomEnabled, true);
        boolean flingEnabled = a.getBoolean(R.styleable.ZoomEngine_flingEnabled, true);
        boolean scrollEnabled = a.getBoolean(R.styleable.ZoomEngine_scrollEnabled, true);
        boolean oneFingerScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_oneFingerScrollEnabled, true);
        boolean twoFingersScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_twoFingersScrollEnabled, true);
        boolean threeFingersScrollEnabled = a.getBoolean(R.styleable.ZoomEngine_threeFingersScrollEnabled, true);
        boolean allowFlingInOverscroll = a.getBoolean(R.styleable.ZoomEngine_allowFlingInOverscroll, true);
        float minZoom = a.getFloat(R.styleable.ZoomEngine_minZoom, 1.0f);
        float maxZoom = a.getFloat(R.styleable.ZoomEngine_maxZoom, 2.5f);
        int minZoomMode = a.getInteger(R.styleable.ZoomEngine_minZoomType, 0);
        int maxZoomMode = a.getInteger(R.styleable.ZoomEngine_maxZoomType, 0);
        int transformation = a.getInteger(R.styleable.ZoomEngine_transformation, 0);
        int transformationGravity = a.getInt(R.styleable.ZoomEngine_transformationGravity, 0);
        int alignment = a.getInt(R.styleable.ZoomEngine_alignment, 51);
        long animationDuration = a.getInt(R.styleable.ZoomEngine_animationDuration, 280);
        a.recycle();
        this.engine.setContainer((View)this);
        this.engine.addListener(new ZoomEngine.Listener(){

            @Override
            public void onUpdate(@NotNull ZoomEngine engine, @NotNull Matrix matrix) {
                Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
                Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
                this.requestRender();
            }

            @Override
            public void onIdle(@NotNull ZoomEngine engine) {
                Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            }
        });
        this.setOverScrollHorizontal(overScrollHorizontal);
        this.setOverScrollVertical(overScrollVertical);
        this.setTransformation(transformation, transformationGravity);
        this.setAlignment(alignment);
        this.setHorizontalPanEnabled(horizontalPanEnabled);
        this.setVerticalPanEnabled(verticalPanEnabled);
        this.setOverPinchable(overPinchable);
        this.setZoomEnabled(zoomEnabled);
        this.setFlingEnabled(flingEnabled);
        this.setScrollEnabled(scrollEnabled);
        this.setOneFingerScrollEnabled(oneFingerScrollEnabled);
        this.setTwoFingersScrollEnabled(twoFingersScrollEnabled);
        this.setThreeFingersScrollEnabled(threeFingersScrollEnabled);
        this.setAllowFlingInOverscroll(allowFlingInOverscroll);
        this.setAnimationDuration(animationDuration);
        this.setMinZoom(minZoom, minZoomMode);
        this.setMaxZoom(maxZoom, maxZoomMode);
        this.setEGLContextFactory(EglContextFactory.GLES2);
        this.setEGLConfigChooser(EglConfigChooser.GLES2);
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    /* synthetic */ ZoomSurfaceView(Context context, AttributeSet attributeSet, ZoomEngine zoomEngine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            zoomEngine = new ZoomEngine(context);
        }
        this(context, attributeSet, zoomEngine);
    }

    @NotNull
    public final ZoomEngine getEngine() {
        return this.engine;
    }

    @Override
    public float getPanX() {
        return this.engine.getPanX();
    }

    @Override
    public float getPanY() {
        return this.engine.getPanY();
    }

    @Override
    public float getRealZoom() {
        return this.engine.getRealZoom();
    }

    @Override
    public float getScaledPanX() {
        return this.engine.getScaledPanX();
    }

    @Override
    public float getScaledPanY() {
        return this.engine.getScaledPanY();
    }

    @Override
    public float getZoom() {
        return this.engine.getZoom();
    }

    @Override
    public int getMaxZoomType() {
        return this.engine.getMaxZoomType();
    }

    @Override
    public int getMinZoomType() {
        return this.engine.getMinZoomType();
    }

    @Override
    public boolean cancelAnimations() {
        return this.engine.cancelAnimations();
    }

    @Override
    public float getMaxZoom() {
        return this.engine.getMaxZoom();
    }

    @Override
    public float getMinZoom() {
        return this.engine.getMinZoom();
    }

    @Override
    public void moveTo(float zoom, float x, float y, boolean animate) {
        this.engine.moveTo(zoom, x, y, animate);
    }

    @Override
    public void moveToCenter(@Nullable Float zoom, boolean animate) {
        this.engine.moveToCenter(zoom, animate);
    }

    @Override
    public void panBy(float dx, float dy, boolean animate) {
        this.engine.panBy(dx, dy, animate);
    }

    @Override
    public void panTo(float x, float y, boolean animate) {
        this.engine.panTo(x, y, animate);
    }

    @Override
    public void realZoomTo(float realZoom, boolean animate) {
        this.engine.realZoomTo(realZoom, animate);
    }

    @Override
    public void setAlignment(int alignment) {
        this.engine.setAlignment(alignment);
    }

    @Override
    public void setAllowFlingInOverscroll(boolean allow) {
        this.engine.setAllowFlingInOverscroll(allow);
    }

    @Override
    public void setAnimationDuration(long duration) {
        this.engine.setAnimationDuration(duration);
    }

    @Override
    public void setFlingEnabled(boolean enabled) {
        this.engine.setFlingEnabled(enabled);
    }

    @Override
    public void setHorizontalPanEnabled(boolean enabled) {
        this.engine.setHorizontalPanEnabled(enabled);
    }

    @Override
    public void setMaxZoom(float maxZoom) {
        this.engine.setMaxZoom(maxZoom);
    }

    @Override
    public void setMaxZoom(float maxZoom, int type) {
        this.engine.setMaxZoom(maxZoom, type);
    }

    @Override
    public void setMinZoom(float minZoom) {
        this.engine.setMinZoom(minZoom);
    }

    @Override
    public void setMinZoom(float minZoom, int type) {
        this.engine.setMinZoom(minZoom, type);
    }

    @Override
    public void setOneFingerScrollEnabled(boolean enabled) {
        this.engine.setOneFingerScrollEnabled(enabled);
    }

    @Override
    public void setOverPanRange(@NotNull OverPanRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.engine.setOverPanRange(provider);
    }

    @Override
    public void setOverPinchable(boolean overPinchable) {
        this.engine.setOverPinchable(overPinchable);
    }

    @Override
    public void setOverScrollHorizontal(boolean overScroll) {
        this.engine.setOverScrollHorizontal(overScroll);
    }

    @Override
    public void setOverScrollVertical(boolean overScroll) {
        this.engine.setOverScrollVertical(overScroll);
    }

    @Override
    public void setOverZoomRange(@NotNull OverZoomRangeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.engine.setOverZoomRange(provider);
    }

    @Override
    public void setScrollEnabled(boolean enabled) {
        this.engine.setScrollEnabled(enabled);
    }

    @Override
    public void setThreeFingersScrollEnabled(boolean enabled) {
        this.engine.setThreeFingersScrollEnabled(enabled);
    }

    @Override
    public void setTransformation(int transformation) {
        this.engine.setTransformation(transformation);
    }

    @Override
    public void setTransformation(int transformation, int gravity) {
        this.engine.setTransformation(transformation, gravity);
    }

    @Override
    public void setTwoFingersScrollEnabled(boolean enabled) {
        this.engine.setTwoFingersScrollEnabled(enabled);
    }

    @Override
    public void setVerticalPanEnabled(boolean enabled) {
        this.engine.setVerticalPanEnabled(enabled);
    }

    @Override
    public void setZoomEnabled(boolean enabled) {
        this.engine.setZoomEnabled(enabled);
    }

    @Override
    public void zoomBy(float zoomFactor, boolean animate) {
        this.engine.zoomBy(zoomFactor, animate);
    }

    @Override
    public void zoomIn() {
        this.engine.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.engine.zoomOut();
    }

    @Override
    public void zoomTo(float zoom, boolean animate) {
        this.engine.zoomTo(zoom, animate);
    }

    @Override
    @NotNull
    public AbsolutePoint getPan() {
        return this.engine.getPan();
    }

    @Override
    @NotNull
    public ScaledPoint getScaledPan() {
        return this.engine.getScaledPan();
    }

    @JvmOverloads
    public ZoomSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, new ZoomEngine(context));
    }

    public /* synthetic */ ZoomSurfaceView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @Nullable
    public final Surface getSurface() {
        return this.surface;
    }

    @Nullable
    public final SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public static /* synthetic */ void getSurfaceTexture$annotations() {
    }

    public final void addCallback(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public final void removeCallback(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.remove(callback);
    }

    public void setBackgroundColor(int color) {
        this.drawsBackgroundColor = Color.alpha((int)color) > 0;
        this.backgroundColor = color;
        if (this.glFlatProgram != null) {
            GlFlatProgram glFlatProgram = this.glFlatProgram;
            Intrinsics.checkNotNull((Object)glFlatProgram);
            glFlatProgram.setColor(color);
        }
    }

    public final void setContentSize(float width, float height) {
        this.hasExplicitContentSize = true;
        if (!(this.engine.getContentWidth() == width) || !(this.engine.getContentHeight() == height)) {
            this.engine.setContentSize(width, height, true);
            this.onContentOrContainerSizeChanged();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return this.engine.onTouchEvent(ev) | super.onTouchEvent(ev);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean changed;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float width = this.getMeasuredWidth();
        float height = this.getMeasuredHeight();
        boolean bl = !(this.engine.getContainerWidth() == width) || !(this.engine.getContainerHeight() == height) ? true : (changed = false);
        if (changed) {
            this.engine.setContainerSize(width, height, true);
        }
        if (!this.hasExplicitContentSize) {
            boolean contentChanged;
            boolean bl2 = !(this.engine.getContentWidth() == width) || !(this.engine.getContentHeight() == height) ? true : (contentChanged = false);
            if (contentChanged) {
                this.engine.setContentSize(width, height, true);
            }
        }
        if (changed) {
            this.onContentOrContainerSizeChanged();
        }
    }

    private final void onContentOrContainerSizeChanged() {
        int fullSize = 2;
        float width = (float)fullSize * this.engine.getContentWidth() / this.engine.getContainerWidth();
        float height = (float)fullSize * this.engine.getContentHeight() / this.engine.getContainerHeight();
        RectF rect = new RectF(-1.0f, 1.0f, -1.0f + width, 1.0f - height);
        this.glTextureRect.setRect(rect);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"Recycle"})
    @WorkerThread
    public void onSurfaceCreated(@Nullable GL10 gl, @Nullable EGLConfig config) {
        void it;
        LOG.i$library_release("onSurfaceCreated");
        GlFlatProgram glFlatProgram = this.glFlatProgram = new GlFlatProgram();
        Intrinsics.checkNotNull((Object)glFlatProgram);
        glFlatProgram.setColor(this.backgroundColor);
        GlTextureProgram glTextureProgram = this.glTextureProgram = new GlTextureProgram(null, null, null, null, null, null, 63, null);
        Intrinsics.checkNotNull((Object)glTextureProgram);
        glTextureProgram.setTexture(new GlTexture(0, 0, null, 7, null));
        GlTextureProgram glTextureProgram2 = this.glTextureProgram;
        Intrinsics.checkNotNull((Object)glTextureProgram2);
        GlTexture glTexture = glTextureProgram2.getTexture();
        Intrinsics.checkNotNull((Object)glTexture);
        SurfaceTexture surfaceTexture = new SurfaceTexture(glTexture.getId());
        boolean bl = false;
        boolean bl2 = false;
        SurfaceTexture surfaceTexture2 = surfaceTexture;
        ZoomSurfaceView zoomSurfaceView = this;
        boolean bl3 = false;
        it.setOnFrameAvailableListener(arg_0 -> ZoomSurfaceView.onSurfaceCreated$lambda-1$lambda-0(this, arg_0));
        Unit unit = Unit.INSTANCE;
        zoomSurfaceView.surfaceTexture = surfaceTexture;
        this.post(() -> ZoomSurfaceView.onSurfaceCreated$lambda-3(this));
    }

    @WorkerThread
    public void onSurfaceChanged(@NotNull GL10 gl, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        gl.glViewport(0, 0, width, height);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.post(() -> ZoomSurfaceView.onDetachedFromWindow$lambda-4(this));
    }

    @UiThread
    private final void releaseCurrentSurface() {
        boolean hasSurface = this.surfaceTexture != null;
        SurfaceTexture surfaceTexture = this.surfaceTexture;
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
        surfaceTexture = this.glTextureProgram;
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
        surfaceTexture = this.glFlatProgram;
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
        surfaceTexture = this.surface;
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
        if (hasSurface) {
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Callback it = (Callback)element$iv;
                boolean bl = false;
                it.onZoomSurfaceDestroyed(this);
            }
        }
        this.surfaceTexture = null;
        this.glTextureProgram = null;
        this.glFlatProgram = null;
        this.surface = null;
    }

    @SuppressLint(value={"WrongCall"})
    @WorkerThread
    public void onDrawFrame(@NotNull GL10 gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        SurfaceTexture surfaceTexture = this.surfaceTexture;
        if (surfaceTexture == null) {
            return;
        }
        SurfaceTexture texture = surfaceTexture;
        GlTextureProgram glTextureProgram = this.glTextureProgram;
        if (glTextureProgram == null) {
            return;
        }
        GlTextureProgram textureProgram = glTextureProgram;
        GlFlatProgram glFlatProgram = this.glFlatProgram;
        if (glFlatProgram == null) {
            return;
        }
        GlFlatProgram flatProgram = glFlatProgram;
        texture.updateTexImage();
        texture.getTransformMatrix(textureProgram.getTextureTransform());
        LOG.i$library_release("onDrawFrame: zoom:" + this.engine.getRealZoom() + " panX:" + this.engine.getPanX() + " panY:" + this.engine.getPanY());
        float textureWidth = (float)2 * this.engine.getContentWidth() / this.engine.getContainerWidth();
        float textureHeight = (float)2 * this.engine.getContentHeight() / this.engine.getContainerHeight();
        float translX = textureWidth * (this.getPanX() / this.engine.getContentWidth());
        float translY = -textureHeight * (this.getPanY() / this.engine.getContentHeight());
        float scaleX = this.getRealZoom();
        float scaleY = this.getRealZoom();
        LOG.i$library_release("onDrawFrame: translX:" + translX + " translY:" + translY + " scaleX:" + scaleX + " scaleY:" + scaleY);
        float[] fArray = this.glTextureRect.getModelMatrix();
        boolean bl = false;
        boolean bl2 = false;
        float[] $this$onDrawFrame_u24lambda_u2d6 = fArray;
        boolean bl3 = false;
        MatrixKt.clear((float[])$this$onDrawFrame_u24lambda_u2d6);
        MatrixKt.translate$default((float[])$this$onDrawFrame_u24lambda_u2d6, (float)translX, (float)translY, (float)0.0f, (int)4, null);
        MatrixKt.translate$default((float[])$this$onDrawFrame_u24lambda_u2d6, (float)(-1.0f - translX), (float)(1.0f - translY), (float)0.0f, (int)4, null);
        MatrixKt.scale$default((float[])$this$onDrawFrame_u24lambda_u2d6, (float)scaleX, (float)scaleY, (float)0.0f, (int)4, null);
        MatrixKt.translate$default((float[])$this$onDrawFrame_u24lambda_u2d6, (float)(1.0f + translX), (float)(-1.0f + translY), (float)0.0f, (int)4, null);
        this.onDraw(this.glTextureRect.getModelMatrix(), textureProgram.getTextureTransform());
        if (this.drawsBackgroundColor) {
            GlProgram.draw$default((GlProgram)((GlProgram)flatProgram), (GlDrawable)((GlDrawable)this.glFlatRect), null, (int)2, null);
        } else {
            gl.glClear(16384);
        }
        GlProgram.draw$default((GlProgram)((GlProgram)textureProgram), (GlDrawable)((GlDrawable)this.glTextureRect), null, (int)2, null);
    }

    @WorkerThread
    protected void onDraw(@NotNull float[] modelMatrix, @NotNull float[] textureTransformMatrix) {
        Intrinsics.checkNotNullParameter((Object)modelMatrix, (String)"modelMatrix");
        Intrinsics.checkNotNullParameter((Object)textureTransformMatrix, (String)"textureTransformMatrix");
    }

    @JvmOverloads
    public ZoomSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void onSurfaceCreated$lambda-1$lambda-0(ZoomSurfaceView this$0, SurfaceTexture it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestRender();
    }

    private static final void onSurfaceCreated$lambda-3(ZoomSurfaceView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.surface = new Surface(this$0.getSurfaceTexture());
        Iterable $this$forEach$iv = this$0.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Callback it = (Callback)element$iv;
            boolean bl = false;
            it.onZoomSurfaceCreated(this$0);
        }
    }

    private static final void onDetachedFromWindow$lambda-4(ZoomSurfaceView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.releaseCurrentSurface();
    }

    static {
        String string = TAG = ZoomSurfaceView.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0007"}, d2={"Lcom/otaliastudios/zoom/ZoomSurfaceView$Callback;", "", "onZoomSurfaceCreated", "", "view", "Lcom/otaliastudios/zoom/ZoomSurfaceView;", "onZoomSurfaceDestroyed", "library_release"})
    public static interface Callback {
        @UiThread
        public void onZoomSurfaceCreated(@NotNull ZoomSurfaceView var1);

        @UiThread
        public void onZoomSurfaceDestroyed(@NotNull ZoomSurfaceView var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/otaliastudios/zoom/ZoomSurfaceView$Companion;", "", "()V", "EGLOO_DRAWABLE_FULL_SIZE", "", "EGLOO_DRAWABLE_TOPLEFT_X", "", "EGLOO_DRAWABLE_TOPLEFT_Y", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

