/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom.internal.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.otaliastudios.zoom.AbsolutePoint;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomLogger;
import com.otaliastudios.zoom.internal.StateController;
import com.otaliastudios.zoom.internal.matrix.MatrixController;
import com.otaliastudios.zoom.internal.matrix.MatrixUpdate;
import com.otaliastudios.zoom.internal.movement.PanManager;
import com.otaliastudios.zoom.internal.movement.ZoomManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/otaliastudios/zoom/internal/gestures/PinchDetector;", "Landroid/view/ScaleGestureDetector$OnScaleGestureListener;", "context", "Landroid/content/Context;", "zoomManager", "Lcom/otaliastudios/zoom/internal/movement/ZoomManager;", "panManager", "Lcom/otaliastudios/zoom/internal/movement/PanManager;", "stateController", "Lcom/otaliastudios/zoom/internal/StateController;", "matrixController", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController;", "(Landroid/content/Context;Lcom/otaliastudios/zoom/internal/movement/ZoomManager;Lcom/otaliastudios/zoom/internal/movement/PanManager;Lcom/otaliastudios/zoom/internal/StateController;Lcom/otaliastudios/zoom/internal/matrix/MatrixController;)V", "currentFocusOffset", "Lcom/otaliastudios/zoom/AbsolutePoint;", "detector", "Landroid/view/ScaleGestureDetector;", "initialFocusPoint", "computeZoomPivot", "Landroid/graphics/PointF;", "fixPan", "containerPointToContentPoint", "containerPoint", "contentPointToContainerPoint", "contentPoint", "handleOnScaleEnd", "", "maybeStart", "", "event", "Landroid/view/MotionEvent;", "maybeStart$library_release", "onScale", "onScaleBegin", "onScaleEnd", "Companion", "library_release"})
public final class PinchDetector
implements ScaleGestureDetector.OnScaleGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomManager zoomManager;
    @NotNull
    private final PanManager panManager;
    @NotNull
    private final StateController stateController;
    @NotNull
    private final MatrixController matrixController;
    @NotNull
    private final ScaleGestureDetector detector;
    @NotNull
    private final AbsolutePoint initialFocusPoint;
    @NotNull
    private final AbsolutePoint currentFocusOffset;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;

    public PinchDetector(@NotNull Context context, @NotNull ZoomManager zoomManager2, @NotNull PanManager panManager2, @NotNull StateController stateController, @NotNull MatrixController matrixController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)zoomManager2, (String)"zoomManager");
        Intrinsics.checkNotNullParameter((Object)panManager2, (String)"panManager");
        Intrinsics.checkNotNullParameter((Object)stateController, (String)"stateController");
        Intrinsics.checkNotNullParameter((Object)matrixController, (String)"matrixController");
        this.zoomManager = zoomManager2;
        this.panManager = panManager2;
        this.stateController = stateController;
        this.matrixController = matrixController;
        this.detector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        if (Build.VERSION.SDK_INT >= 19) {
            this.detector.setQuickScaleEnabled(false);
        }
        this.initialFocusPoint = new AbsolutePoint(Float.NaN, Float.NaN);
        this.currentFocusOffset = new AbsolutePoint(0.0f, 0.0f);
    }

    public final boolean maybeStart$library_release(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.detector.onTouchEvent(event);
    }

    public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        return true;
    }

    public boolean onScale(@NotNull ScaleGestureDetector detector) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        if (!this.zoomManager.isEnabled()) {
            return false;
        }
        if (!this.stateController.setPinching$library_release()) {
            return false;
        }
        AbsolutePoint newAbsFocusPoint = this.containerPointToContentPoint(new PointF(-detector.getFocusX(), -detector.getFocusY()));
        float f = this.initialFocusPoint.getX();
        boolean bl = false;
        if (Float.isNaN(f)) {
            this.initialFocusPoint.set(newAbsFocusPoint);
            objectArray = new Object[]{"onScale:", "Setting initial focus:", this.initialFocusPoint};
            LOG.i$library_release(objectArray);
        } else {
            this.currentFocusOffset.set(this.initialFocusPoint.minus(newAbsFocusPoint));
            objectArray = new Object[]{"onScale:", "Got focus offset:", this.currentFocusOffset};
            LOG.i$library_release(objectArray);
        }
        float newZoom = this.matrixController.getZoom$library_release() * detector.getScaleFactor();
        this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(newZoom, this, detector){
            final /* synthetic */ float $newZoom;
            final /* synthetic */ PinchDetector this$0;
            final /* synthetic */ ScaleGestureDetector $detector;
            {
                this.$newZoom = $newZoom;
                this.this$0 = $receiver;
                this.$detector = $detector;
                super(1);
            }

            public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                $this$applyUpdate.zoomTo$library_release(this.$newZoom, true);
                $this$applyUpdate.panBy$library_release(PinchDetector.access$getCurrentFocusOffset$p(this.this$0), true);
                $this$applyUpdate.pivot$library_release(Float.valueOf(this.$detector.getFocusX()), Float.valueOf(this.$detector.getFocusY()));
            }
        }));
        return true;
    }

    public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        Object[] objectArray = new Object[]{"onScaleEnd:", "mInitialAbsFocusPoint.x:", Float.valueOf(this.initialFocusPoint.getX()), "mInitialAbsFocusPoint.y:", Float.valueOf(this.initialFocusPoint.getY()), "mOverZoomEnabled;", this.zoomManager.isOverEnabled()};
        LOG.i$library_release(objectArray);
        this.handleOnScaleEnd();
        this.initialFocusPoint.set(Float.valueOf(Float.NaN), Float.valueOf(Float.NaN));
        this.currentFocusOffset.set(Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    private final void handleOnScaleEnd() {
        if (!this.zoomManager.isOverEnabled() && !this.panManager.isOverEnabled()) {
            this.stateController.makeIdle$library_release();
            return;
        }
        float maxZoom = this.zoomManager.getMaxZoom$library_release();
        float minZoom = this.zoomManager.getMinZoom$library_release();
        float newZoom = this.zoomManager.checkBounds$library_release(this.matrixController.getZoom$library_release(), false);
        Object[] objectArray = new Object[]{"onScaleEnd:", "zoom:", Float.valueOf(this.matrixController.getZoom$library_release()), "newZoom:", Float.valueOf(newZoom), "max:", Float.valueOf(maxZoom), "min:", Float.valueOf(minZoom)};
        LOG.i$library_release(objectArray);
        AbsolutePoint panFix = ScaledPoint.toAbsolute$library_release$default(this.panManager.getCorrection$library_release(), this.matrixController.getZoom$library_release(), null, 2, null);
        if (panFix.getX() == 0.0f && panFix.getY() == 0.0f && Float.compare(newZoom, this.matrixController.getZoom$library_release()) == 0) {
            this.stateController.makeIdle$library_release();
            return;
        }
        PointF zoomTarget = this.computeZoomPivot(panFix);
        AbsolutePoint newPan = this.matrixController.getPan$library_release().plus(panFix);
        if (Float.compare(newZoom, this.matrixController.getZoom$library_release()) != 0) {
            AbsolutePoint oldPan = new AbsolutePoint(this.matrixController.getPan$library_release());
            float oldZoom = this.matrixController.getZoom$library_release();
            this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(newZoom, zoomTarget){
                final /* synthetic */ float $newZoom;
                final /* synthetic */ PointF $zoomTarget;
                {
                    this.$newZoom = $newZoom;
                    this.$zoomTarget = $zoomTarget;
                    super(1);
                }

                public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                    Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                    $this$applyUpdate.zoomTo$library_release(this.$newZoom, true);
                    $this$applyUpdate.pivot$library_release(Float.valueOf(this.$zoomTarget.x), Float.valueOf(this.$zoomTarget.y));
                    $this$applyUpdate.setOverPan$library_release(true);
                    $this$applyUpdate.setNotify$library_release(false);
                }
            }));
            panFix = ScaledPoint.toAbsolute$library_release$default(this.panManager.getCorrection$library_release(), this.matrixController.getZoom$library_release(), null, 2, null);
            newPan.set(this.matrixController.getPan$library_release().plus(panFix));
            this.matrixController.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(oldZoom, oldPan){
                final /* synthetic */ float $oldZoom;
                final /* synthetic */ AbsolutePoint $oldPan;
                {
                    this.$oldZoom = $oldZoom;
                    this.$oldPan = $oldPan;
                    super(1);
                }

                public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                    Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                    $this$applyUpdate.zoomTo$library_release(this.$oldZoom, true);
                    $this$applyUpdate.panTo$library_release(this.$oldPan, true);
                    $this$applyUpdate.setNotify$library_release(false);
                }
            }));
        }
        if (panFix.getX() == 0.0f && panFix.getY() == 0.0f) {
            this.matrixController.animateUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(newZoom){
                final /* synthetic */ float $newZoom;
                {
                    this.$newZoom = $newZoom;
                    super(1);
                }

                public final void invoke(@NotNull MatrixUpdate.Builder $this$animateUpdate) {
                    Intrinsics.checkNotNullParameter((Object)$this$animateUpdate, (String)"$this$animateUpdate");
                    $this$animateUpdate.zoomTo$library_release(this.$newZoom, true);
                }
            }));
        } else {
            this.matrixController.animateUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>(newZoom, newPan, zoomTarget){
                final /* synthetic */ float $newZoom;
                final /* synthetic */ AbsolutePoint $newPan;
                final /* synthetic */ PointF $zoomTarget;
                {
                    this.$newZoom = $newZoom;
                    this.$newPan = $newPan;
                    this.$zoomTarget = $zoomTarget;
                    super(1);
                }

                public final void invoke(@NotNull MatrixUpdate.Builder $this$animateUpdate) {
                    Intrinsics.checkNotNullParameter((Object)$this$animateUpdate, (String)"$this$animateUpdate");
                    $this$animateUpdate.zoomTo$library_release(this.$newZoom, true);
                    $this$animateUpdate.panTo$library_release(this.$newPan, true);
                    $this$animateUpdate.pivot$library_release(Float.valueOf(this.$zoomTarget.x), Float.valueOf(this.$zoomTarget.y));
                }
            }));
        }
    }

    private final PointF computeZoomPivot(AbsolutePoint fixPan) {
        if (this.matrixController.getZoom$library_release() <= 1.0f) {
            AbsolutePoint center = new AbsolutePoint(-this.matrixController.getContentWidth$library_release() / 2.0f, -this.matrixController.getContentHeight$library_release() / 2.0f);
            PointF result = this.contentPointToContainerPoint(center);
            result.set(-result.x, -result.y);
            return result;
        }
        float x = fixPan.getX() > 0.0f ? this.matrixController.getContainerWidth$library_release() : (fixPan.getX() < 0.0f ? 0.0f : this.matrixController.getContainerWidth$library_release() / 2.0f);
        float y = fixPan.getY() > 0.0f ? this.matrixController.getContainerHeight$library_release() : (fixPan.getY() < 0.0f ? 0.0f : this.matrixController.getContainerHeight$library_release() / 2.0f);
        return new PointF(x, y);
    }

    private final AbsolutePoint containerPointToContentPoint(PointF containerPoint) {
        ScaledPoint scaledPoint = new ScaledPoint(this.matrixController.getScaledPanX$library_release() + containerPoint.x, this.matrixController.getScaledPanY$library_release() + containerPoint.y);
        return ScaledPoint.toAbsolute$library_release$default(scaledPoint, this.matrixController.getZoom$library_release(), null, 2, null);
    }

    private final PointF contentPointToContainerPoint(AbsolutePoint contentPoint) {
        ScaledPoint result = AbsolutePoint.toScaled$library_release$default(contentPoint, this.matrixController.getZoom$library_release(), null, 2, null).minus(this.matrixController.getScaledPan$library_release());
        return new PointF(result.getX(), result.getY());
    }

    public static final /* synthetic */ AbsolutePoint access$getCurrentFocusOffset$p(PinchDetector $this) {
        return $this.currentFocusOffset;
    }

    static {
        String string = TAG = PinchDetector.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/otaliastudios/zoom/internal/gestures/PinchDetector$Companion;", "", "()V", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

