/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom.internal.matrix;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.otaliastudios.zoom.AbsolutePoint;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomLogger;
import com.otaliastudios.zoom.internal.StateController;
import com.otaliastudios.zoom.internal.matrix.MatrixController;
import com.otaliastudios.zoom.internal.matrix.MatrixUpdate;
import com.otaliastudios.zoom.internal.movement.PanManager;
import com.otaliastudios.zoom.internal.movement.ZoomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r*\u0001\u0015\b\u0000\u0018\u0000 p2\u00020\u0001:\u0002opB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0001\u00a2\u0006\u0002\bRJ&\u0010N\u001a\u00020O2\u0017\u0010P\u001a\u0013\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020O0S\u00a2\u0006\u0002\bUH\u0000\u00a2\u0006\u0002\bRJ\u0015\u0010V\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0000\u00a2\u0006\u0002\bWJ&\u0010V\u001a\u00020O2\u0017\u0010P\u001a\u0013\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020O0S\u00a2\u0006\u0002\bUH\u0000\u00a2\u0006\u0002\bWJ\r\u0010X\u001a\u00020OH\u0000\u00a2\u0006\u0002\bYJ\r\u0010Z\u001a\u00020OH\u0000\u00a2\u0006\u0002\b[J\b\u0010\\\u001a\u00020OH\u0002J\u0010\u0010]\u001a\u00020O2\u0006\u0010^\u001a\u00020.H\u0002J\u0018\u0010_\u001a\u00020O2\u0006\u0010`\u001a\u00020\u00182\u0006\u0010a\u001a\u00020.H\u0002J\u0015\u0010b\u001a\u00020.2\u0006\u0010c\u001a\u00020dH\u0000\u00a2\u0006\u0002\beJ\u0015\u0010f\u001a\u00020O2\u0006\u0010c\u001a\u00020dH\u0000\u00a2\u0006\u0002\bgJ%\u0010h\u001a\u00020O2\u0006\u0010i\u001a\u00020\u00182\u0006\u0010j\u001a\u00020\u00182\u0006\u0010a\u001a\u00020.H\u0000\u00a2\u0006\u0002\bkJ%\u0010l\u001a\u00020O2\u0006\u0010i\u001a\u00020\u00182\u0006\u0010j\u001a\u00020\u00182\u0006\u0010a\u001a\u00020.H\u0000\u00a2\u0006\u0002\bmJ\b\u0010n\u001a\u00020OH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001a\u0010\u001e\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u001bR\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010 \u001a\u0004\b&\u0010\u001bR\u000e\u0010'\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010 \u001a\u0004\b*\u0010\u001bR\u001a\u0010+\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010 \u001a\u0004\b-\u0010\u001bR\u001e\u0010/\u001a\u00020.2\u0006\u0010\u0017\u001a\u00020.@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u0002038@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0002078@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b;\u0010 \u001a\u0004\b<\u0010\u001bR\u001a\u0010=\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b>\u0010 \u001a\u0004\b?\u0010\u001bR\u0016\u0010@\u001a\u00020A8@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\bE\u0010 \u001a\u0004\bF\u0010\u001bR\u001a\u0010G\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\bH\u0010 \u001a\u0004\bI\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010K\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\bL\u0010 \u001a\u0004\bM\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/otaliastudios/zoom/internal/matrix/MatrixController;", "", "zoomManager", "Lcom/otaliastudios/zoom/internal/movement/ZoomManager;", "panManager", "Lcom/otaliastudios/zoom/internal/movement/PanManager;", "stateController", "Lcom/otaliastudios/zoom/internal/StateController;", "callback", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController$Callback;", "(Lcom/otaliastudios/zoom/internal/movement/ZoomManager;Lcom/otaliastudios/zoom/internal/movement/PanManager;Lcom/otaliastudios/zoom/internal/StateController;Lcom/otaliastudios/zoom/internal/matrix/MatrixController$Callback;)V", "activeAnimators", "", "Landroid/animation/ValueAnimator;", "animationDuration", "", "getAnimationDuration$library_release", "()J", "setAnimationDuration$library_release", "(J)V", "cancelAnimationListener", "com/otaliastudios/zoom/internal/matrix/MatrixController$cancelAnimationListener$1", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController$cancelAnimationListener$1;", "<set-?>", "", "containerHeight", "getContainerHeight$library_release", "()F", "containerWidth", "getContainerWidth$library_release", "contentHeight", "getContentHeight$library_release$annotations", "()V", "getContentHeight$library_release", "contentRect", "Landroid/graphics/RectF;", "contentScaledHeight", "getContentScaledHeight$library_release$annotations", "getContentScaledHeight$library_release", "contentScaledRect", "contentScaledWidth", "getContentScaledWidth$library_release$annotations", "getContentScaledWidth$library_release", "contentWidth", "getContentWidth$library_release$annotations", "getContentWidth$library_release", "", "isInitialized", "isInitialized$library_release", "()Z", "matrix", "Landroid/graphics/Matrix;", "getMatrix$library_release", "()Landroid/graphics/Matrix;", "pan", "Lcom/otaliastudios/zoom/AbsolutePoint;", "getPan$library_release", "()Lcom/otaliastudios/zoom/AbsolutePoint;", "panX", "getPanX$library_release$annotations", "getPanX$library_release", "panY", "getPanY$library_release$annotations", "getPanY$library_release", "scaledPan", "Lcom/otaliastudios/zoom/ScaledPoint;", "getScaledPan$library_release", "()Lcom/otaliastudios/zoom/ScaledPoint;", "scaledPanX", "getScaledPanX$library_release$annotations", "getScaledPanX$library_release", "scaledPanY", "getScaledPanY$library_release$annotations", "getScaledPanY$library_release", "stub", "zoom", "getZoom$library_release$annotations", "getZoom$library_release", "animateUpdate", "", "update", "Lcom/otaliastudios/zoom/internal/matrix/MatrixUpdate;", "animateUpdate$library_release", "Lkotlin/Function1;", "Lcom/otaliastudios/zoom/internal/matrix/MatrixUpdate$Builder;", "Lkotlin/ExtensionFunctionType;", "applyUpdate", "applyUpdate$library_release", "cancelAnimations", "cancelAnimations$library_release", "clear", "clear$library_release", "dispatch", "ensurePan", "allowOverPan", "onSizeChanged", "oldZoom", "forceReset", "post", "action", "Ljava/lang/Runnable;", "post$library_release", "postOnAnimation", "postOnAnimation$library_release", "setContainerSize", "width", "height", "setContainerSize$library_release", "setContentSize", "setContentSize$library_release", "sync", "Callback", "Companion", "library_release"})
public final class MatrixController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomManager zoomManager;
    @NotNull
    private final PanManager panManager;
    @NotNull
    private final StateController stateController;
    @NotNull
    private final Callback callback;
    @NotNull
    private RectF contentScaledRect;
    @NotNull
    private RectF contentRect;
    @NotNull
    private Matrix stub;
    private boolean isInitialized;
    @NotNull
    private final Matrix matrix;
    private float containerWidth;
    private float containerHeight;
    @NotNull
    private final ScaledPoint scaledPan;
    @NotNull
    private final AbsolutePoint pan;
    private long animationDuration;
    @NotNull
    private final Set<ValueAnimator> activeAnimators;
    @NotNull
    private final cancelAnimationListener.1 cancelAnimationListener;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;
    @NotNull
    private static final AccelerateDecelerateInterpolator ANIMATION_INTERPOLATOR;

    public MatrixController(@NotNull ZoomManager zoomManager2, @NotNull PanManager panManager2, @NotNull StateController stateController, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)zoomManager2, (String)"zoomManager");
        Intrinsics.checkNotNullParameter((Object)panManager2, (String)"panManager");
        Intrinsics.checkNotNullParameter((Object)stateController, (String)"stateController");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.zoomManager = zoomManager2;
        this.panManager = panManager2;
        this.stateController = stateController;
        this.callback = callback;
        this.contentScaledRect = new RectF();
        this.contentRect = new RectF();
        this.stub = new Matrix();
        this.matrix = new Matrix();
        this.scaledPan = new ScaledPoint(0.0f, 0.0f, 3, null);
        this.pan = new AbsolutePoint(0.0f, 0.0f, 3, null);
        this.animationDuration = 280L;
        boolean bl = false;
        this.activeAnimators = new LinkedHashSet();
        this.cancelAnimationListener = new AnimatorListenerAdapter(this){
            final /* synthetic */ MatrixController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                this.cleanup(animator);
            }

            public void onAnimationCancel(@NotNull Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                this.cleanup(animator);
            }

            private final void cleanup(Animator animator) {
                animator.removeListener((Animator.AnimatorListener)this);
                Collection collection = MatrixController.access$getActiveAnimators$p(this.this$0);
                boolean bl = false;
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                TypeIntrinsics.asMutableCollection((Object)collection2).remove(animator);
                if (MatrixController.access$getActiveAnimators$p(this.this$0).isEmpty()) {
                    MatrixController.access$getStateController$p(this.this$0).makeIdle$library_release();
                }
            }
        };
    }

    public final boolean isInitialized$library_release() {
        return this.isInitialized;
    }

    @NotNull
    public final Matrix getMatrix$library_release() {
        this.matrix.set(this.stub);
        return this.matrix;
    }

    public final float getContentScaledWidth$library_release() {
        return this.contentScaledRect.width();
    }

    public static /* synthetic */ void getContentScaledWidth$library_release$annotations() {
    }

    public final float getContentScaledHeight$library_release() {
        return this.contentScaledRect.height();
    }

    public static /* synthetic */ void getContentScaledHeight$library_release$annotations() {
    }

    public final float getContentWidth$library_release() {
        return this.contentRect.width();
    }

    public static /* synthetic */ void getContentWidth$library_release$annotations() {
    }

    public final float getContentHeight$library_release() {
        return this.contentRect.height();
    }

    public static /* synthetic */ void getContentHeight$library_release$annotations() {
    }

    public final float getContainerWidth$library_release() {
        return this.containerWidth;
    }

    public final float getContainerHeight$library_release() {
        return this.containerHeight;
    }

    @NotNull
    public final ScaledPoint getScaledPan$library_release() {
        this.scaledPan.set(Float.valueOf(this.getScaledPanX$library_release()), Float.valueOf(this.getScaledPanY$library_release()));
        return this.scaledPan;
    }

    public final float getScaledPanX$library_release() {
        return this.contentScaledRect.left;
    }

    public static /* synthetic */ void getScaledPanX$library_release$annotations() {
    }

    public final float getScaledPanY$library_release() {
        return this.contentScaledRect.top;
    }

    public static /* synthetic */ void getScaledPanY$library_release$annotations() {
    }

    public final float getZoom$library_release() {
        return this.contentScaledRect.width() / this.contentRect.width();
    }

    public static /* synthetic */ void getZoom$library_release$annotations() {
    }

    public final float getPanX$library_release() {
        return this.getScaledPanX$library_release() / this.getZoom$library_release();
    }

    public static /* synthetic */ void getPanX$library_release$annotations() {
    }

    public final float getPanY$library_release() {
        return this.getScaledPanY$library_release() / this.getZoom$library_release();
    }

    public static /* synthetic */ void getPanY$library_release$annotations() {
    }

    @NotNull
    public final AbsolutePoint getPan$library_release() {
        this.pan.set(Float.valueOf(this.getPanX$library_release()), Float.valueOf(this.getPanY$library_release()));
        return this.pan;
    }

    public final boolean post$library_release(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.callback.post(action);
    }

    public final void postOnAnimation$library_release(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.callback.postOnAnimation(action);
    }

    public final void clear$library_release() {
        this.isInitialized = false;
        this.containerHeight = 0.0f;
        this.containerWidth = 0.0f;
        this.contentScaledRect = new RectF();
        this.contentRect = new RectF();
        this.stub = new Matrix();
    }

    public final void setContentSize$library_release(float width, float height, boolean forceReset) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        if (!(this.getContentWidth$library_release() == width) || !(this.getContentHeight$library_release() == height) || forceReset) {
            float oldZoom = this.getZoom$library_release();
            this.contentRect.set(0.0f, 0.0f, width, height);
            this.onSizeChanged(oldZoom, forceReset);
        }
    }

    public final void setContainerSize$library_release(float width, float height, boolean forceReset) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        if (!(width == this.containerWidth) || !(height == this.containerHeight) || forceReset) {
            this.containerWidth = width;
            this.containerHeight = height;
            this.onSizeChanged(this.getZoom$library_release(), forceReset);
        }
    }

    private final void onSizeChanged(float oldZoom, boolean forceReset) {
        this.sync();
        if (this.getContentWidth$library_release() <= 0.0f || this.getContentHeight$library_release() <= 0.0f || this.containerWidth <= 0.0f || this.containerHeight <= 0.0f) {
            return;
        }
        Object[] objectArray = new Object[]{"onSizeChanged:", "containerWidth:", Float.valueOf(this.containerWidth), "containerHeight:", Float.valueOf(this.containerHeight), "contentWidth:", Float.valueOf(this.getContentWidth$library_release()), "contentHeight:", Float.valueOf(this.getContentHeight$library_release())};
        LOG.w$library_release(objectArray);
        boolean firstTime = !this.isInitialized || forceReset;
        this.isInitialized = true;
        this.callback.onMatrixSizeChanged(oldZoom, firstTime);
    }

    private final void sync() {
        this.stub.mapRect(this.contentScaledRect, this.contentRect);
    }

    private final void dispatch() {
        this.callback.onMatrixUpdate();
    }

    private final void ensurePan(boolean allowOverPan) {
        float fixX = this.panManager.checkBounds$library_release(true, allowOverPan);
        float fixY = this.panManager.checkBounds$library_release(false, allowOverPan);
        if (!(fixX == 0.0f) || !(fixY == 0.0f)) {
            this.stub.postTranslate(fixX, fixY);
            this.sync();
        }
    }

    public final void applyUpdate$library_release(@NotNull Function1<? super MatrixUpdate.Builder, Unit> update2) {
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        this.applyUpdate$library_release(MatrixUpdate.Companion.obtain$library_release(update2));
    }

    public final void applyUpdate$library_release(@NotNull MatrixUpdate update2) {
        Object delta;
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        if (!this.isInitialized) {
            return;
        }
        if (update2.getPan$library_release() != null) {
            delta = update2.isPanRelative$library_release() ? update2.getPan$library_release() : update2.getPan$library_release().minus(this.getPan$library_release());
            this.stub.preTranslate(((AbsolutePoint)delta).getX(), ((AbsolutePoint)delta).getY());
            this.sync();
        } else if (update2.getScaledPan$library_release() != null) {
            delta = update2.isPanRelative$library_release() ? update2.getScaledPan$library_release() : update2.getScaledPan$library_release().minus(this.getScaledPan$library_release());
            this.stub.postTranslate(((ScaledPoint)delta).getX(), ((ScaledPoint)delta).getY());
            this.sync();
        }
        if (update2.getHasZoom$library_release()) {
            float newZoom = update2.isZoomRelative$library_release() ? this.getZoom$library_release() * update2.getZoom$library_release() : update2.getZoom$library_release();
            newZoom = this.zoomManager.checkBounds$library_release(newZoom, update2.getCanOverZoom$library_release());
            float factor = newZoom / this.getZoom$library_release();
            float pivotX = update2.getPivotX$library_release() != null ? update2.getPivotX$library_release().floatValue() : (update2.getHasPan$library_release() ? 0.0f : this.containerWidth / 2.0f);
            float pivotY = update2.getPivotY$library_release() != null ? update2.getPivotY$library_release().floatValue() : (update2.getHasPan$library_release() ? 0.0f : this.containerHeight / 2.0f);
            this.stub.postScale(factor, factor, pivotX, pivotY);
            this.sync();
        }
        this.ensurePan(update2.getCanOverPan$library_release());
        if (update2.getNotify$library_release()) {
            this.dispatch();
        }
    }

    public final long getAnimationDuration$library_release() {
        return this.animationDuration;
    }

    public final void setAnimationDuration$library_release(long l) {
        this.animationDuration = l;
    }

    public final void cancelAnimations$library_release() {
        Iterable $this$forEach$iv = this.activeAnimators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueAnimator it = (ValueAnimator)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.activeAnimators.clear();
    }

    public final void animateUpdate$library_release(@NotNull Function1<? super MatrixUpdate.Builder, Unit> update2) {
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        this.animateUpdate$library_release(MatrixUpdate.Companion.obtain$library_release(update2));
    }

    @SuppressLint(value={"ObjectAnimatorBinding"})
    public final void animateUpdate$library_release(@NotNull MatrixUpdate update2) {
        PropertyValuesHolder propertyValuesHolder;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        if (!this.isInitialized) {
            return;
        }
        if (!this.stateController.setAnimating$library_release()) {
            return;
        }
        boolean bl = false;
        List holders = new ArrayList();
        if (update2.getPan$library_release() != null) {
            AbsolutePoint target = update2.isPanRelative$library_release() ? this.getPan$library_release().plus(update2.getPan$library_release()) : update2.getPan$library_release();
            fArray = new float[]{this.getPanX$library_release(), target.getX()};
            propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"panX", (float[])fArray);
            Intrinsics.checkNotNullExpressionValue((Object)propertyValuesHolder, (String)"ofFloat(\"panX\", panX, target.x)");
            holders.add(propertyValuesHolder);
            fArray = new float[]{this.getPanY$library_release(), target.getY()};
            propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"panY", (float[])fArray);
            Intrinsics.checkNotNullExpressionValue((Object)propertyValuesHolder, (String)"ofFloat(\"panY\", panY, target.y)");
            holders.add(propertyValuesHolder);
        } else if (update2.getScaledPan$library_release() != null) {
            ScaledPoint target = update2.isPanRelative$library_release() ? this.getScaledPan$library_release().plus(update2.getScaledPan$library_release()) : update2.getScaledPan$library_release();
            fArray = new float[]{this.getScaledPanX$library_release(), target.getX()};
            propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"panX", (float[])fArray);
            Intrinsics.checkNotNullExpressionValue((Object)propertyValuesHolder, (String)"ofFloat(\"panX\", scaledPanX, target.x)");
            holders.add(propertyValuesHolder);
            fArray = new float[]{this.getScaledPanY$library_release(), target.getY()};
            propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"panY", (float[])fArray);
            Intrinsics.checkNotNullExpressionValue((Object)propertyValuesHolder, (String)"ofFloat(\"panY\", scaledPanY, target.y)");
            holders.add(propertyValuesHolder);
        }
        if (update2.getHasZoom$library_release()) {
            float newZoom = update2.isZoomRelative$library_release() ? this.getZoom$library_release() * update2.getZoom$library_release() : update2.getZoom$library_release();
            newZoom = this.zoomManager.checkBounds$library_release(newZoom, update2.getCanOverZoom$library_release());
            fArray = new float[]{this.getZoom$library_release(), newZoom};
            propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"zoom", (float[])fArray);
            Intrinsics.checkNotNullExpressionValue((Object)propertyValuesHolder, (String)"ofFloat(\"zoom\", zoom, newZoom)");
            holders.add(propertyValuesHolder);
        }
        Collection $this$toTypedArray$iv = holders;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PropertyValuesHolder propertyValuesHolder2 = thisCollection$iv.toArray(new PropertyValuesHolder[0]);
        if (propertyValuesHolder2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        propertyValuesHolder = propertyValuesHolder2;
        ValueAnimator animator = ObjectAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])((PropertyValuesHolder[])Arrays.copyOf(propertyValuesHolder, ((PropertyValuesHolder)propertyValuesHolder).length)));
        animator.setDuration(this.animationDuration);
        animator.setInterpolator((TimeInterpolator)ANIMATION_INTERPOLATOR);
        animator.addListener((Animator.AnimatorListener)this.cancelAnimationListener);
        animator.addUpdateListener(arg_0 -> MatrixController.animateUpdate$lambda-1(this, update2, arg_0));
        animator.start();
        Intrinsics.checkNotNullExpressionValue((Object)animator, (String)"animator");
        this.activeAnimators.add(animator);
    }

    private static final void animateUpdate$lambda-1(MatrixController this$0, MatrixUpdate $update, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$update, (String)"$update");
        this$0.applyUpdate$library_release((Function1<? super MatrixUpdate.Builder, Unit>)((Function1)new Function1<MatrixUpdate.Builder, Unit>($update, it){
            final /* synthetic */ MatrixUpdate $update;
            final /* synthetic */ ValueAnimator $it;
            {
                this.$update = $update;
                this.$it = $it;
                super(1);
            }

            public final void invoke(@NotNull MatrixUpdate.Builder $this$applyUpdate) {
                float newPanX;
                Object object;
                Intrinsics.checkNotNullParameter((Object)$this$applyUpdate, (String)"$this$applyUpdate");
                if (this.$update.getHasZoom$library_release()) {
                    object = this.$it.getAnimatedValue("zoom");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    float newZoom = ((Float)object).floatValue();
                    $this$applyUpdate.zoomTo$library_release(newZoom, this.$update.getCanOverZoom$library_release());
                }
                if (this.$update.getPan$library_release() != null) {
                    object = this.$it.getAnimatedValue("panX");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    newPanX = ((Float)object).floatValue();
                    Object object2 = this.$it.getAnimatedValue("panY");
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    float newPanY = ((Float)object2).floatValue();
                    $this$applyUpdate.panTo$library_release(new AbsolutePoint(newPanX, newPanY), this.$update.getCanOverPan$library_release());
                } else if (this.$update.getScaledPan$library_release() != null) {
                    Object newPanY = this.$it.getAnimatedValue("panX");
                    if (newPanY == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    newPanX = ((Float)newPanY).floatValue();
                    Object object3 = this.$it.getAnimatedValue("panY");
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    float newPanY2 = ((Float)object3).floatValue();
                    $this$applyUpdate.panTo$library_release(new ScaledPoint(newPanX, newPanY2), this.$update.getCanOverPan$library_release());
                }
                $this$applyUpdate.pivot$library_release(this.$update.getPivotX$library_release(), this.$update.getPivotY$library_release());
                $this$applyUpdate.setNotify$library_release(this.$update.getNotify$library_release());
            }
        }));
    }

    public static final /* synthetic */ Set access$getActiveAnimators$p(MatrixController $this) {
        return $this.activeAnimators;
    }

    public static final /* synthetic */ StateController access$getStateController$p(MatrixController $this) {
        return $this.stateController;
    }

    static {
        String string = TAG = MatrixController.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
        ANIMATION_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0003H&J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lcom/otaliastudios/zoom/internal/matrix/MatrixController$Callback;", "", "onMatrixSizeChanged", "", "oldZoom", "", "firstTime", "", "onMatrixUpdate", "post", "action", "Ljava/lang/Runnable;", "postOnAnimation", "library_release"})
    public static interface Callback {
        public void onMatrixUpdate();

        public void onMatrixSizeChanged(float var1, boolean var2);

        public boolean post(@NotNull Runnable var1);

        public void postOnAnimation(@NotNull Runnable var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/otaliastudios/zoom/internal/matrix/MatrixController$Companion;", "", "()V", "ANIMATION_INTERPOLATOR", "Landroid/view/animation/AccelerateDecelerateInterpolator;", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

