/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.zoom.internal.movement;

import android.annotation.SuppressLint;
import com.otaliastudios.zoom.Alignment;
import com.otaliastudios.zoom.OverPanRangeProvider;
import com.otaliastudios.zoom.ScaledPoint;
import com.otaliastudios.zoom.ZoomEngine;
import com.otaliastudios.zoom.ZoomLogger;
import com.otaliastudios.zoom.internal.matrix.MatrixController;
import com.otaliastudios.zoom.internal.movement.MovementManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 @2\u00020\u0001:\u0002@AB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J%\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b6J\u001d\u00107\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020;H\u0016J\u001d\u0010<\u001a\u00020;2\u0006\u00105\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u001a\u0010\u001d\u001a\u00020\u001e8@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001e8@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010 \u001a\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0015\"\u0004\b.\u0010\u0017R\u001a\u0010/\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0015\"\u0004\b1\u0010\u0017\u00a8\u0006B"}, d2={"Lcom/otaliastudios/zoom/internal/movement/PanManager;", "Lcom/otaliastudios/zoom/internal/movement/MovementManager;", "engine", "Lcom/otaliastudios/zoom/ZoomEngine;", "provider", "Lkotlin/Function0;", "Lcom/otaliastudios/zoom/internal/matrix/MatrixController;", "(Lcom/otaliastudios/zoom/ZoomEngine;Lkotlin/jvm/functions/Function0;)V", "alignment", "", "getAlignment$library_release", "()I", "setAlignment$library_release", "(I)V", "correction", "Lcom/otaliastudios/zoom/ScaledPoint;", "getCorrection$library_release", "()Lcom/otaliastudios/zoom/ScaledPoint;", "horizontalOverPanEnabled", "", "getHorizontalOverPanEnabled$library_release", "()Z", "setHorizontalOverPanEnabled$library_release", "(Z)V", "horizontalPanEnabled", "getHorizontalPanEnabled$library_release", "setHorizontalPanEnabled$library_release", "isEnabled", "isOverEnabled", "maxHorizontalOverPan", "", "getMaxHorizontalOverPan$library_release$annotations", "()V", "getMaxHorizontalOverPan$library_release", "()F", "maxVerticalOverPan", "getMaxVerticalOverPan$library_release$annotations", "getMaxVerticalOverPan$library_release", "overPanRangeProvider", "Lcom/otaliastudios/zoom/OverPanRangeProvider;", "getOverPanRangeProvider$library_release", "()Lcom/otaliastudios/zoom/OverPanRangeProvider;", "setOverPanRangeProvider$library_release", "(Lcom/otaliastudios/zoom/OverPanRangeProvider;)V", "verticalOverPanEnabled", "getVerticalOverPanEnabled$library_release", "setVerticalOverPanEnabled$library_release", "verticalPanEnabled", "getVerticalPanEnabled$library_release", "setVerticalPanEnabled$library_release", "applyGravity", "gravity", "extraSpace", "horizontal", "applyGravity$library_release", "checkBounds", "allowOverScroll", "checkBounds$library_release", "clear", "", "computeStatus", "output", "Lcom/otaliastudios/zoom/internal/movement/PanManager$Status;", "computeStatus$library_release", "Companion", "Status", "library_release"})
public final class PanManager
extends MovementManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomEngine engine;
    private boolean horizontalOverPanEnabled;
    private boolean verticalOverPanEnabled;
    private boolean horizontalPanEnabled;
    private boolean verticalPanEnabled;
    private int alignment;
    @NotNull
    private OverPanRangeProvider overPanRangeProvider;
    @NotNull
    private final ScaledPoint correction;
    private static final String TAG;
    @NotNull
    private static final ZoomLogger LOG;

    public PanManager(@NotNull ZoomEngine engine, @NotNull Function0<MatrixController> provider) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        super(provider);
        this.engine = engine;
        this.horizontalOverPanEnabled = true;
        this.verticalOverPanEnabled = true;
        this.horizontalPanEnabled = true;
        this.verticalPanEnabled = true;
        this.alignment = 51;
        this.overPanRangeProvider = OverPanRangeProvider.DEFAULT;
        this.correction = new ScaledPoint(0.0f, 0.0f, 3, null);
    }

    public final boolean getHorizontalOverPanEnabled$library_release() {
        return this.horizontalOverPanEnabled;
    }

    public final void setHorizontalOverPanEnabled$library_release(boolean bl) {
        this.horizontalOverPanEnabled = bl;
    }

    public final boolean getVerticalOverPanEnabled$library_release() {
        return this.verticalOverPanEnabled;
    }

    public final void setVerticalOverPanEnabled$library_release(boolean bl) {
        this.verticalOverPanEnabled = bl;
    }

    public final boolean getHorizontalPanEnabled$library_release() {
        return this.horizontalPanEnabled;
    }

    public final void setHorizontalPanEnabled$library_release(boolean bl) {
        this.horizontalPanEnabled = bl;
    }

    public final boolean getVerticalPanEnabled$library_release() {
        return this.verticalPanEnabled;
    }

    public final void setVerticalPanEnabled$library_release(boolean bl) {
        this.verticalPanEnabled = bl;
    }

    public final int getAlignment$library_release() {
        return this.alignment;
    }

    public final void setAlignment$library_release(int n) {
        this.alignment = n;
    }

    @NotNull
    public final OverPanRangeProvider getOverPanRangeProvider$library_release() {
        return this.overPanRangeProvider;
    }

    public final void setOverPanRangeProvider$library_release(@NotNull OverPanRangeProvider overPanRangeProvider) {
        Intrinsics.checkNotNullParameter((Object)overPanRangeProvider, (String)"<set-?>");
        this.overPanRangeProvider = overPanRangeProvider;
    }

    @Override
    public boolean isOverEnabled() {
        return this.horizontalOverPanEnabled || this.verticalOverPanEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.horizontalPanEnabled || this.verticalPanEnabled;
    }

    @Override
    public void clear() {
    }

    public final void computeStatus$library_release(boolean horizontal, @NotNull Status output) {
        int alignment;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int currentPan = (int)(horizontal ? this.getController().getScaledPanX$library_release() : this.getController().getScaledPanY$library_release());
        int containerDim = (int)(horizontal ? this.getController().getContainerWidth$library_release() : this.getController().getContainerHeight$library_release());
        int contentDim = (int)(horizontal ? this.getController().getContentScaledWidth$library_release() : this.getController().getContentScaledHeight$library_release());
        int fix = (int)this.checkBounds$library_release(horizontal, false);
        int n = alignment = horizontal ? Alignment.INSTANCE.getHorizontal$library_release(this.alignment) : Alignment.INSTANCE.getVertical$library_release(this.alignment);
        if (contentDim > containerDim) {
            int extraSpace = contentDim - containerDim;
            output.setMinValue$library_release(-extraSpace);
            output.setMaxValue$library_release(0);
        } else if (Alignment.INSTANCE.isNone$library_release(alignment)) {
            int extraSpace = containerDim - contentDim;
            output.setMinValue$library_release(0);
            output.setMaxValue$library_release(extraSpace);
        } else {
            int finalValue = currentPan + fix;
            output.setMinValue$library_release(finalValue);
            output.setMaxValue$library_release(finalValue);
        }
        output.setCurrentValue$library_release(currentPan);
        output.setInOverPan$library_release(fix != 0);
    }

    @NotNull
    public final ScaledPoint getCorrection$library_release() {
        this.correction.set(Float.valueOf(this.checkBounds$library_release(true, false)), Float.valueOf(this.checkBounds$library_release(false, false)));
        return this.correction;
    }

    @SuppressLint(value={"RtlHardcoded"})
    public final float checkBounds$library_release(boolean horizontal, boolean allowOverScroll) {
        boolean overScrollable;
        float value = horizontal ? this.getController().getScaledPanX$library_release() : this.getController().getScaledPanY$library_release();
        float containerSize = horizontal ? this.getController().getContainerWidth$library_release() : this.getController().getContainerHeight$library_release();
        float contentSize = horizontal ? this.getController().getContentScaledWidth$library_release() : this.getController().getContentScaledHeight$library_release();
        boolean bl = overScrollable = horizontal ? this.horizontalOverPanEnabled : this.verticalOverPanEnabled;
        float overScroll = overScrollable && allowOverScroll ? (horizontal ? this.getMaxHorizontalOverPan$library_release() : this.getMaxVerticalOverPan$library_release()) : 0.0f;
        int alignmentGravity = horizontal ? Alignment.INSTANCE.toHorizontalGravity$library_release(this.alignment, 0) : Alignment.INSTANCE.toVerticalGravity$library_release(this.alignment, 0);
        float min = 0.0f;
        float max = 0.0f;
        if (contentSize <= containerSize) {
            float extraSpace = containerSize - contentSize;
            if (alignmentGravity != 0) {
                float correction;
                min = correction = this.applyGravity$library_release(alignmentGravity, extraSpace, horizontal);
                max = correction;
            } else {
                min = 0.0f;
                max = extraSpace;
            }
        } else {
            min = containerSize - contentSize;
            max = 0.0f;
        }
        float desired = RangesKt.coerceIn((float)value, (float)(min -= overScroll), (float)(max += overScroll));
        return desired - value;
    }

    public final float getMaxHorizontalOverPan$library_release() {
        float value = this.overPanRangeProvider.getOverPan(this.engine, true);
        if (value < 0.0f) {
            LOG.w$library_release("Received negative maxHorizontalOverPan value, coercing to 0");
            value = RangesKt.coerceAtLeast((float)value, (float)0.0f);
        }
        return value;
    }

    public static /* synthetic */ void getMaxHorizontalOverPan$library_release$annotations() {
    }

    public final float getMaxVerticalOverPan$library_release() {
        float value = this.overPanRangeProvider.getOverPan(this.engine, false);
        if (value < 0.0f) {
            LOG.w$library_release("Received negative maxVerticalOverPan value, coercing to 0");
            value = RangesKt.coerceAtLeast((float)value, (float)0.0f);
        }
        return value;
    }

    public static /* synthetic */ void getMaxVerticalOverPan$library_release$annotations() {
    }

    @SuppressLint(value={"RtlHardcoded"})
    public final float applyGravity$library_release(int gravity, float extraSpace, boolean horizontal) {
        float f;
        int resolved;
        int n = resolved = horizontal ? gravity & 7 : gravity & 0x70;
        switch (n) {
            case 3: 
            case 48: {
                f = 0.0f;
                break;
            }
            case 5: 
            case 80: {
                f = extraSpace;
                break;
            }
            case 1: 
            case 16: {
                f = 0.5f * extraSpace;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    static {
        String string = TAG = PanManager.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LOG = ZoomLogger.Companion.create$library_release(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0007\"\u0004\b\u0013\u0010\tR \u0010\u0014\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/otaliastudios/zoom/internal/movement/PanManager$Status;", "", "()V", "currentValue", "", "getCurrentValue$library_release$annotations", "getCurrentValue$library_release", "()I", "setCurrentValue$library_release", "(I)V", "isInOverPan", "", "isInOverPan$library_release", "()Z", "setInOverPan$library_release", "(Z)V", "maxValue", "getMaxValue$library_release$annotations", "getMaxValue$library_release", "setMaxValue$library_release", "minValue", "getMinValue$library_release$annotations", "getMinValue$library_release", "setMinValue$library_release", "library_release"})
    public static final class Status {
        private int minValue;
        private int currentValue;
        private int maxValue;
        private boolean isInOverPan;

        public final int getMinValue$library_release() {
            return this.minValue;
        }

        public final void setMinValue$library_release(int n) {
            this.minValue = n;
        }

        public static /* synthetic */ void getMinValue$library_release$annotations() {
        }

        public final int getCurrentValue$library_release() {
            return this.currentValue;
        }

        public final void setCurrentValue$library_release(int n) {
            this.currentValue = n;
        }

        public static /* synthetic */ void getCurrentValue$library_release$annotations() {
        }

        public final int getMaxValue$library_release() {
            return this.maxValue;
        }

        public final void setMaxValue$library_release(int n) {
            this.maxValue = n;
        }

        public static /* synthetic */ void getMaxValue$library_release$annotations() {
        }

        public final boolean isInOverPan$library_release() {
            return this.isInOverPan;
        }

        public final void setInOverPan$library_release(boolean bl) {
            this.isInOverPan = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/otaliastudios/zoom/internal/movement/PanManager$Companion;", "", "()V", "LOG", "Lcom/otaliastudios/zoom/ZoomLogger;", "TAG", "", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

