/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.BasePubSub;
import com.sproutsocial.nsq.HostAndPort;
import com.sproutsocial.nsq.NSQException;
import com.sproutsocial.nsq.PubConnection;
import com.sproutsocial.nsq.Publisher;
import com.sproutsocial.nsq.Util;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionDetails {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionDetails.class);
    private final Publisher parent;
    private final BasePubSub basePubSub;
    HostAndPort hostAndPort;
    private PubConnection con = null;
    long failoverStart = 0L;
    private volatile int failoverDurationSecs;
    private State currentState = State.NOT_CONNECTED;

    public ConnectionDetails(String hostAndPort, Publisher parent, int failoverDurationSecs, BasePubSub basePubSub) {
        Util.checkNotNull(hostAndPort);
        Util.checkNotNull(parent);
        Util.checkNotNull(basePubSub);
        this.hostAndPort = HostAndPort.fromString(hostAndPort).withDefaultPort(4150);
        this.parent = parent;
        this.failoverDurationSecs = failoverDurationSecs;
        this.basePubSub = basePubSub;
    }

    protected synchronized boolean makeReady() {
        if (this.currentState == State.NOT_CONNECTED) {
            if (this.parent.isStopping) {
                throw new NSQException("publisher stopped");
            }
            return this.connectAttempt();
        }
        if (this.currentState == State.FAILED && this.canAttemptRecovery()) {
            return this.connectAttempt();
        }
        return this.currentState == State.CONNECTED;
    }

    private boolean canAttemptRecovery() {
        return Util.clock() - this.failoverStart > TimeUnit.SECONDS.toMillis(this.failoverDurationSecs);
    }

    private boolean connectAttempt() {
        if (this.con != null) {
            this.con.close();
        }
        this.con = new PubConnection(this.basePubSub.getClient(), this.hostAndPort, this.parent);
        try {
            this.con.connect(this.basePubSub.getConfig());
            this.currentState = State.CONNECTED;
        }
        catch (IOException e) {
            this.markFailure();
            return false;
        }
        LOGGER.info("publisher connected:{}", (Object)this.hostAndPort);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionDetails that = (ConnectionDetails)o;
        return this.hostAndPort.equals(that.hostAndPort);
    }

    public int hashCode() {
        return this.hostAndPort.hashCode();
    }

    public synchronized void markFailure() {
        Util.closeQuietly(this.con);
        this.con = null;
        this.currentState = State.FAILED;
        this.failoverStart = Util.clock();
        LOGGER.warn("Marking the connection to host {} as failed , will retry after {} seconds", (Object)this.hostAndPort, (Object)this.failoverDurationSecs);
    }

    public void setFailoverDurationSecs(int failoverDurationSecs) {
        this.failoverDurationSecs = failoverDurationSecs;
    }

    public PubConnection getCon() {
        return this.con;
    }

    public void clearConnection() {
        this.con = null;
        this.currentState = State.NOT_CONNECTED;
    }

    public String toString() {
        return "ConnectionDetails{parent=" + this.parent + ", hostAndPort=" + this.hostAndPort + ", con=" + this.con + ", failoverStart=" + this.failoverStart + ", failoverDurationSecs=" + this.failoverDurationSecs + ", currentState=" + (Object)((Object)this.currentState) + '}';
    }

    private static enum State {
        CONNECTED,
        NOT_CONNECTED,
        FAILED;

    }
}

