/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.Message;
import com.sproutsocial.nsq.SubConnection;
import java.io.IOException;

class NSQMessage
implements Message {
    private final long timestamp;
    private final int attempts;
    private final String id;
    private final byte[] data;
    private final String topic;
    private final SubConnection connection;

    NSQMessage(long timestamp, int attempts, String id, byte[] data, String topic, SubConnection connection) {
        this.timestamp = timestamp;
        this.attempts = attempts;
        this.id = id;
        this.data = data;
        this.topic = topic;
        this.connection = connection;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getAttempts() {
        return this.attempts;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void finish() {
        this.connection.finish(this.id);
    }

    @Override
    public void requeue() {
        this.connection.requeue(this.id);
    }

    @Override
    public void requeue(int delayMillis) {
        this.connection.requeue(this.id, delayMillis);
    }

    @Override
    public void touch() {
        this.connection.touch(this.id);
    }

    @Override
    public void forceFlush() {
        try {
            this.connection.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    SubConnection getConnection() {
        return this.connection;
    }
}

