/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import shark.FileSourceProvider;
import shark.HprofHeader;
import shark.HprofRecordReader;
import shark.RandomAccessSource;
import shark.RandomAccessSourceProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u000e0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lshark/RandomAccessHprofReader;", "Ljava/io/Closeable;", "source", "Lshark/RandomAccessSource;", "hprofHeader", "Lshark/HprofHeader;", "(Lshark/RandomAccessSource;Lshark/HprofHeader;)V", "buffer", "Lokio/Buffer;", "reader", "Lshark/HprofRecordReader;", "close", "", "readRecord", "T", "recordPosition", "", "recordSize", "withRecordReader", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(JJLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "shark-hprof"})
public final class RandomAccessHprofReader
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RandomAccessSource source;
    @NotNull
    private final Buffer buffer;
    @NotNull
    private final HprofRecordReader reader;

    private RandomAccessHprofReader(RandomAccessSource source, HprofHeader hprofHeader) {
        this.source = source;
        this.buffer = new Buffer();
        this.reader = new HprofRecordReader(hprofHeader, (BufferedSource)this.buffer);
    }

    public final <T> T readRecord(long recordPosition, long recordSize, @NotNull Function1<? super HprofRecordReader, ? extends T> withRecordReader) {
        Object object;
        long bytesRead;
        Intrinsics.checkNotNullParameter(withRecordReader, (String)"withRecordReader");
        if (!(recordSize > 0L)) {
            boolean bl = false;
            String string = "recordSize " + recordSize + " must be > 0";
            throw new IllegalArgumentException(string.toString());
        }
        long mutablePos = 0L;
        mutablePos = recordPosition;
        long mutableByteCount = 0L;
        for (mutableByteCount = recordSize; mutableByteCount > 0L; mutableByteCount -= bytesRead) {
            bytesRead = this.source.read(this.buffer, mutablePos, mutableByteCount);
            if (!(bytesRead > 0L)) {
                boolean $i$a$-check-RandomAccessHprofReader$readRecord$32 = false;
                String $i$a$-check-RandomAccessHprofReader$readRecord$32 = "Requested " + mutableByteCount + " bytes after reading " + (mutablePos - recordPosition) + ", got 0 bytes instead.";
                throw new IllegalStateException($i$a$-check-RandomAccessHprofReader$readRecord$32.toString());
            }
            mutablePos += bytesRead;
        }
        Object $this$readRecord_u24lambda_u243 = object = withRecordReader.invoke((Object)this.reader);
        boolean bl = false;
        if (!(this.buffer.size() == 0L)) {
            boolean bl2 = false;
            String string = "Buffer not fully consumed: " + this.buffer.size() + " bytes left";
            throw new IllegalStateException(string.toString());
        }
        return (T)object;
    }

    @Override
    public void close() {
        this.source.close();
    }

    public /* synthetic */ RandomAccessHprofReader(RandomAccessSource source, HprofHeader hprofHeader, DefaultConstructorMarker $constructor_marker) {
        this(source, hprofHeader);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lshark/RandomAccessHprofReader$Companion;", "", "()V", "openReaderFor", "Lshark/RandomAccessHprofReader;", "hprofFile", "Ljava/io/File;", "hprofHeader", "Lshark/HprofHeader;", "hprofSourceProvider", "Lshark/RandomAccessSourceProvider;", "shark-hprof"})
    @SourceDebugExtension(value={"SMAP\nRandomAccessHprofReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomAccessHprofReader.kt\nshark/RandomAccessHprofReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RandomAccessHprofReader openReaderFor(@NotNull File hprofFile, @NotNull HprofHeader hprofHeader) {
            Intrinsics.checkNotNullParameter((Object)hprofFile, (String)"hprofFile");
            Intrinsics.checkNotNullParameter((Object)hprofHeader, (String)"hprofHeader");
            FileSourceProvider sourceProvider = new FileSourceProvider(hprofFile);
            return this.openReaderFor(sourceProvider, hprofHeader);
        }

        public static /* synthetic */ RandomAccessHprofReader openReaderFor$default(Companion companion, File file, HprofHeader hprofHeader, int n, Object object) {
            if ((n & 2) != 0) {
                hprofHeader = HprofHeader.Companion.parseHeaderOf(file);
            }
            return companion.openReaderFor(file, hprofHeader);
        }

        @NotNull
        public final RandomAccessHprofReader openReaderFor(@NotNull RandomAccessSourceProvider hprofSourceProvider, @NotNull HprofHeader hprofHeader) {
            Intrinsics.checkNotNullParameter((Object)hprofSourceProvider, (String)"hprofSourceProvider");
            Intrinsics.checkNotNullParameter((Object)hprofHeader, (String)"hprofHeader");
            return new RandomAccessHprofReader(hprofSourceProvider.openRandomAccessSource(), hprofHeader, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static /* synthetic */ RandomAccessHprofReader openReaderFor$default(Companion companion, RandomAccessSourceProvider randomAccessSourceProvider, HprofHeader hprofHeader, int n, Object object) {
            if ((n & 2) != 0) {
                HprofHeader hprofHeader2;
                Closeable closeable = randomAccessSourceProvider.openRandomAccessSource();
                Throwable throwable = null;
                try {
                    RandomAccessSource it = (RandomAccessSource)closeable;
                    boolean bl = false;
                    hprofHeader2 = HprofHeader.Companion.parseHeaderOf(it.asStreamingSource());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                hprofHeader = hprofHeader2;
            }
            return companion.openReaderFor(randomAccessSourceProvider, hprofHeader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

