/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import shark.DualSourceProvider;
import shark.RandomAccessSource;
import shark.SharkLog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lshark/ThrowingCancelableFileSourceProvider;", "Lshark/DualSourceProvider;", "file", "Ljava/io/File;", "throwIfCanceled", "Ljava/lang/Runnable;", "(Ljava/io/File;Ljava/lang/Runnable;)V", "openRandomAccessSource", "Lshark/RandomAccessSource;", "openStreamingSource", "Lokio/BufferedSource;", "shark-hprof"})
public final class ThrowingCancelableFileSourceProvider
implements DualSourceProvider {
    @NotNull
    private final File file;
    @NotNull
    private final Runnable throwIfCanceled;

    public ThrowingCancelableFileSourceProvider(@NotNull File file, @NotNull Runnable throwIfCanceled) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)throwIfCanceled, (String)"throwIfCanceled");
        this.file = file;
        this.throwIfCanceled = throwIfCanceled;
    }

    @Override
    @NotNull
    public BufferedSource openStreamingSource() {
        Source realSource = Okio.source((InputStream)new FileInputStream(this.file));
        BufferedSource bufferedSource = Okio.buffer((Source)new Source(realSource, this){
            private final /* synthetic */ Source $$delegate_0;
            final /* synthetic */ Source $realSource;
            final /* synthetic */ ThrowingCancelableFileSourceProvider this$0;
            {
                this.$realSource = $realSource;
                this.this$0 = $receiver;
                this.$$delegate_0 = $realSource;
            }

            public void close() {
                this.$$delegate_0.close();
            }

            public Timeout timeout() {
                return this.$$delegate_0.timeout();
            }

            public long read(@NotNull Buffer sink, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                ThrowingCancelableFileSourceProvider.access$getThrowIfCanceled$p(this.this$0).run();
                return this.$realSource.read(sink, byteCount);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bufferedSource, (String)"override fun openStreami\u2026Count)\n      }\n    })\n  }");
        return bufferedSource;
    }

    @Override
    @NotNull
    public RandomAccessSource openRandomAccessSource() {
        FileChannel channel = new FileInputStream(this.file).getChannel();
        return new RandomAccessSource(this, channel){
            final /* synthetic */ ThrowingCancelableFileSourceProvider this$0;
            final /* synthetic */ FileChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
            }

            public long read(@NotNull Buffer sink, long position, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                ThrowingCancelableFileSourceProvider.access$getThrowIfCanceled$p(this.this$0).run();
                return this.$channel.transferTo(position, byteCount, (WritableByteChannel)sink);
            }

            public void close() {
                block2: {
                    try {
                        this.$channel.close();
                    }
                    catch (Throwable ignored) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) break block2;
                        SharkLog.Logger logger$iv = logger;
                        Throwable throwable = ignored;
                        SharkLog.Logger logger2 = logger$iv;
                        boolean bl = false;
                        String string = "Failed to close file, ignoring";
                        logger2.d(throwable, string);
                    }
                }
            }

            @NotNull
            public BufferedSource asStreamingSource() {
                return RandomAccessSource.DefaultImpls.asStreamingSource(this);
            }
        };
    }

    public static final /* synthetic */ Runnable access$getThrowIfCanceled$p(ThrowingCancelableFileSourceProvider $this) {
        return $this.throwIfCanceled;
    }
}

