/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentUtils;
import com.stripe.android.view.ViewUtils;

class ShippingMethodView
extends RelativeLayout {
    private ShippingMethod mShippingMethod;
    private TextView mLabel;
    private TextView mDetail;
    private TextView mAmount;
    private ImageView mCheckmark;
    @ColorInt
    int mSelectedColorInt;
    @ColorInt
    int mUnselectedTextColorSecondaryInt;
    @ColorInt
    int mUnselectedTextColorPrimaryInt;

    ShippingMethodView(Context context) {
        super(context);
        this.initView();
    }

    ShippingMethodView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    ShippingMethodView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.mLabel.setTextColor(this.mSelectedColorInt);
            this.mDetail.setTextColor(this.mSelectedColorInt);
            this.mAmount.setTextColor(this.mSelectedColorInt);
            this.mCheckmark.setVisibility(0);
        } else {
            this.mLabel.setTextColor(this.mUnselectedTextColorPrimaryInt);
            this.mDetail.setTextColor(this.mUnselectedTextColorSecondaryInt);
            this.mAmount.setTextColor(this.mUnselectedTextColorPrimaryInt);
            this.mCheckmark.setVisibility(4);
        }
    }

    private void initView() {
        ShippingMethodView.inflate((Context)this.getContext(), (int)R.layout.shipping_method_view, (ViewGroup)this);
        this.mLabel = (TextView)this.findViewById(R.id.tv_label_smv);
        this.mDetail = (TextView)this.findViewById(R.id.tv_detail_smv);
        this.mAmount = (TextView)this.findViewById(R.id.tv_amount_smv);
        this.mCheckmark = (ImageView)this.findViewById(R.id.iv_selected_icon);
        this.mSelectedColorInt = ViewUtils.getThemeAccentColor((Context)this.getContext()).data;
        this.mUnselectedTextColorPrimaryInt = ViewUtils.getThemeTextColorPrimary((Context)this.getContext()).data;
        this.mUnselectedTextColorSecondaryInt = ViewUtils.getThemeTextColorSecondary((Context)this.getContext()).data;
        this.useDefaultColorsIfThemeColorsAreInvisible();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(16);
        params.height = ViewUtils.getPxFromDp(this.getContext(), 72);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void useDefaultColorsIfThemeColorsAreInvisible() {
        Resources res = this.getResources();
        Context context = this.getContext();
        if (Build.VERSION.SDK_INT >= 23) {
            this.mSelectedColorInt = ViewUtils.isColorTransparent(this.mSelectedColorInt) ? res.getColor(R.color.accent_color_default, context.getTheme()) : this.mSelectedColorInt;
            this.mUnselectedTextColorPrimaryInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorPrimaryInt) ? res.getColor(R.color.color_text_unselected_primary_default, context.getTheme()) : this.mUnselectedTextColorPrimaryInt;
            this.mUnselectedTextColorSecondaryInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorSecondaryInt) ? res.getColor(R.color.color_text_unselected_secondary_default, context.getTheme()) : this.mUnselectedTextColorSecondaryInt;
        } else {
            this.mSelectedColorInt = ViewUtils.isColorTransparent(this.mSelectedColorInt) ? res.getColor(R.color.accent_color_default) : this.mSelectedColorInt;
            this.mUnselectedTextColorPrimaryInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorPrimaryInt) ? res.getColor(R.color.color_text_unselected_primary_default) : this.mUnselectedTextColorPrimaryInt;
            this.mUnselectedTextColorSecondaryInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorSecondaryInt) ? res.getColor(R.color.color_text_unselected_secondary_default) : this.mUnselectedTextColorSecondaryInt;
        }
    }

    void setShippingMethod(@NonNull ShippingMethod shippingMethod) {
        this.mShippingMethod = shippingMethod;
        this.mLabel.setText((CharSequence)this.mShippingMethod.getLabel());
        this.mDetail.setText((CharSequence)this.mShippingMethod.getDetail());
        this.mAmount.setText((CharSequence)PaymentUtils.formatPriceStringUsingFree(this.mShippingMethod.getAmount(), this.mShippingMethod.getCurrency(), this.getContext().getString(R.string.price_free)));
    }
}

