/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.cloud_ab.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.cloud.cloud_ab.util.LogUtil;

class SharePreferenceUtil {
    public static final String DEFAULT_NAME = "com.cloud.ab.share_preferences";

    SharePreferenceUtil() {
    }

    public static Object getParam(Context context, String key, Object defaultObject) {
        return SharePreferenceUtil.getParam(context, DEFAULT_NAME, key, defaultObject);
    }

    public static Object getParam(Context context, String spName, String key, Object defaultObject) {
        try {
            String type = defaultObject.getClass().getSimpleName();
            SharedPreferences sp = context.getSharedPreferences(spName, 0);
            if ("String".equals(type)) {
                return sp.getString(key, (String)defaultObject);
            }
            if ("Integer".equals(type)) {
                return sp.getInt(key, ((Integer)defaultObject).intValue());
            }
            if ("Boolean".equals(type)) {
                return sp.getBoolean(key, ((Boolean)defaultObject).booleanValue());
            }
            if ("Float".equals(type)) {
                return Float.valueOf(sp.getFloat(key, ((Float)defaultObject).floatValue()));
            }
            if ("Long".equals(type)) {
                return sp.getLong(key, ((Long)defaultObject).longValue());
            }
        }
        catch (Throwable e) {
            LogUtil.printLog("ClassCastException:" + e);
        }
        return defaultObject;
    }

    public static void setParam(Context context, String key, Object object) {
        SharePreferenceUtil.setParam(context, DEFAULT_NAME, key, object);
    }

    public static void setParam(Context context, String spName, String key, Object object) {
        try {
            String type = object.getClass().getSimpleName();
            SharedPreferences sp = context.getSharedPreferences(spName, 0);
            SharedPreferences.Editor editor = sp.edit();
            if ("String".equals(type)) {
                editor.putString(key, (String)object);
            } else if ("Integer".equals(type)) {
                editor.putInt(key, ((Integer)object).intValue());
            } else if ("Boolean".equals(type)) {
                editor.putBoolean(key, ((Boolean)object).booleanValue());
            } else if ("Float".equals(type)) {
                editor.putFloat(key, ((Float)object).floatValue());
            } else if ("Long".equals(type)) {
                editor.putLong(key, ((Long)object).longValue());
            }
            editor.apply();
        }
        catch (Throwable t) {
            LogUtil.printLog("setParam Exception:" + t.getMessage());
        }
    }
}

