/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.master.widget;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/talpa/master/widget/FastBlurUtility;", "", "()V", "big", "Landroid/graphics/Bitmap;", "bitmap", "fastblur", "sentBitmap", "radius", "", "getBlurBackgroundDrawer", "activity", "Landroid/app/Activity;", "small", "startBlurBackground", "bkg", "takeScreenShot", "Translate_release"})
public final class FastBlurUtility {
    @NotNull
    public static final FastBlurUtility INSTANCE = new FastBlurUtility();

    private FastBlurUtility() {
    }

    @NotNull
    public final Bitmap getBlurBackgroundDrawer(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Bitmap bmp = this.takeScreenShot(activity);
        return this.startBlurBackground(bmp);
    }

    private final Bitmap takeScreenShot(Activity activity) {
        Bitmap bitmap;
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
        View view2 = view;
        view2.setDrawingCacheEnabled(true);
        view2.buildDrawingCache();
        Bitmap b1 = null;
        if (view2.getDrawingCache() != null) {
            b1 = view2.getDrawingCache();
        }
        int width = activity.getResources().getDisplayMetrics().widthPixels;
        int height = activity.getResources().getDisplayMetrics().heightPixels;
        Bitmap bitmap2 = b1;
        if (bitmap2 == null) {
            bitmap = null;
        } else {
            Bitmap bitmap3 = bitmap2;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap3;
            boolean bl3 = false;
            bitmap = Bitmap.createBitmap((Bitmap)it, (int)0, (int)0, (int)width, (int)height);
        }
        Bitmap bmp = bitmap;
        view2.destroyDrawingCache();
        Bitmap bitmap4 = bmp;
        Intrinsics.checkNotNull(bitmap4);
        return bitmap4;
    }

    private final Bitmap startBlurBackground(Bitmap bkg) {
        long startMs = System.currentTimeMillis();
        float radius = 10.0f;
        Bitmap overlay = this.fastblur(this.small(bkg), (int)radius);
        Log.i((String)"FastBlurUtility", (String)Intrinsics.stringPlus((String)"=====blur time:", (Object)(System.currentTimeMillis() - startMs)));
        return this.big(overlay);
    }

    private final Bitmap big(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postScale(4.0f, 4.0f);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(bitmap!!, 0, 0, bitmap.width, bitmap.height, matrix, true)");
        return bitmap3;
    }

    private final Bitmap small(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postScale(0.25f, 0.25f);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(bitmap, 0, 0, bitmap.width, bitmap.height, matrix, true)");
        return bitmap2;
    }

    private final Bitmap fastblur(Bitmap sentBitmap, int radius) {
        int n;
        Bitmap bitmap = sentBitmap.copy(sentBitmap.getConfig(), true);
        if (radius < 1) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pix = new int[w * h];
        bitmap.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int x = 0;
        int y = 0;
        int i = 0;
        int p = 0;
        int yp = 0;
        int yi = 0;
        int yw = 0;
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        i = 0;
        while (i < 256 * divsum) {
            dv[i] = i / divsum;
            int n2 = i;
            i = n2 + 1;
        }
        yw = yi = 0;
        int n3 = 0;
        int n4 = div;
        int[][] nArrayArray = new int[n4][];
        while (n3 < n4) {
            int n5 = n3++;
            nArrayArray[n5] = new int[3];
        }
        int[][] stack = nArrayArray;
        int stackpointer = 0;
        int stackstart = 0;
        int[] sir = null;
        int rbs = 0;
        int r1 = radius + 1;
        int routsum = 0;
        int goutsum = 0;
        int boutsum = 0;
        int rinsum = 0;
        int ginsum = 0;
        int binsum = 0;
        y = 0;
        while (y < h) {
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            i = -radius;
            while (i <= radius) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                n = i;
                i = n + 1;
            }
            stackpointer = radius;
            x = 0;
            while (x < w) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                n = yi;
                yi = n + 1;
                n = x;
                x = n + 1;
            }
            yw += w;
            n = y;
            y = n + 1;
        }
        x = 0;
        while (x < w) {
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            yp = -radius * w;
            i = -radius;
            while (i <= radius) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i < hm) {
                    yp += w;
                }
                n = i;
                i = n + 1;
            }
            yi = x;
            stackpointer = radius;
            y = 0;
            while (y < h) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
                n = y;
                y = n + 1;
            }
            n = x;
            x = n + 1;
        }
        bitmap.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap;
    }
}

