/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.trancare;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.trancare.OnConnectionSucceedListener;
import com.transsion.trancare.frameworks.cloudengine.app.ICloudEngineCallback;
import com.transsion.trancare.frameworks.cloudengine.app.ICloudEngineInterface;
import java.lang.reflect.Method;

public class CloudEngine {
    private static final String TAG = "CloudEngineSDK";
    private final ComponentName mComponentName = new ComponentName("com.transsion.trancare", "com.transsion.trancare.frameworks.cloudengine.CloudEngineService");
    private static Class<?> sCloudEngineClass;
    private ICloudEngineInterface mICloudEngineInterface;
    private boolean mIsConnected = false;
    private Context mContext;
    private CloudEngineConnect mCloudEngineConnect;
    private OnConnectionSucceedListener mListener;
    private static final int SDK_INT;

    public static CloudEngine getInstance() {
        return Holder.INSTANCE;
    }

    private CloudEngine() {
        Log.d((String)TAG, (String)"1.0.8");
        sCloudEngineClass = CloudEngine.getAthenaService();
        if (sCloudEngineClass == null) {
            Log.w((String)TAG, (String)"Class is null,Please check for support cloud engine!!!!!!!");
        }
    }

    public static int getVersionCode() {
        return 8;
    }

    public static String getVersionName() {
        return "1.0.8";
    }

    public CloudEngine init(Context context) {
        if (SDK_INT <= 29) {
            new Throwable("only support android R and above!!!");
        }
        this.mContext = context;
        this.mCloudEngineConnect = new CloudEngineConnect();
        this.bindService();
        return Holder.INSTANCE;
    }

    public CloudEngine addOnConnectionSucceedListener(OnConnectionSucceedListener listener) {
        this.mListener = listener;
        return Holder.INSTANCE;
    }

    public boolean connected() {
        return this.mIsConnected;
    }

    public String getFilePath(String key) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getFilePath", String.class);
                ret = (String)method.invoke(null, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = null;
        }
        return ret;
    }

    public String getDefaultFilePath(String key) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getDefaultFilePath", String.class);
                ret = (String)method.invoke(null, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = null;
        }
        return ret;
    }

    public String getFileContent(String key, String fileName) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getFileContent", String.class, String.class);
                ret = (String)method.invoke(null, key, fileName);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public String getDefaultFileContent(String key, String fileName) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getDefaultFileContent", String.class, String.class);
                ret = (String)method.invoke(null, key, fileName);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public String getDefaultConfig(String key) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getDefaultConfig", String.class);
                ret = (String)method.invoke(null, key);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public String getConfig(String key) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getConfig", String.class);
                ret = (String)method.invoke(null, key);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public String getAsString(String key, String name, boolean def) {
        String ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getAsString", String.class, String.class, Boolean.TYPE);
                ret = (String)method.invoke(null, key, name, def);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public boolean getAsBoolean(String key, String name, boolean def) {
        boolean ret = false;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getAsBoolean", String.class, String.class, Boolean.TYPE);
                ret = (Boolean)method.invoke(null, key, name, def);
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public long getAsLong(String key, String name, boolean def) {
        long ret = 0L;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getAsLong", String.class, String.class, Boolean.TYPE);
                ret = (Long)method.invoke(null, key, name, def);
            }
        }
        catch (Exception e) {
            ret = 0L;
        }
        return ret;
    }

    public String[] getAsStringArray(String key, String name, boolean def) {
        String[] ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getAsStringArray", String.class, String.class, Boolean.TYPE);
                ret = (String[])method.invoke(null, key, name, def);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public boolean[] getAsBooleanArray(String key, String name, boolean def) {
        boolean[] ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getAsBooleanArray", String.class, String.class, Boolean.TYPE);
                ret = (boolean[])method.invoke(null, key, name, def);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public long[] getAsLongArray(String key, String name, boolean def) {
        long[] ret = null;
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("getAsLongArray", String.class, String.class, Boolean.TYPE);
                ret = (long[])method.invoke(null, key, name, def);
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public void putConfig(String key, String value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putConfig", String.class, String.class);
                method.invoke(null, key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAsString(String key, String name, String value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putAsString", String.class, String.class, String.class);
                method.invoke(null, key, name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAsBoolean(String key, String name, boolean value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putAsBoolean", String.class, String.class, Boolean.TYPE);
                method.invoke(null, key, name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAsLong(String key, String name, long value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putAsLong", String.class, String.class, Long.TYPE);
                method.invoke(null, key, name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAsStringArray(String key, String name, String[] value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putAsStringArray", String.class, String.class, String[].class);
                method.invoke(null, key, name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAsBooleanArray(String key, String name, boolean[] value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putAsBooleanArray", String.class, String.class, boolean[].class);
                method.invoke(null, key, name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAsLongArray(String key, String name, long[] value) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("putAsLongArray", String.class, String.class, long[].class);
                method.invoke(null, key, name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feedBack(String key, boolean state) {
        try {
            if (sCloudEngineClass != null) {
                Method method = sCloudEngineClass.getDeclaredMethod("feedBack", String.class, Boolean.TYPE);
                method.invoke(null, key, state);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void regCloudEngineCallback(String key, String version, ICloudEngineCallback callback) {
        if (this.mICloudEngineInterface != null) {
            try {
                this.mICloudEngineInterface.regCloudEngineCallback(key, version, callback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public void unregCloudEngineCallback(String key, ICloudEngineCallback callback) {
        if (this.mICloudEngineInterface != null) {
            try {
                this.mICloudEngineInterface.unregCloudEngineCallback(key, callback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindService() {
        Intent intent = new Intent();
        intent.setComponent(this.mComponentName);
        this.mContext.bindService(intent, (ServiceConnection)this.mCloudEngineConnect, 1);
    }

    private static Class<?> getAthenaService() {
        try {
            if (sCloudEngineClass == null) {
                String className = "com.transsion.log.cloudengine.CloudEngine";
                sCloudEngineClass = Class.forName(className);
            }
        }
        catch (Exception e) {
            return null;
        }
        return sCloudEngineClass;
    }

    static {
        SDK_INT = Build.VERSION.SDK_INT;
    }

    private class CloudEngineConnect
    implements ServiceConnection {
        private CloudEngineConnect() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.w((String)CloudEngine.TAG, (String)("[onServiceConnected] name = " + name.toString()));
            CloudEngine.this.mICloudEngineInterface = ICloudEngineInterface.Stub.asInterface(service);
            CloudEngine.this.mIsConnected = true;
            if (CloudEngine.this.mListener != null) {
                CloudEngine.this.mListener.onConnectionSucceed();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.w((String)CloudEngine.TAG, (String)("[onServiceDisconnected] name = " + name.toString()));
            CloudEngine.this.mIsConnected = false;
        }

        public void onBindingDied(ComponentName name) {
            Log.w((String)CloudEngine.TAG, (String)("[onBindingDied] name = " + name.toString()));
            CloudEngine.this.mIsConnected = false;
        }

        public void onNullBinding(ComponentName name) {
            Log.w((String)CloudEngine.TAG, (String)("[onNullBinding] name = " + name.toString()));
            CloudEngine.this.mIsConnected = false;
        }
    }

    private static class Holder {
        private static CloudEngine INSTANCE = new CloudEngine();

        private Holder() {
        }
    }
}

